/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.MessageArgs;
import org.redisson.api.queue.DeduplicationMode;

public final class MessageParams<V>
implements MessageArgs<V> {
    private long retentionDuration;
    private int receiveLimit = 0;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private final V payload;
    private int priority;
    private DeduplicationMode deduplicationMode;
    private Duration deduplicationInterval;
    private Object deduplicationId;
    private Duration delayInterval = Duration.ZERO;

    public MessageParams(V value) {
        this.payload = value;
    }

    @Override
    public MessageArgs<V> priority(int priority) {
        if (priority < 0 || priority > 9) {
            throw new IllegalArgumentException("Priority should be from 0 to 9, but was " + priority);
        }
        this.priority = priority;
        return this;
    }

    @Override
    public MessageArgs<V> delay(Duration interval) {
        this.delayInterval = interval;
        return this;
    }

    @Override
    public MessageArgs<V> timeToLive(Duration duration) {
        this.retentionDuration = duration.toMillis();
        return this;
    }

    @Override
    public MessageArgs<V> deliveryLimit(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("value can't be lower than 1");
        }
        this.receiveLimit = value;
        return this;
    }

    @Override
    public MessageArgs<V> header(String key, Object value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public MessageArgs<V> headers(Map<String, Object> entries) {
        this.headers.putAll(entries);
        return this;
    }

    @Override
    public MessageArgs<V> deduplicationByHash(Duration interval) {
        this.deduplicationMode = DeduplicationMode.HASH;
        this.deduplicationInterval = interval;
        return this;
    }

    @Override
    public MessageArgs<V> deduplicationById(Object id, Duration interval) {
        Objects.requireNonNull(id);
        this.deduplicationMode = DeduplicationMode.ID;
        this.deduplicationId = id;
        this.deduplicationInterval = interval;
        return this;
    }

    public MessageArgs<V> deduplicationByHash() {
        this.deduplicationMode = DeduplicationMode.HASH;
        return this;
    }

    public MessageArgs<V> deduplicationById(Object id) {
        this.deduplicationMode = DeduplicationMode.ID;
        this.deduplicationId = id;
        return this;
    }

    public long getRetentionDuration() {
        return this.retentionDuration;
    }

    public int getReceiveLimit() {
        return this.receiveLimit;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public V getPayload() {
        return this.payload;
    }

    public DeduplicationMode getDeduplicationMode() {
        return this.deduplicationMode;
    }

    public Duration getDeduplicationInterval() {
        return this.deduplicationInterval;
    }

    public Object getDeduplicationId() {
        return this.deduplicationId;
    }

    public Duration getDelayInterval() {
        return this.delayInterval;
    }

    public int getPriority() {
        return this.priority;
    }
}

