/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LockEntry {
    final Queue<Long> threadsQueue = new ConcurrentLinkedQueue<Long>();
    final Map<Long, Integer> threadId2counter = new ConcurrentHashMap<Long, Integer>();
    final Map<Long, String> threadId2lockName = new ConcurrentHashMap<Long, String>();

    LockEntry() {
    }

    public String getLockName(long threadId) {
        return this.threadId2lockName.get(threadId);
    }

    public void addThreadId(long threadId, String lockName) {
        this.threadId2counter.compute(threadId, (t, counter) -> {
            Integer n = counter = Optional.ofNullable(counter).orElse(0);
            counter = counter + 1;
            this.threadsQueue.add(threadId);
            return counter;
        });
        this.threadId2lockName.putIfAbsent(threadId, lockName);
    }

    public boolean hasNoThreads() {
        return this.threadsQueue.isEmpty();
    }

    public Long getFirstThreadId() {
        return this.threadsQueue.peek();
    }

    public void removeThreadId(long threadId) {
        this.threadId2counter.computeIfPresent(threadId, (t, counter) -> {
            Integer n = counter;
            counter = counter - 1;
            if (counter == 0) {
                this.threadsQueue.removeIf(v -> v == threadId);
                this.threadId2lockName.remove(threadId);
                return null;
            }
            return counter;
        });
    }
}

