/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.misc.RPromise;

public class CountableListener<T>
implements FutureListener<Object> {
    protected final AtomicInteger counter = new AtomicInteger();
    protected final RPromise<T> result;
    protected final T value;

    public CountableListener(RPromise<T> result, T value) {
        this.result = result;
        this.value = value;
    }

    public void incCounter() {
        this.counter.incrementAndGet();
    }

    @Override
    public void operationComplete(Future<Object> future) throws Exception {
        if (!future.isSuccess()) {
            this.result.tryFailure(future.cause());
            return;
        }
        if (this.counter.decrementAndGet() == 0) {
            this.result.trySuccess(this.value);
        }
    }
}

