/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

final class ExecutorServiceWorker
implements Scheduler.Worker,
Disposable {
    final ScheduledExecutorService exec;
    final Disposable.Composite tasks;

    ExecutorServiceWorker(ScheduledExecutorService exec) {
        this.exec = exec;
        this.tasks = Disposables.composite();
    }

    @Override
    public Disposable schedule(Runnable task) {
        return Schedulers.workerSchedule(this.exec, this.tasks, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        return Schedulers.workerSchedule(this.exec, this.tasks, task, delay, unit);
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return Schedulers.workerSchedulePeriodically(this.exec, this.tasks, task, initialDelay, period, unit);
    }

    @Override
    public void dispose() {
        this.tasks.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.tasks.isDisposed();
    }
}

