/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.api.RFuture;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonLexSortedSet
extends RedissonScoredSortedSet<String>
implements RLexSortedSet {
    public RedissonLexSortedSet(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(StringCodec.INSTANCE, commandExecutor, name, redisson);
    }

    @Override
    public int removeRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.get(this.removeRangeAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public int removeRangeHead(String toElement, boolean toInclusive) {
        return this.get(this.removeRangeHeadAsync(toElement, toInclusive));
    }

    @Override
    public RFuture<Integer> removeRangeHeadAsync(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), "-", toValue);
    }

    @Override
    public int removeRangeTail(String fromElement, boolean fromInclusive) {
        return this.get(this.removeRangeTailAsync(fromElement, fromInclusive));
    }

    @Override
    public RFuture<Integer> removeRangeTailAsync(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), fromValue, "+");
    }

    @Override
    public RFuture<Integer> removeRangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), fromValue, toValue);
    }

    @Override
    public Collection<String> range(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.get(this.rangeAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public Collection<String> rangeHead(String toElement, boolean toInclusive) {
        return this.get(this.rangeHeadAsync(toElement, toInclusive));
    }

    @Override
    public RFuture<Collection<String>> rangeHeadAsync(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), "-", toValue);
    }

    @Override
    public Collection<String> rangeTail(String fromElement, boolean fromInclusive) {
        return this.get(this.rangeTailAsync(fromElement, fromInclusive));
    }

    @Override
    public RFuture<Collection<String>> rangeTailAsync(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, "+");
    }

    @Override
    public RFuture<Collection<String>> rangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, toValue);
    }

    @Override
    public Collection<String> range(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        return this.get(this.rangeAsync(fromElement, fromInclusive, toElement, toInclusive, offset, count));
    }

    @Override
    public Collection<String> rangeHead(String toElement, boolean toInclusive, int offset, int count) {
        return this.get(this.rangeHeadAsync(toElement, toInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<String>> rangeHeadAsync(String toElement, boolean toInclusive, int offset, int count) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), "-", toValue, "LIMIT", offset, count);
    }

    @Override
    public Collection<String> rangeTail(String fromElement, boolean fromInclusive, int offset, int count) {
        return this.get(this.rangeTailAsync(fromElement, fromInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<String>> rangeTailAsync(String fromElement, boolean fromInclusive, int offset, int count) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, "+", "LIMIT", offset, count);
    }

    @Override
    public RFuture<Collection<String>> rangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, toValue, "LIMIT", offset, count);
    }

    @Override
    public int countTail(String fromElement, boolean fromInclusive) {
        return this.get(this.countTailAsync(fromElement, fromInclusive));
    }

    @Override
    public RFuture<Integer> countTailAsync(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), fromValue, "+");
    }

    @Override
    public int countHead(String toElement, boolean toInclusive) {
        return this.get(this.countHeadAsync(toElement, toInclusive));
    }

    @Override
    public RFuture<Integer> countHeadAsync(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), "-", toValue);
    }

    @Override
    public int count(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.get(this.countAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public RFuture<Integer> countAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), fromValue, toValue);
    }

    private String value(String fromElement, boolean fromInclusive) {
        String fromValue = fromElement.toString();
        fromValue = fromInclusive ? "[" + fromValue : "(" + fromValue;
        return fromValue;
    }

    @Override
    public RFuture<Boolean> addAsync(String e) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_BOOL_RAW, this.getName(), 0, e);
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends String> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<Object> params = new ArrayList<Object>(2 * c.size());
        params.add(this.getName());
        for (String string : c) {
            params.add(0);
            params.add(string);
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_BOOL_RAW, params.toArray());
    }

    @Override
    public boolean add(String e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public Collection<String> range(int startIndex, int endIndex) {
        return this.valueRange(startIndex, endIndex);
    }

    @Override
    public RFuture<Collection<String>> rangeAsync(int startIndex, int endIndex) {
        return this.valueRangeAsync(startIndex, endIndex);
    }

    @Override
    public boolean trySetComparator(Comparator<? super String> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super String> comparator() {
        return null;
    }

    @Override
    public SortedSet<String> subSet(String fromElement, String toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<String> headSet(String toElement) {
        return this.subSet(null, toElement);
    }

    @Override
    public SortedSet<String> tailSet(String fromElement) {
        return this.subSet(fromElement, null);
    }
}

