/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import org.redisson.cache.CachedValue;
import org.redisson.misc.WrappedLock;

public class StdCachedValue<K, V>
implements CachedValue<K, V> {
    private final K key;
    private final V value;
    private long ttl;
    private long maxIdleTime;
    private long creationTime;
    private long lastAccess;
    private final WrappedLock lock = new WrappedLock();

    public StdCachedValue(K key, V value, long ttl, long maxIdleTime) {
        this.value = value;
        this.ttl = ttl;
        this.key = key;
        this.maxIdleTime = maxIdleTime;
        if (ttl != 0L || maxIdleTime != 0L) {
            this.lastAccess = this.creationTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isExpired() {
        if (this.maxIdleTime == 0L && this.ttl == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (this.ttl != 0L && this.creationTime + this.ttl < currentTime) {
            return true;
        }
        return this.maxIdleTime != 0L && this.lastAccess + this.maxIdleTime < currentTime;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        this.lastAccess = System.currentTimeMillis();
        return this.value;
    }

    public String toString() {
        return "CachedValue [key=" + this.key + ", value=" + this.value + "]";
    }

    @Override
    public WrappedLock getLock() {
        return this.lock;
    }
}

