/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.redisson.SlotCallback;
import org.redisson.api.BatchOptions;
import org.redisson.api.RFuture;
import org.redisson.api.options.ObjectParams;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.ServiceManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;

public interface CommandAsyncExecutor {
    public CommandAsyncExecutor copy(ObjectParams var1);

    public CommandAsyncExecutor copy(boolean var1);

    public RedissonObjectBuilder getObjectBuilder();

    public ConnectionManager getConnectionManager();

    public ServiceManager getServiceManager();

    public RedisException convertException(ExecutionException var1);

    public <V> void transfer(CompletionStage<V> var1, CompletableFuture<V> var2);

    public <V> V getNow(CompletableFuture<V> var1);

    public <V> V get(RFuture<V> var1);

    public <V> V get(CompletableFuture<V> var1);

    public <V> V getInterrupted(RFuture<V> var1) throws InterruptedException;

    public <V> V getInterrupted(CompletableFuture<V> var1) throws InterruptedException;

    public <T, R> RFuture<R> writeAsync(RedisClient var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> writeAsync(MasterSlaveEntry var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> writeAsync(byte[] var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> writeAsync(ByteBuf var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> readAsync(RedisClient var1, MasterSlaveEntry var2, Codec var3, RedisCommand<T> var4, Object ... var5);

    public <T, R> RFuture<R> readAsync(RedisClient var1, String var2, Codec var3, RedisCommand<T> var4, Object ... var5);

    public <T, R> RFuture<R> readAsync(RedisClient var1, byte[] var2, Codec var3, RedisCommand<T> var4, Object ... var5);

    public <T, R> RFuture<R> readAsync(RedisClient var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <R> List<CompletableFuture<R>> executeAllAsync(MasterSlaveEntry var1, RedisCommand<?> var2, Object ... var3);

    public <R> List<CompletableFuture<R>> executeAllAsync(RedisCommand<?> var1, Object ... var2);

    public <R> List<CompletableFuture<R>> writeAllAsync(RedisCommand<?> var1, Object ... var2);

    public <R> List<CompletableFuture<R>> writeAllAsync(Codec var1, RedisCommand<?> var2, Object ... var3);

    public <R> List<CompletableFuture<R>> readAllAsync(Codec var1, RedisCommand<?> var2, Object ... var3);

    public <R> List<CompletableFuture<R>> readAllAsync(RedisCommand<?> var1, Object ... var2);

    public <T, R> RFuture<R> evalReadAsync(RedisClient var1, String var2, Codec var3, RedisCommand<T> var4, String var5, List<Object> var6, Object ... var7);

    public <T, R> RFuture<R> evalReadAsync(String var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> evalReadAsync(MasterSlaveEntry var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> evalReadAsync(RedisClient var1, MasterSlaveEntry var2, Codec var3, RedisCommand<T> var4, String var5, List<Object> var6, Object ... var7);

    public <T, R> RFuture<R> evalReadAsync(ByteBuf var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> evalWriteAsync(String var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> evalWriteAsync(ByteBuf var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> evalWriteNoRetryAsync(String var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> evalWriteAsync(MasterSlaveEntry var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T, R> RFuture<R> readAsync(byte[] var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> readAsync(ByteBuf var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> readAsync(String var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> writeAsync(String var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T> RFuture<Void> writeAllVoidAsync(RedisCommand<T> var1, Object ... var2);

    public <T, R> RFuture<R> writeAsync(String var1, RedisCommand<T> var2, Object ... var3);

    public <T, R> RFuture<R> readAsync(String var1, RedisCommand<T> var2, Object ... var3);

    public <T, R> RFuture<R> readAsync(MasterSlaveEntry var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <T, R> RFuture<R> readRandomAsync(Codec var1, RedisCommand<T> var2, Object ... var3);

    public <T, R> RFuture<R> readRandomAsync(RedisClient var1, Codec var2, RedisCommand<T> var3, Object ... var4);

    public <V> RFuture<V> pollFromAnyAsync(String var1, Codec var2, RedisCommand<?> var3, long var4, String ... var6);

    public ByteBuf encode(Codec var1, Object var2);

    public ByteBuf encodeMapKey(Codec var1, Object var2);

    public ByteBuf encodeMapValue(Codec var1, Object var2);

    public <T, R> RFuture<R> readBatchedAsync(Codec var1, RedisCommand<T> var2, SlotCallback<T, R> var3, Object ... var4);

    public <T, R> RFuture<R> writeBatchedAsync(Codec var1, RedisCommand<T> var2, SlotCallback<T, R> var3, Object ... var4);

    public <T, R> RFuture<R> evalWriteBatchedAsync(Codec var1, RedisCommand<T> var2, String var3, List<Object> var4, SlotCallback<T, R> var5);

    public <T, R> RFuture<R> evalReadBatchedAsync(Codec var1, RedisCommand<T> var2, String var3, List<Object> var4, SlotCallback<T, R> var5);

    public boolean isEvalShaROSupported();

    public void setEvalShaROSupported(boolean var1);

    public <T> RFuture<T> syncedEvalWithRetry(String var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T> RFuture<T> syncedEvalNoRetry(String var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T> RFuture<T> syncedEvalNoRetry(long var1, SyncMode var3, String var4, Codec var5, RedisCommand<T> var6, String var7, List<Object> var8, Object ... var9);

    public <T> RFuture<T> syncedEvalWithRetry(long var1, SyncMode var3, String var4, Codec var5, RedisCommand<T> var6, String var7, List<Object> var8, Object ... var9);

    public <T> RFuture<T> syncedEval(String var1, Codec var2, RedisCommand<T> var3, String var4, List<Object> var5, Object ... var6);

    public <T> CompletionStage<T> handleNoSync(CompletionStage<T> var1, Supplier<CompletionStage<?>> var2);

    public boolean isTrackChanges();

    public CommandBatchService createCommandBatchService(BatchOptions var1);

    public static CommandAsyncExecutor create(ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType) {
        return new CommandAsyncService(connectionManager, objectBuilder, referenceType);
    }

    public static enum SyncMode {
        AUTO,
        WAIT,
        WAIT_AOF;

    }
}

