/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisRetryException;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnectionHandler<C extends RedisConnection>
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(BaseConnectionHandler.class);
    final RedisClient redisClient;
    final CompletableFuture<C> connectionPromise = new CompletableFuture();
    C connection;

    public BaseConnectionHandler(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection(ctx);
        }
        super.channelRegistered(ctx);
    }

    abstract C createConnection(ChannelHandlerContext var1);

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        Future<Object> future;
        ArrayList futures = new ArrayList(5);
        CompletableFuture<Object> f = this.authWithCredential();
        futures.add(f);
        RedisClientConfig config = this.redisClient.getConfig();
        if (config.getProtocol() == Protocol.RESP3) {
            RFuture f1 = ((RedisConnection)this.connection).async(RedisCommands.HELLO, "3");
            futures.add(f1.toCompletableFuture());
        }
        if (config.getDatabase() != 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.SELECT, config.getDatabase());
            futures.add(future.toCompletableFuture());
        }
        if (config.getClientName() != null) {
            future = ((RedisConnection)this.connection).async(RedisCommands.CLIENT_SETNAME, config.getClientName());
            futures.add(future.toCompletableFuture());
        }
        if (config.isReadOnly()) {
            future = ((RedisConnection)this.connection).async(RedisCommands.READONLY, new Object[0]);
            futures.add(future.toCompletableFuture());
        }
        if (config.getPingConnectionInterval() > 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.PING, new Object[0]);
            futures.add(future.toCompletableFuture());
        }
        future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)future).whenComplete((res, e) -> {
            if (e != null) {
                if (e instanceof RedisRetryException) {
                    ctx.executor().schedule(() -> this.channelActive(ctx), 1L, TimeUnit.SECONDS);
                    return;
                }
                ((RedisConnection)this.connection).closeAsync();
                this.connectionPromise.completeExceptionally((Throwable)e);
                return;
            }
            if (config.getCredentialsReapplyInterval() > 0) {
                this.reapplyCredential(ctx);
            }
            ctx.fireChannelActive();
            this.connectionPromise.complete(this.connection);
        });
    }

    private CompletableFuture<Object> authWithCredential() {
        RedisClientConfig config = this.redisClient.getConfig();
        InetSocketAddress addr = this.redisClient.resolveAddr().getNow(null);
        CompletionStage f = config.getCredentialsResolver().resolve(addr).thenCompose(credentials -> {
            String password = Objects.toString(config.getAddress().getPassword(), Objects.toString(credentials.getPassword(), config.getPassword()));
            if (password != null) {
                String username = Objects.toString(config.getAddress().getUsername(), Objects.toString(credentials.getUsername(), config.getUsername()));
                RFuture future = username != null ? ((RedisConnection)this.connection).async(RedisCommands.AUTH, username, password) : ((RedisConnection)this.connection).async(RedisCommands.AUTH, password);
                return future;
            }
            return CompletableFuture.completedFuture(null);
        });
        return f.toCompletableFuture();
    }

    private void reapplyCredential(ChannelHandlerContext ctx) {
        if (BaseConnectionHandler.isClosed(ctx, this.connection)) {
            return;
        }
        QueueCommand currentCommand = ((RedisConnection)this.connection).getCurrentCommandData();
        CompletableFuture<Object> future = ((RedisConnection)this.connection).getUsage() == 0 && (currentCommand == null || !currentCommand.isBlockingCommand()) ? this.authWithCredential() : null;
        RedisClientConfig config = this.redisClient.getConfig();
        config.getTimer().newTimeout(timeout -> {
            if (BaseConnectionHandler.isClosed(ctx, this.connection)) {
                return;
            }
            QueueCommand cd = ((RedisConnection)this.connection).getCurrentCommandData();
            if (cd != null && cd.isBlockingCommand()) {
                this.reapplyCredential(ctx);
                return;
            }
            if (((RedisConnection)this.connection).getUsage() == 0 && future != null && (future.cancel(false) || this.cause(future) != null)) {
                Throwable cause = this.cause(future);
                if (!(cause instanceof RedisRetryException)) {
                    if (!future.isCancelled()) {
                        log.error("Unable to send AUTH command over channel: {}", (Object)ctx.channel(), (Object)cause);
                    }
                    log.debug("channel: {} closed due to AUTH response timeout set in {} ms", (Object)ctx.channel(), (Object)config.getCredentialsReapplyInterval());
                    ctx.channel().close();
                } else {
                    this.reapplyCredential(ctx);
                }
            } else {
                this.reapplyCredential(ctx);
            }
        }, config.getCredentialsReapplyInterval(), TimeUnit.MILLISECONDS);
    }

    protected Throwable cause(CompletableFuture<?> future) {
        try {
            future.toCompletableFuture().getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }

    private static boolean isClosed(ChannelHandlerContext ctx, RedisConnection connection) {
        return connection.isClosed() || !ctx.channel().equals(connection.getChannel()) || ctx.isRemoved() || connection.getRedisClient().isShutdown();
    }
}

