/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class Message<V> {
    String id;
    V payload;
    Map<String, Object> headers;

    public Message(String id, V payload, Map<String, Object> headers) {
        this.id = id;
        this.payload = payload;
        this.headers = Collections.unmodifiableMap(headers);
    }

    public <T> Map<String, T> getHeaders() {
        return this.headers;
    }

    public String getId() {
        return this.id;
    }

    public V getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.id, message.id) && Objects.equals(this.payload, message.payload) && Objects.equals(this.headers, message.headers);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.payload, this.headers);
    }

    public String toString() {
        return "Message{id='" + this.id + '\'' + ", payload=" + this.payload + ", headers=" + this.headers + '}';
    }
}

