/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.misc.FastRemovalQueue;

public final class AsyncSemaphore {
    private final ExecutorService executorService;
    private final AtomicInteger tasksLatch = new AtomicInteger(1);
    private final AtomicInteger stackSize = new AtomicInteger();
    private final AtomicInteger counter;
    private final FastRemovalQueue<CompletableFuture<Void>> listeners = new FastRemovalQueue();

    public AsyncSemaphore(int permits) {
        this(permits, null);
    }

    public AsyncSemaphore(int permits, ExecutorService executorService) {
        this.counter = new AtomicInteger(permits);
        this.executorService = executorService;
    }

    public int queueSize() {
        return this.listeners.size();
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public CompletableFuture<Void> acquire() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listeners.add(future);
        future.whenComplete((r, e) -> {
            if (e != null) {
                this.listeners.remove(future);
            }
        });
        this.tryForkAndRun();
        return future;
    }

    private void tryForkAndRun() {
        if (this.executorService != null) {
            int val = this.tasksLatch.get();
            if (this.stackSize.get() > 25 * val && this.tasksLatch.compareAndSet(val, val + 1)) {
                this.executorService.submit(() -> {
                    this.tasksLatch.decrementAndGet();
                    this.tryRun();
                });
                return;
            }
        }
        this.tryRun();
    }

    private void tryRun() {
        do {
            boolean complete;
            if (this.counter.decrementAndGet() < 0) continue;
            CompletableFuture<Void> future = this.listeners.poll();
            if (future == null) {
                this.counter.incrementAndGet();
                return;
            }
            if (this.executorService != null) {
                this.stackSize.incrementAndGet();
                complete = future.complete(null);
                this.stackSize.decrementAndGet();
            } else {
                complete = future.complete(null);
            }
            if (!complete) continue;
            return;
        } while (this.counter.incrementAndGet() > 0);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void release() {
        this.counter.incrementAndGet();
        this.tryForkAndRun();
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }
}

