/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBinaryStream;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBloomFilter;
import org.redisson.RedissonBucket;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonDeque;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonFasterMultiLock;
import org.redisson.RedissonFencedLock;
import org.redisson.RedissonFuction;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonIdGenerator;
import org.redisson.RedissonJsonBucket;
import org.redisson.RedissonJsonBuckets;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonListMultimapCacheNative;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonMapCacheNative;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonObject;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonRedLock;
import org.redisson.RedissonReliableTopic;
import org.redisson.RedissonRemoteService;
import org.redisson.RedissonRingBuffer;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSearch;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonSetMultimapCache;
import org.redisson.RedissonSetMultimapCacheNative;
import org.redisson.RedissonShardedTopic;
import org.redisson.RedissonSpinLock;
import org.redisson.RedissonStream;
import org.redisson.RedissonTimeSeries;
import org.redisson.RedissonTopic;
import org.redisson.RedissonTransferQueue;
import org.redisson.WriteBehindService;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNode;
import org.redisson.api.LocalCachedMapCacheOptions;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.LockOptions;
import org.redisson.api.MapCacheOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDoubleRx;
import org.redisson.api.RAtomicLongRx;
import org.redisson.api.RBatchRx;
import org.redisson.api.RBinaryStreamRx;
import org.redisson.api.RBitSetRx;
import org.redisson.api.RBlockingDequeRx;
import org.redisson.api.RBlockingQueueRx;
import org.redisson.api.RBloomFilterRx;
import org.redisson.api.RBucketRx;
import org.redisson.api.RBucketsRx;
import org.redisson.api.RCountDownLatchRx;
import org.redisson.api.RDequeRx;
import org.redisson.api.RFencedLockRx;
import org.redisson.api.RFunctionRx;
import org.redisson.api.RGeoRx;
import org.redisson.api.RHyperLogLogRx;
import org.redisson.api.RIdGeneratorRx;
import org.redisson.api.RJsonBucketRx;
import org.redisson.api.RJsonBucketsRx;
import org.redisson.api.RKeysRx;
import org.redisson.api.RLexSortedSetRx;
import org.redisson.api.RListMultimapCacheNativeRx;
import org.redisson.api.RListMultimapCacheRx;
import org.redisson.api.RListMultimapRx;
import org.redisson.api.RListRx;
import org.redisson.api.RLocalCachedMapCacheRx;
import org.redisson.api.RLocalCachedMapRx;
import org.redisson.api.RLock;
import org.redisson.api.RLockRx;
import org.redisson.api.RMapCacheNativeRx;
import org.redisson.api.RMapCacheRx;
import org.redisson.api.RMapRx;
import org.redisson.api.RPatternTopicRx;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RQueueRx;
import org.redisson.api.RRateLimiterRx;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RReliableTopicRx;
import org.redisson.api.RRemoteService;
import org.redisson.api.RRingBufferRx;
import org.redisson.api.RScoredSortedSetRx;
import org.redisson.api.RScriptRx;
import org.redisson.api.RSearchRx;
import org.redisson.api.RSemaphoreRx;
import org.redisson.api.RSetCacheRx;
import org.redisson.api.RSetMultimapCacheNativeRx;
import org.redisson.api.RSetMultimapCacheRx;
import org.redisson.api.RSetMultimapRx;
import org.redisson.api.RSetRx;
import org.redisson.api.RShardedTopicRx;
import org.redisson.api.RStreamRx;
import org.redisson.api.RTimeSeriesRx;
import org.redisson.api.RTopicRx;
import org.redisson.api.RTransactionRx;
import org.redisson.api.RTransferQueueRx;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.TransactionOptions;
import org.redisson.api.options.CommonOptions;
import org.redisson.api.options.CommonParams;
import org.redisson.api.options.JsonBucketOptions;
import org.redisson.api.options.JsonBucketParams;
import org.redisson.api.options.KeysOptions;
import org.redisson.api.options.KeysParams;
import org.redisson.api.options.LocalCachedMapOptions;
import org.redisson.api.options.LocalCachedMapParams;
import org.redisson.api.options.MapCacheParams;
import org.redisson.api.options.MapParams;
import org.redisson.api.options.OptionalOptions;
import org.redisson.api.options.OptionalParams;
import org.redisson.api.options.PatternTopicOptions;
import org.redisson.api.options.PatternTopicParams;
import org.redisson.api.options.PlainOptions;
import org.redisson.api.options.PlainParams;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.Config;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.rx.CommandRxExecutor;
import org.redisson.rx.RedissonBatchRx;
import org.redisson.rx.RedissonBinaryStreamRx;
import org.redisson.rx.RedissonBlockingDequeRx;
import org.redisson.rx.RedissonBlockingQueueRx;
import org.redisson.rx.RedissonKeysRx;
import org.redisson.rx.RedissonLexSortedSetRx;
import org.redisson.rx.RedissonListMultimapRx;
import org.redisson.rx.RedissonListRx;
import org.redisson.rx.RedissonMapCacheRx;
import org.redisson.rx.RedissonMapRx;
import org.redisson.rx.RedissonReadWriteLockRx;
import org.redisson.rx.RedissonScoredSortedSetRx;
import org.redisson.rx.RedissonSetCacheRx;
import org.redisson.rx.RedissonSetMultimapRx;
import org.redisson.rx.RedissonSetRx;
import org.redisson.rx.RedissonTimeSeriesRx;
import org.redisson.rx.RedissonTopicRx;
import org.redisson.rx.RedissonTransactionRx;
import org.redisson.rx.RedissonTransferQueueRx;
import org.redisson.rx.RxProxyBuilder;

public final class RedissonRx
implements RedissonRxClient {
    private final WriteBehindService writeBehindService;
    private final EvictionScheduler evictionScheduler;
    private final CommandRxExecutor commandExecutor;
    private final ConnectionManager connectionManager;

    RedissonRx(ConnectionManager connectionManager, EvictionScheduler evictionScheduler, WriteBehindService writeBehindService) {
        this.connectionManager = connectionManager;
        RedissonObjectBuilder objectBuilder = null;
        if (connectionManager.getServiceManager().getCfg().isReferenceEnabled()) {
            objectBuilder = new RedissonObjectBuilder(this);
        }
        this.commandExecutor = CommandRxExecutor.create(connectionManager, objectBuilder);
        this.evictionScheduler = evictionScheduler;
        this.writeBehindService = writeBehindService;
    }

    public CommandRxExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream(this.commandExecutor, name), RStreamRx.class);
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream(codec, this.commandExecutor, name), RStreamRx.class);
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream((Codec)params.getCodec(), this.commandExecutor.copy(params), params.getName()), RStreamRx.class);
    }

    @Override
    public RSearchRx getSearch() {
        return this.getSearch((Codec)null);
    }

    @Override
    public RSearchRx getSearch(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSearch(codec, this.commandExecutor), RSearchRx.class);
    }

    @Override
    public RSearchRx getSearch(OptionalOptions options) {
        OptionalParams params = (OptionalParams)options;
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSearch((Codec)params.getCodec(), this.commandExecutor.copy(params)), RSearchRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(String name) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo(this.commandExecutor, name, null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(String name, Codec codec) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonScoredSortedSet set = new RedissonScoredSortedSet((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo((Codec)params.getCodec(), ce, params.getName(), null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public RLockRx getFairLock(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFairLock(this.commandExecutor, name), RLockRx.class);
    }

    @Override
    public RLockRx getFairLock(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFairLock(this.commandExecutor.copy(params), params.getName()), RLockRx.class);
    }

    @Override
    public RRateLimiterRx getRateLimiter(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRateLimiter(this.commandExecutor, name), RRateLimiterRx.class);
    }

    @Override
    public RRateLimiterRx getRateLimiter(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRateLimiter(this.commandExecutor.copy(params), params.getName()), RRateLimiterRx.class);
    }

    @Override
    public RBinaryStreamRx getBinaryStream(String name) {
        RedissonBinaryStream stream = new RedissonBinaryStream(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, stream, new RedissonBinaryStreamRx(this.commandExecutor, stream), RBinaryStreamRx.class);
    }

    @Override
    public RBinaryStreamRx getBinaryStream(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonBinaryStream stream = new RedissonBinaryStream(ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, stream, new RedissonBinaryStreamRx(ce, stream), RBinaryStreamRx.class);
    }

    @Override
    public RSemaphoreRx getSemaphore(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSemaphore(this.commandExecutor, name), RSemaphoreRx.class);
    }

    @Override
    public RSemaphoreRx getSemaphore(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSemaphore(ce, params.getName()), RSemaphoreRx.class);
    }

    @Override
    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPermitExpirableSemaphore(this.commandExecutor, name), RPermitExpirableSemaphoreRx.class);
    }

    @Override
    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPermitExpirableSemaphore(ce, params.getName()), RPermitExpirableSemaphoreRx.class);
    }

    @Override
    public RReadWriteLockRx getReadWriteLock(String name) {
        return new RedissonReadWriteLockRx(this.commandExecutor, name);
    }

    @Override
    public RReadWriteLockRx getReadWriteLock(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return new RedissonReadWriteLockRx(ce, params.getName());
    }

    @Override
    public RLockRx getLock(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonLock(this.commandExecutor, name), RLockRx.class);
    }

    @Override
    public RLockRx getLock(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonLock(ce, params.getName()), RLockRx.class);
    }

    @Override
    public RLockRx getSpinLock(String name) {
        return this.getSpinLock(name, LockOptions.defaults());
    }

    @Override
    public RLockRx getSpinLock(String name, LockOptions.BackOff backOff) {
        RedissonSpinLock spinLock = new RedissonSpinLock(this.commandExecutor, name, backOff);
        return RxProxyBuilder.create(this.commandExecutor, spinLock, RLockRx.class);
    }

    @Override
    public RFencedLockRx getFencedLock(String name) {
        RedissonFencedLock lock = new RedissonFencedLock(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, lock, RFencedLockRx.class);
    }

    @Override
    public RFencedLockRx getFencedLock(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonFencedLock lock = new RedissonFencedLock(ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, lock, RFencedLockRx.class);
    }

    @Override
    public RLockRx getMultiLock(RLockRx ... locks) {
        RLock[] ls = (RLock[])Arrays.stream(locks).map(l -> new RedissonLock(this.commandExecutor, l.getName())).toArray(RLock[]::new);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(ls), RLockRx.class);
    }

    @Override
    public RLockRx getMultiLock(String group, Collection<Object> values) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFasterMultiLock(this.commandExecutor, group, values), RLockRx.class);
    }

    @Override
    public RLockRx getMultiLock(RLock ... locks) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(locks), RLockRx.class);
    }

    @Override
    public RLockRx getRedLock(RLock ... locks) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRedLock(locks), RLockRx.class);
    }

    @Override
    public RCountDownLatchRx getCountDownLatch(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonCountDownLatch(this.commandExecutor, name), RCountDownLatchRx.class);
    }

    @Override
    public RCountDownLatchRx getCountDownLatch(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonCountDownLatch(ce, params.getName()), RCountDownLatchRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec) {
        RedissonMapCache map = new RedissonMapCache(codec, this.evictionScheduler, this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name) {
        RedissonMapCache map = new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(org.redisson.api.options.MapCacheOptions<K, V> options) {
        MapCacheParams params = (MapCacheParams)options;
        MapOptions ops = ((MapCacheOptions)((MapCacheOptions)((MapCacheOptions)((MapCacheOptions)((MapCacheOptions)((MapCacheOptions)MapCacheOptions.defaults().loader(params.getLoader())).loaderAsync(params.getLoaderAsync())).writer(params.getWriter())).writerAsync(params.getWriterAsync())).writeBehindDelay(params.getWriteBehindDelay())).writeBehindBatchSize(params.getWriteBehindBatchSize())).writerRetryInterval(Duration.ofMillis(params.getWriteRetryInterval()));
        if (params.isRemoveEmptyEvictionTask()) {
            ((MapCacheOptions)ops).removeEmptyEvictionTask();
        }
        if (params.getWriteMode() != null) {
            ((MapCacheOptions)ops).writeMode(MapOptions.WriteMode.valueOf(params.getWriteMode().toString()));
        }
        if (params.getWriteRetryAttempts() > 0) {
            ((MapCacheOptions)ops).writerRetryAttempts(params.getWriteRetryAttempts());
        }
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonMapCache map = new RedissonMapCache((Codec)params.getCodec(), this.evictionScheduler, ce, params.getName(), null, ops, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, ce), RMapCacheRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket(this.commandExecutor, name), RBucketRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket(codec, this.commandExecutor, name), RBucketRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket((Codec)params.getCodec(), ce, params.getName()), RBucketRx.class);
    }

    @Override
    public RBucketsRx getBuckets() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBuckets(this.commandExecutor), RBucketsRx.class);
    }

    @Override
    public RBucketsRx getBuckets(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBuckets(codec, this.commandExecutor), RBucketsRx.class);
    }

    @Override
    public RBucketsRx getBuckets(OptionalOptions options) {
        OptionalParams params = (OptionalParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBuckets((Codec)params.getCodec(), ce), RBucketsRx.class);
    }

    @Override
    public <V> RJsonBucketRx<V> getJsonBucket(String name, JsonCodec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonJsonBucket(codec, (CommandAsyncExecutor)this.commandExecutor, name), RJsonBucketRx.class);
    }

    @Override
    public <V> RJsonBucketRx<V> getJsonBucket(JsonBucketOptions<V> options) {
        JsonBucketParams params = (JsonBucketParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonJsonBucket((JsonCodec)params.getCodec(), (CommandAsyncExecutor)ce, params.getName()), RJsonBucketRx.class);
    }

    @Override
    public RJsonBucketsRx getJsonBuckets(JsonCodec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonJsonBuckets(codec, this.commandExecutor), RJsonBucketsRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(this.commandExecutor, name), RHyperLogLogRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(codec, this.commandExecutor, name), RHyperLogLogRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog((Codec)params.getCodec(), ce, params.getName()), RHyperLogLogRx.class);
    }

    @Override
    public RIdGeneratorRx getIdGenerator(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonIdGenerator(this.commandExecutor, name), RIdGeneratorRx.class);
    }

    @Override
    public RIdGeneratorRx getIdGenerator(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonIdGenerator(ce, params.getName()), RIdGeneratorRx.class);
    }

    @Override
    public <V> RListRx<V> getList(String name) {
        RedissonList list = new RedissonList(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <V> RListRx<V> getList(String name, Codec codec) {
        RedissonList list = new RedissonList(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <V> RListRx<V> getList(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonList list = new RedissonList((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(String name) {
        RedissonListMultimap listMultimap = new RedissonListMultimap(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(String name, Codec codec) {
        RedissonListMultimap listMultimap = new RedissonListMultimap(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonListMultimap listMultimap = new RedissonListMultimap((Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheRx<K, V> getListMultimapCache(String name) {
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapCacheRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheRx<K, V> getListMultimapCache(String name, Codec codec) {
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapCacheRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheRx<K, V> getListMultimapCache(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, (Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, ce), RListMultimapCacheRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheNativeRx<K, V> getListMultimapCacheNative(String name) {
        RedissonListMultimapCacheNative listMultimap = new RedissonListMultimapCacheNative(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapCacheNativeRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheNativeRx<K, V> getListMultimapCacheNative(String name, Codec codec) {
        RedissonListMultimapCacheNative listMultimap = new RedissonListMultimapCacheNative(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapCacheNativeRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheNativeRx<K, V> getListMultimapCacheNative(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonListMultimapCacheNative listMultimap = new RedissonListMultimapCacheNative((Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, ce), RListMultimapCacheNativeRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(String name) {
        RedissonSetMultimap setMultimap = new RedissonSetMultimap(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(String name, Codec codec) {
        RedissonSetMultimap setMultimap = new RedissonSetMultimap(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonSetMultimap setMultimap = new RedissonSetMultimap((Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, ce, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheRx<K, V> getSetMultimapCache(String name) {
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapCacheRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheRx<K, V> getSetMultimapCache(String name, Codec codec) {
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapCacheRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheRx<K, V> getSetMultimapCache(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, (Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, ce, this), RSetMultimapCacheRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheNativeRx<K, V> getSetMultimapCacheNative(String name) {
        RedissonSetMultimapCacheNative setMultimap = new RedissonSetMultimapCacheNative(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapCacheNativeRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheNativeRx<K, V> getSetMultimapCacheNative(String name, Codec codec) {
        RedissonSetMultimapCacheNative setMultimap = new RedissonSetMultimapCacheNative(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapCacheNativeRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheNativeRx<K, V> getSetMultimapCacheNative(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonSetMultimapCacheNative setMultimap = new RedissonSetMultimapCacheNative((Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, ce, this), RSetMultimapCacheNativeRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name) {
        RedissonMap map = new RedissonMap(this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec) {
        RedissonMap map = new RedissonMap(codec, this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(org.redisson.api.options.MapOptions<K, V> options) {
        MapParams params = (MapParams)options;
        MapOptions<K, V> ops = RedissonRx.createOptions(params);
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonMap<K, V> map = new RedissonMap<K, V>((Codec)params.getCodec(), ce, params.getName(), null, ops, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, ce), RMapRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name) {
        RedissonSet set = new RedissonSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name, Codec codec) {
        RedissonSet set = new RedissonSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonSet set = new RedissonSet((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(String name) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(String name, Codec codec) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonScoredSortedSet set = new RedissonScoredSortedSet((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public RLexSortedSetRx getLexSortedSet(String name) {
        RedissonLexSortedSet set = new RedissonLexSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonLexSortedSetRx(set), RLexSortedSetRx.class);
    }

    @Override
    public RLexSortedSetRx getLexSortedSet(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonLexSortedSet set = new RedissonLexSortedSet(ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonLexSortedSetRx(set), RLexSortedSetRx.class);
    }

    @Override
    public RShardedTopicRx getShardedTopic(String name) {
        RedissonShardedTopic topic = new RedissonShardedTopic(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RShardedTopicRx.class);
    }

    @Override
    public RShardedTopicRx getShardedTopic(String name, Codec codec) {
        RedissonShardedTopic topic = new RedissonShardedTopic(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RShardedTopicRx.class);
    }

    @Override
    public RShardedTopicRx getShardedTopic(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonShardedTopic topic = new RedissonShardedTopic((Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RShardedTopicRx.class);
    }

    @Override
    public RTopicRx getTopic(String name) {
        RedissonTopic topic = new RedissonTopic(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RTopicRx getTopic(String name, Codec codec) {
        RedissonTopic topic = new RedissonTopic(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RTopicRx getTopic(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonTopic topic = new RedissonTopic((Codec)params.getCodec(), ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RReliableTopicRx getReliableTopic(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonReliableTopic(this.commandExecutor, name, null), RReliableTopicRx.class);
    }

    @Override
    public RReliableTopicRx getReliableTopic(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonReliableTopic(codec, this.commandExecutor, name, null), RReliableTopicRx.class);
    }

    @Override
    public RReliableTopicRx getReliableTopic(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonReliableTopic((Codec)params.getCodec(), ce, params.getName(), null), RReliableTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(String pattern) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(this.commandExecutor, pattern), RPatternTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(String pattern, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(codec, this.commandExecutor, pattern), RPatternTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(PatternTopicOptions options) {
        PatternTopicParams params = (PatternTopicParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic((Codec)params.getCodec(), ce, params.getPattern()), RPatternTopicRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue(this.commandExecutor, name, null), new RedissonListRx(new RedissonList(this.commandExecutor, name, null)), RQueueRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue(codec, this.commandExecutor, name, null), new RedissonListRx(new RedissonList(codec, this.commandExecutor, name, null)), RQueueRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue((Codec)params.getCodec(), ce, params.getName(), null), new RedissonListRx(new RedissonList((Codec)params.getCodec(), ce, params.getName(), null)), RQueueRx.class);
    }

    @Override
    public <V> RRingBufferRx<V> getRingBuffer(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer(this.commandExecutor, name, null), RRingBufferRx.class);
    }

    @Override
    public <V> RRingBufferRx<V> getRingBuffer(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer(codec, this.commandExecutor, name, null), RRingBufferRx.class);
    }

    @Override
    public <V> RRingBufferRx<V> getRingBuffer(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer((Codec)params.getCodec(), ce, params.getName(), null), RRingBufferRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(String name) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(String name, Codec codec) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonBlockingQueue queue = new RedissonBlockingQueue((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(String name) {
        RedissonDeque queue = new RedissonDeque(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(String name, Codec codec) {
        RedissonDeque queue = new RedissonDeque(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonDeque queue = new RedissonDeque((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V, L> RTimeSeriesRx<V, L> getTimeSeries(String name) {
        RedissonTimeSeries timeSeries = new RedissonTimeSeries(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesRx(timeSeries, this), RTimeSeriesRx.class);
    }

    @Override
    public <V, L> RTimeSeriesRx<V, L> getTimeSeries(String name, Codec codec) {
        RedissonTimeSeries timeSeries = new RedissonTimeSeries(codec, this.evictionScheduler, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesRx(timeSeries, this), RTimeSeriesRx.class);
    }

    @Override
    public <V, L> RTimeSeriesRx<V, L> getTimeSeries(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonTimeSeries timeSeries = new RedissonTimeSeries((Codec)params.getCodec(), this.evictionScheduler, ce, params.getName());
        return RxProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesRx(timeSeries, this), RTimeSeriesRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name) {
        RedissonSetCache set = new RedissonSetCache(this.evictionScheduler, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name, Codec codec) {
        RedissonSetCache set = new RedissonSetCache(codec, this.evictionScheduler, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonSetCache set = new RedissonSetCache((Codec)params.getCodec(), this.evictionScheduler, ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public RAtomicLongRx getAtomicLong(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicLong(this.commandExecutor, name), RAtomicLongRx.class);
    }

    @Override
    public RAtomicLongRx getAtomicLong(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicLong(ce, params.getName()), RAtomicLongRx.class);
    }

    @Override
    public RAtomicDoubleRx getAtomicDouble(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicDouble(this.commandExecutor, name), RAtomicDoubleRx.class);
    }

    @Override
    public RAtomicDoubleRx getAtomicDouble(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicDouble(ce, params.getName()), RAtomicDoubleRx.class);
    }

    @Override
    public RRemoteService getRemoteService() {
        return this.getRemoteService("redisson_rs", this.connectionManager.getServiceManager().getCfg().getCodec());
    }

    @Override
    public RRemoteService getRemoteService(String name) {
        return this.getRemoteService(name, this.connectionManager.getServiceManager().getCfg().getCodec());
    }

    @Override
    public RRemoteService getRemoteService(Codec codec) {
        return this.getRemoteService("redisson_rs", codec);
    }

    @Override
    public RRemoteService getRemoteService(String name, Codec codec) {
        String executorId = this.connectionManager.getServiceManager().getId();
        if (codec != this.connectionManager.getServiceManager().getCfg().getCodec()) {
            executorId = executorId + ":" + name;
        }
        return new RedissonRemoteService(codec, name, this.commandExecutor, executorId);
    }

    @Override
    public RRemoteService getRemoteService(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        String executorId = this.connectionManager.getServiceManager().getId();
        if (params.getCodec() != null && params.getCodec() != this.connectionManager.getServiceManager().getCfg().getCodec()) {
            executorId = executorId + ":" + params.getName();
        }
        return new RedissonRemoteService((Codec)params.getCodec(), params.getName(), this.commandExecutor, executorId);
    }

    @Override
    public RBitSetRx getBitSet(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBitSet(this.commandExecutor, name), RBitSetRx.class);
    }

    @Override
    public RBitSetRx getBitSet(CommonOptions options) {
        CommonParams params = (CommonParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBitSet(ce, params.getName()), RBitSetRx.class);
    }

    @Override
    public <V> RBloomFilterRx<V> getBloomFilter(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBloomFilter(this.commandExecutor, name), RBloomFilterRx.class);
    }

    @Override
    public <V> RBloomFilterRx<V> getBloomFilter(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBloomFilter(codec, this.commandExecutor, name), RBloomFilterRx.class);
    }

    @Override
    public <V> RBloomFilterRx<V> getBloomFilter(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBloomFilter((Codec)params.getCodec(), ce, params.getName()), RBloomFilterRx.class);
    }

    @Override
    public RFunctionRx getFunction() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFuction(this.commandExecutor), RFunctionRx.class);
    }

    @Override
    public RFunctionRx getFunction(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFuction(this.commandExecutor, codec), RFunctionRx.class);
    }

    @Override
    public RFunctionRx getFunction(OptionalOptions options) {
        OptionalParams params = (OptionalParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFuction(ce, (Codec)params.getCodec()), RFunctionRx.class);
    }

    @Override
    public RScriptRx getScript() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor), RScriptRx.class);
    }

    @Override
    public RScriptRx getScript(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor, codec), RScriptRx.class);
    }

    @Override
    public RScriptRx getScript(OptionalOptions options) {
        OptionalParams params = (OptionalParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(ce, (Codec)params.getCodec()), RScriptRx.class);
    }

    @Override
    public RBatchRx createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RBatchRx createBatch(BatchOptions options) {
        return new RedissonBatchRx(this.evictionScheduler, this.connectionManager, this.commandExecutor, options);
    }

    @Override
    public RKeysRx getKeys() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonKeys(this.commandExecutor), new RedissonKeysRx(this.commandExecutor), RKeysRx.class);
    }

    @Override
    public RKeysRx getKeys(KeysOptions options) {
        KeysParams params = (KeysParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonKeys(ce), new RedissonKeysRx(ce), RKeysRx.class);
    }

    @Override
    public Config getConfig() {
        return this.connectionManager.getServiceManager().getCfg();
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager, this.connectionManager.getServiceManager(), this.commandExecutor);
    }

    @Override
    public NodesGroup<ClusterNode> getClusterNodesGroup() {
        if (!this.getConfig().isClusterConfig()) {
            throw new IllegalStateException("Redisson not in cluster mode!");
        }
        return new RedisNodes<ClusterNode>(this.connectionManager, this.connectionManager.getServiceManager(), this.commandExecutor);
    }

    @Override
    public void shutdown() {
        this.writeBehindService.stop();
        this.connectionManager.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.getServiceManager().isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.getServiceManager().isShuttingDown();
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec, MapCacheOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, MapCacheOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheNativeRx<K, V> getMapCacheNative(String name) {
        RedissonMapCacheNative map = new RedissonMapCacheNative(this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, this.commandExecutor), RMapCacheNativeRx.class);
    }

    @Override
    public <K, V> RMapCacheNativeRx<K, V> getMapCacheNative(String name, Codec codec) {
        RedissonMapCacheNative map = new RedissonMapCacheNative(codec, this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, this.commandExecutor), RMapCacheNativeRx.class);
    }

    @Override
    public <K, V> RMapCacheNativeRx<K, V> getMapCacheNative(org.redisson.api.options.MapOptions<K, V> options) {
        MapParams params = (MapParams)options;
        MapOptions<K, V> ops = RedissonRx.createOptions(params);
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonMapCacheNative<K, V> map = new RedissonMapCacheNative<K, V>((Codec)params.getCodec(), ce, params.getName(), null, ops, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map, ce), RMapCacheNativeRx.class);
    }

    private static <K, V> MapOptions<K, V> createOptions(MapParams<K, V> params) {
        MapOptions ops = MapOptions.defaults().loader(params.getLoader()).loaderAsync(params.getLoaderAsync()).writer(params.getWriter()).writerAsync(params.getWriterAsync()).writeBehindDelay(params.getWriteBehindDelay()).writeBehindBatchSize(params.getWriteBehindBatchSize()).writerRetryInterval(Duration.ofMillis(params.getWriteRetryInterval()));
        if (params.getWriteMode() != null) {
            ops.writeMode(MapOptions.WriteMode.valueOf(params.getWriteMode().toString()));
        }
        if (params.getWriteRetryAttempts() > 0) {
            ops.writerRetryAttempts(params.getWriteRetryAttempts());
        }
        return ops;
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(codec, this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RLocalCachedMapRx<K, V> getLocalCachedMap(String name, org.redisson.api.LocalCachedMapOptions<K, V> options) {
        return this.getLocalCachedMap(name, null, options);
    }

    @Override
    public <K, V> RLocalCachedMapRx<K, V> getLocalCachedMap(String name, Codec codec, org.redisson.api.LocalCachedMapOptions<K, V> options) {
        RedissonLocalCachedMap<K, V> map = new RedissonLocalCachedMap<K, V>(codec, this.commandExecutor, name, options, this.evictionScheduler, null, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RLocalCachedMapRx.class);
    }

    @Override
    public <K, V> RLocalCachedMapRx<K, V> getLocalCachedMap(LocalCachedMapOptions<K, V> options) {
        LocalCachedMapParams params = (LocalCachedMapParams)options;
        MapOptions ops = ((org.redisson.api.LocalCachedMapOptions)((org.redisson.api.LocalCachedMapOptions)((org.redisson.api.LocalCachedMapOptions)((org.redisson.api.LocalCachedMapOptions)((org.redisson.api.LocalCachedMapOptions)((org.redisson.api.LocalCachedMapOptions)org.redisson.api.LocalCachedMapOptions.defaults().cacheProvider(LocalCachedMapOptions.CacheProvider.valueOf(params.getCacheProvider().toString())).cacheSize(params.getCacheSize()).storeMode(LocalCachedMapOptions.StoreMode.valueOf(params.getStoreMode().toString())).evictionPolicy(LocalCachedMapOptions.EvictionPolicy.valueOf(params.getEvictionPolicy().toString())).maxIdle(params.getMaxIdleInMillis()).loader(params.getLoader())).loaderAsync(params.getLoaderAsync())).reconnectionStrategy(LocalCachedMapOptions.ReconnectionStrategy.valueOf(params.getReconnectionStrategy().toString())).storeCacheMiss(params.isStoreCacheMiss()).timeToLive(params.getTimeToLiveInMillis()).syncStrategy(LocalCachedMapOptions.SyncStrategy.valueOf(params.getSyncStrategy().toString())).useObjectAsCacheKey(params.isUseObjectAsCacheKey()).useTopicPattern(params.isUseTopicPattern()).expirationEventPolicy(LocalCachedMapOptions.ExpirationEventPolicy.valueOf(params.getExpirationEventPolicy().toString())).writer(params.getWriter())).writerAsync(params.getWriterAsync())).writeBehindDelay(params.getWriteBehindDelay())).writeBehindBatchSize(params.getWriteBehindBatchSize())).writerRetryInterval(Duration.ofMillis(params.getWriteRetryInterval()));
        if (params.getWriteMode() != null) {
            ((org.redisson.api.LocalCachedMapOptions)ops).writeMode(MapOptions.WriteMode.valueOf(params.getWriteMode().toString()));
        }
        if (params.getWriteRetryAttempts() > 0) {
            ((org.redisson.api.LocalCachedMapOptions)ops).writerRetryAttempts(params.getWriteRetryAttempts());
        }
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonLocalCachedMap map = new RedissonLocalCachedMap((Codec)params.getCodec(), ce, params.getName(), ops, this.evictionScheduler, null, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, ce), RLocalCachedMapRx.class);
    }

    @Override
    public <K, V> RLocalCachedMapCacheRx<K, V> getLocalCachedMapCache(String name, LocalCachedMapCacheOptions<K, V> options) {
        throw new UnsupportedOperationException("This feature is implemented in the Redisson PRO version. Visit https://redisson.pro");
    }

    @Override
    public <K, V> RLocalCachedMapCacheRx<K, V> getLocalCachedMapCache(String name, Codec codec, LocalCachedMapCacheOptions<K, V> options) {
        throw new UnsupportedOperationException("This feature is implemented in the Redisson PRO version. Visit https://redisson.pro");
    }

    @Override
    public RTransactionRx createTransaction(TransactionOptions options) {
        return new RedissonTransactionRx(this.commandExecutor, options);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(String name) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(String name, Codec codec) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonBlockingDeque deque = new RedissonBlockingDeque((Codec)params.getCodec(), ce, params.getName(), null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }

    @Override
    public <V> RTransferQueueRx<V> getTransferQueue(String name) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        RedissonTransferQueue queue = new RedissonTransferQueue(this.commandExecutor, name, service);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueRx(queue), RTransferQueueRx.class);
    }

    @Override
    public <V> RTransferQueueRx<V> getTransferQueue(String name, Codec codec) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        RedissonTransferQueue queue = new RedissonTransferQueue(codec, this.commandExecutor, name, service);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueRx(queue), RTransferQueueRx.class);
    }

    @Override
    public <V> RTransferQueueRx<V> getTransferQueue(PlainOptions options) {
        PlainParams params = (PlainParams)options;
        String remoteName = RedissonObject.suffixName(params.getName(), "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        CommandRxExecutor ce = this.commandExecutor.copy(params);
        RedissonTransferQueue queue = new RedissonTransferQueue((Codec)params.getCodec(), ce, params.getName(), service);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueRx(queue), RTransferQueueRx.class);
    }

    @Override
    public String getId() {
        return this.commandExecutor.getServiceManager().getId();
    }
}

