/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipOutputStream;
import jodd.io.FileUtil;
import jodd.io.IOUtil;
import jodd.io.ZipUtil;

public class ZipBuilder {
    private final ZipOutputStream zos;
    private final File targetZipFile;
    private final ByteArrayOutputStream targetBaos;

    public static ZipBuilder createZipFile(File zipFile) throws IOException {
        return new ZipBuilder(zipFile);
    }

    public static ZipBuilder createZipFile(String zipFile) throws IOException {
        return new ZipBuilder(new File(zipFile));
    }

    public static ZipBuilder createZipInMemory() {
        return new ZipBuilder();
    }

    protected ZipBuilder(File zipFile) throws IOException {
        if (!FileUtil.isExistingFile(zipFile)) {
            FileUtil.touch(zipFile);
        }
        this.zos = new ZipOutputStream(new FileOutputStream(zipFile));
        this.targetZipFile = zipFile;
        this.targetBaos = null;
    }

    protected ZipBuilder() {
        this.targetZipFile = null;
        this.targetBaos = new ByteArrayOutputStream();
        this.zos = new ZipOutputStream(this.targetBaos);
    }

    public File toZipFile() {
        IOUtil.close(this.zos);
        return this.targetZipFile;
    }

    public byte[] toBytes() {
        IOUtil.close(this.zos);
        if (this.targetZipFile != null) {
            try {
                return FileUtil.readBytes(this.targetZipFile);
            }
            catch (IOException ignore) {
                return null;
            }
        }
        return this.targetBaos.toByteArray();
    }

    public AddFileToZip add(File source) {
        return new AddFileToZip(source);
    }

    public AddContentToZip add(String content) {
        return new AddContentToZip(content.getBytes(StandardCharsets.UTF_8));
    }

    public AddContentToZip add(byte[] content) {
        return new AddContentToZip(content);
    }

    public ZipBuilder addFolder(String folderName) throws IOException {
        ZipUtil.addFolderToZip(this.zos, folderName, null);
        return this;
    }

    public class AddContentToZip {
        private final byte[] bytes;
        private String path;
        private String comment;

        private AddContentToZip(byte[] content) {
            this.bytes = content;
        }

        public AddContentToZip path(String path) {
            this.path = path;
            return this;
        }

        public AddContentToZip comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ZipBuilder save() throws IOException {
            ZipUtil.addToZip(ZipBuilder.this.zos, this.bytes, this.path, this.comment);
            return ZipBuilder.this;
        }
    }

    public class AddFileToZip {
        private final File file;
        private String path;
        private String comment;
        private boolean recursive = true;

        private AddFileToZip(File file) {
            this.file = file;
        }

        public AddFileToZip path(String path) {
            this.path = path;
            return this;
        }

        public AddFileToZip comment(String comment) {
            this.comment = comment;
            return this;
        }

        public AddFileToZip recursive() {
            this.recursive = true;
            return this;
        }

        public ZipBuilder save() throws IOException {
            ZipUtil.addToZip(ZipBuilder.this.zos, this.file, this.path, this.comment, this.recursive);
            return ZipBuilder.this;
        }
    }
}

