/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import javax.cache.processor.MutableEntry;
import org.redisson.jcache.JCache;

public class JMutableEntry<K, V>
implements MutableEntry<K, V> {
    private final JCache<K, V> jCache;
    private final K key;
    private boolean isReadThrough;
    private Action action = Action.SKIPPED;
    private V value;
    private boolean isValueRead;

    public JMutableEntry(JCache<K, V> jCache, K key, V value, boolean isReadThrough) {
        this.jCache = jCache;
        this.key = key;
        this.value = value;
        this.isReadThrough = isReadThrough;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    @Override
    public V getValue() {
        if (this.action != Action.SKIPPED) {
            return this.value;
        }
        if (!this.isValueRead) {
            this.value = this.jCache.getValueLocked(this.key);
            this.isValueRead = true;
        }
        if (this.value != null) {
            this.action = Action.READ;
        } else if (this.isReadThrough) {
            this.value = this.jCache.loadValue(this.key);
            if (this.value != null) {
                this.action = Action.LOADED;
            }
            this.isReadThrough = false;
        }
        return this.value;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return (T)this;
    }

    @Override
    public boolean exists() {
        return this.getValue() != null;
    }

    @Override
    public void remove() {
        this.action = this.action == Action.CREATED ? Action.SKIPPED : Action.DELETED;
        this.value = null;
    }

    @Override
    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.action != Action.CREATED) {
            this.action = this.jCache.containsKey(this.key) ? Action.UPDATED : Action.CREATED;
        }
        this.value = value;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        CREATED,
        READ,
        UPDATED,
        DELETED,
        LOADED,
        SKIPPED;

    }
}

