/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.redisson.RedissonPatternTopic;
import org.redisson.api.DeletedObjectListener;
import org.redisson.api.ExpiredObjectListener;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.listener.TrackingListener;
import org.redisson.client.ChannelName;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.BatchService;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.ServiceManager;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.Hash;
import org.redisson.pubsub.PublishSubscribeService;

public abstract class RedissonObject
implements RObject {
    protected CommandAsyncExecutor commandExecutor;
    protected String name;
    protected final Codec codec;
    private final Map<String, Collection<Integer>> listeners = new ConcurrentHashMap<String, Collection<Integer>>();

    public RedissonObject(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.codec = commandExecutor.getServiceManager().getCodec(codec);
        this.commandExecutor = commandExecutor;
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        this.setName(name);
    }

    public RedissonObject(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor, name);
    }

    public static String prefixName(String prefix, String name) {
        if (name.contains("{")) {
            return prefix + ":" + name;
        }
        return prefix + ":{" + name + "}";
    }

    public ServiceManager getServiceManager() {
        return this.commandExecutor.getServiceManager();
    }

    public static String suffixName(String name, String suffix) {
        if (name.contains("{")) {
            return name + ":" + suffix;
        }
        return "{" + name + "}:" + suffix;
    }

    protected final <T> Stream<T> toStream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false);
    }

    protected final <V> V get(RFuture<V> future) {
        return this.commandExecutor.get(future);
    }

    protected final long toSeconds(long timeout, TimeUnit unit) {
        long seconds = unit.toSeconds(timeout);
        if (timeout != 0L && seconds == 0L) {
            seconds = 1L;
        }
        return seconds;
    }

    @Override
    public String getName() {
        return this.commandExecutor.getServiceManager().getConfig().getNameMapper().unmap(this.name);
    }

    public final String getRawName() {
        return this.name;
    }

    protected String getRawName(Object o) {
        return this.getRawName();
    }

    protected void setName(String name) {
        this.name = this.mapName(name);
    }

    @Override
    public void rename(String newName) {
        this.get(this.renameAsync(newName));
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MEMORY_USAGE, this.getRawName());
    }

    public final RFuture<Long> sizeInMemoryAsync(List<Object> keys) {
        return this.sizeInMemoryAsync(this.commandExecutor, keys);
    }

    public final RFuture<Long> sizeInMemoryAsync(CommandAsyncExecutor commandExecutor, List<Object> keys) {
        return commandExecutor.evalWriteAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG, "local total = 0;for j = 1, #KEYS, 1 do local size = redis.call('memory', 'usage', KEYS[j]); if size ~= false then total = total + size;end; end; return total; ", keys, new Object[0]);
    }

    @Override
    public long sizeInMemory() {
        return this.get(this.sizeInMemoryAsync());
    }

    @Override
    public final RFuture<Boolean> copyAsync(String destination) {
        return this.copyAsync(destination, -1);
    }

    @Override
    public final RFuture<Boolean> copyAsync(String destination, int database) {
        return this.copyAsync(Arrays.asList(this.getRawName(), this.mapName(destination)), database, false);
    }

    @Override
    public final RFuture<Boolean> copyAndReplaceAsync(String destination) {
        return this.copyAndReplaceAsync(destination, -1);
    }

    @Override
    public final RFuture<Boolean> copyAndReplaceAsync(String destination, int database) {
        return this.copyAsync(Arrays.asList(this.getRawName(), this.mapName(destination)), database, true);
    }

    protected RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        return this.copyAsync(this.commandExecutor, keys, database, replace);
    }

    protected final RFuture<Void> renameAsync(List<Object> keys) {
        return this.renameAsync(this.commandExecutor, keys, () -> {});
    }

    protected final RFuture<Void> renamenxAsync(List<Object> keys) {
        return this.renameAsync(this.commandExecutor, keys, () -> {});
    }

    protected final RFuture<Boolean> copyAsync(CommandAsyncExecutor commandExecutor, List<Object> keys, int database, boolean replace) {
        if (keys.size() == 2) {
            LinkedList<Object> args = new LinkedList<Object>();
            args.add(keys.get(0));
            args.add(keys.get(1));
            if (database >= 0) {
                args.add("DB");
                args.add(database);
            }
            if (replace) {
                args.add("REPLACE");
            }
            return commandExecutor.writeAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.COPY, args.toArray());
        }
        return commandExecutor.evalWriteAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local res = 0;local newKeysIndex = #KEYS/2; for j = 1, newKeysIndex, 1 do if tonumber(ARGV[1]) >= 0 then if ARGV[2] == '1' then res = res + redis.call('copy', KEYS[j], KEYS[newKeysIndex + j], 'db', ARGV[1], 'replace'); else res = res + redis.call('copy', KEYS[j], KEYS[newKeysIndex + j], 'db', ARGV[1]); end; else if ARGV[2] == '1' then res = res + redis.call('copy', KEYS[j], KEYS[newKeysIndex + j], 'replace'); else res = res + redis.call('copy', KEYS[j], KEYS[newKeysIndex + j]); end; end; end; return math.min(res, 1); ", keys, database, Boolean.compare(replace, false));
    }

    protected final RFuture<Void> renameAsync(CommandAsyncExecutor commandExecutor, List<Object> keys, Runnable runnable) {
        if (keys.size() == 2) {
            LinkedList<Object> args = new LinkedList<Object>();
            args.add(keys.get(0));
            args.add(keys.get(1));
            CompletionStage<Object> f = commandExecutor.writeAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.RENAME, args.toArray());
            f = f.thenAccept(r -> this.setName((String)keys.get(1)));
            return new CompletableFutureWrapper<Void>(f);
        }
        CompletionStage<Object> f = commandExecutor.evalWriteAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "local newKeysIndex = #KEYS/2; for j = 1, newKeysIndex, 1 do if redis.call('exists', KEYS[j]) == 1 then redis.call('rename', KEYS[j], KEYS[newKeysIndex + j]); end; end; ", keys, new Object[0]);
        f = f.thenAccept(r -> runnable.run());
        return new CompletableFutureWrapper<Void>(f);
    }

    protected final RFuture<Boolean> renamenxAsync(CommandAsyncExecutor commandExecutor, List<Object> keys, Consumer<Boolean> callback) {
        if (keys.size() == 2) {
            LinkedList<Object> args = new LinkedList<Object>();
            args.add(keys.get(0));
            args.add(keys.get(1));
            CompletionStage<Object> f = commandExecutor.writeAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.RENAMENX, args.toArray());
            f = f.thenApply(value -> {
                if (value.booleanValue()) {
                    this.setName((String)keys.get(1));
                }
                return value;
            });
            return new CompletableFutureWrapper<Boolean>(f);
        }
        CompletionStage<Object> f = commandExecutor.evalWriteAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local newKeysIndex = #KEYS/2; for j = newKeysIndex+1, #KEYS, 1 do if redis.call('exists', KEYS[j]) == 1 then return 0; end; end; for j = 1, newKeysIndex, 1 do redis.call('renamenx', KEYS[j], KEYS[newKeysIndex + j]); end; return 1;", keys, new Object[0]);
        f = f.thenApply(r -> {
            callback.accept((Boolean)r);
            return r;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public final boolean copy(String destination) {
        return this.get(this.copyAsync(destination));
    }

    @Override
    public final boolean copy(String destination, int database) {
        return this.get(this.copyAsync(destination, database));
    }

    @Override
    public final boolean copyAndReplace(String destination) {
        return this.get(this.copyAndReplaceAsync(destination));
    }

    @Override
    public final boolean copyAndReplace(String destination, int database) {
        return this.get(this.copyAndReplaceAsync(destination, database));
    }

    protected final String mapName(String name) {
        return this.commandExecutor.getServiceManager().getConfig().getNameMapper().map(name);
    }

    protected final void checkNotBatch() {
        if (this.commandExecutor instanceof BatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        if (this.getServiceManager().getCfg().isClusterConfig()) {
            this.checkNotBatch();
            String nn = this.mapName(newName);
            String oldName = this.getRawName();
            CompletionStage f = this.dumpAsync().thenCompose(val -> this.commandExecutor.writeAsync(nn, (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, nn, 0, val, "REPLACE")).thenCompose(val -> {
                this.setName(newName);
                return this.deleteAsync(oldName).thenApply(r -> null);
            });
            return new CompletableFutureWrapper<Void>(f);
        }
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RENAME, this.getRawName(), this.mapName(newName));
        CompletionStage<Void> f = future.thenAccept(r -> this.setName(newName));
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void migrate(String host, int port, int database, long timeout) {
        this.get(this.migrateAsync(host, port, database, timeout));
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MIGRATE, host, port, this.getRawName(), database, timeout);
    }

    @Override
    public void copy(String host, int port, int database, long timeout) {
        this.get(this.copyAsync(host, port, database, timeout));
    }

    @Override
    public RFuture<Void> copyAsync(String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MIGRATE, host, port, this.getRawName(), database, timeout, "COPY");
    }

    @Override
    public boolean move(int database) {
        return this.get(this.moveAsync(database));
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MOVE, this.getRawName(), database);
    }

    @Override
    public boolean renamenx(String newName) {
        return this.get(this.renamenxAsync(newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RENAMENX, this.getRawName(), newName);
        CompletionStage<Boolean> f = future.thenApply(value -> {
            if (value.booleanValue()) {
                this.setName(newName);
            }
            return value;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public boolean delete() {
        return this.get(this.deleteAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.DEL_BOOL, this.getRawName());
    }

    protected final RFuture<Boolean> deleteAsync(String ... keys) {
        return this.commandExecutor.writeAsync(keys[0], (Codec)StringCodec.INSTANCE, RedisCommands.DEL_OBJECTS, (Object[])keys);
    }

    @Override
    public boolean unlink() {
        return this.get(this.unlinkAsync());
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.UNLINK_BOOL, this.getRawName());
    }

    @Override
    public boolean touch() {
        return this.get(this.touchAsync());
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.TOUCH, this.getRawName());
    }

    @Override
    public boolean isExists() {
        return this.get(this.isExistsAsync());
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EXISTS, this.getRawName());
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected List<ByteBuf> encode(Collection<?> values) {
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>(values.size());
        for (Object object : values) {
            this.encode(result, object);
        }
        return result;
    }

    public void encode(Collection<Object> params, Collection<?> values) {
        try {
            for (Object object : values) {
                params.add(this.encode(object));
            }
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getLockByMapKey(Object key, String suffix) {
        ByteBuf keyState = this.encodeMapKey(key);
        try {
            String string = RedissonObject.suffixName(this.getRawName(key), Hash.hash128toBase64(keyState) + ":" + suffix);
            return string;
        }
        finally {
            keyState.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getLockByValue(Object key, String suffix) {
        ByteBuf keyState = this.encode(key);
        try {
            String string = RedissonObject.suffixName(this.getRawName(key), Hash.hash128toBase64(keyState) + ":" + suffix);
            return string;
        }
        finally {
            keyState.release();
        }
    }

    protected final void encodeMapKeys(Collection<Object> params, Collection<?> values) {
        try {
            for (Object object : values) {
                params.add(this.encodeMapKey(object));
            }
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    protected final void encodeMapValues(Collection<Object> params, Collection<?> values) {
        try {
            for (Object object : values) {
                params.add(this.encodeMapValue(object));
            }
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    public ByteBuf encode(Object value) {
        return this.commandExecutor.encode(this.codec, value);
    }

    public void encode(Collection<?> params, Object value) {
        try {
            ByteBuf v2 = this.encode(value);
            params.add(v2);
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    public final ByteBuf encodeMapKey(Object value) {
        return this.commandExecutor.encodeMapKey(this.codec, value);
    }

    public final ByteBuf encodeMapKey(Object value, Collection<Object> params) {
        try {
            return this.encodeMapKey(value);
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    public final ByteBuf encodeMapValue(Object value) {
        return this.commandExecutor.encodeMapValue(this.codec, value);
    }

    @Override
    public byte[] dump() {
        return this.get(this.dumpAsync());
    }

    @Override
    public RFuture<byte[]> dumpAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.DUMP, this.getRawName());
    }

    @Override
    public void restore(byte[] state) {
        this.get(this.restoreAsync(state));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] state) {
        return this.restoreAsync(state, 0L, null);
    }

    @Override
    public void restore(byte[] state, long timeToLive, TimeUnit timeUnit) {
        this.get(this.restoreAsync(state, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        long ttl = 0L;
        if (timeToLive > 0L) {
            ttl = timeUnit.toMillis(timeToLive);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, this.getRawName(), ttl, state);
    }

    @Override
    public void restoreAndReplace(byte[] state, long timeToLive, TimeUnit timeUnit) {
        this.get(this.restoreAndReplaceAsync(state, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        long ttl = 0L;
        if (timeToLive > 0L) {
            ttl = timeUnit.toMillis(timeToLive);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, this.getRawName(), ttl, state, "REPLACE");
    }

    @Override
    public void restoreAndReplace(byte[] state) {
        this.get(this.restoreAndReplaceAsync(state));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] state) {
        return this.restoreAndReplaceAsync(state, 0L, null);
    }

    @Override
    public Long getIdleTime() {
        return this.get(this.getIdleTimeAsync());
    }

    @Override
    public RFuture<Long> getIdleTimeAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.OBJECT_IDLETIME, this.getRawName());
    }

    protected final void removeListener(int listenerId, String ... names) {
        for (String name : names) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
            topic.removeListener(listenerId);
            this.removeListenerId(name, listenerId);
        }
    }

    protected final Collection<Integer> getListenerIdsByName(String name) {
        return this.listeners.getOrDefault(name, Collections.emptyList());
    }

    protected final String getNameByListenerId(int listenerId) {
        for (Map.Entry<String, Collection<Integer>> entry : this.listeners.entrySet()) {
            if (!entry.getValue().contains(listenerId)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected final void removeListenerId(String name, int listenerId) {
        this.listeners.computeIfPresent(name, (k, ids) -> {
            ids.remove(listenerId);
            if (ids.isEmpty()) {
                return null;
            }
            return ids;
        });
    }

    protected final RFuture<Void> removeListenerAsync(RFuture<Void> future, int listenerId, String ... names) {
        ArrayList futures = new ArrayList(names.length + 1);
        if (future != null) {
            futures.add(future.toCompletableFuture());
        }
        for (String name : names) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
            RFuture<Void> f1 = topic.removeListenerAsync(listenerId);
            futures.add(f1.toCompletableFuture());
            this.removeListenerId(name, listenerId);
        }
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return new CompletableFutureWrapper<Void>(f);
    }

    protected final int addTrackingListener(TrackingListener listener) {
        return (Integer)this.addTrackingListenerAsync(listener).toCompletableFuture().join();
    }

    protected final RFuture<Integer> addTrackingListenerAsync(TrackingListener listener) {
        if (!this.getServiceManager().isResp3()) {
            throw new IllegalStateException("`protocol` config setting should be set to RESP3 value");
        }
        this.commandExecutor = this.commandExecutor.copy(true);
        PublishSubscribeService subscribeService = this.commandExecutor.getConnectionManager().getSubscribeService();
        CompletableFuture<Integer> r = subscribeService.subscribe(this.getRawName(), StringCodec.INSTANCE, this.commandExecutor, listener);
        return new CompletableFutureWrapper<Integer>(r);
    }

    protected <T extends ObjectListener> int addListener(String name, T listener, BiConsumer<T, String> consumer) {
        return this.addListener(name, listener, consumer, m -> m.equals(this.getRawName()));
    }

    protected final <T extends ObjectListener> int addListener(String name, T listener, BiConsumer<T, String> consumer, Function<String, Boolean> condition) {
        RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
        int id = topic.addListener(String.class, (pattern, channel, msg) -> {
            if (((Boolean)condition.apply((String)msg)).booleanValue()) {
                consumer.accept(listener, (String)msg);
            }
        });
        this.addListenerId(name, id);
        return id;
    }

    protected <T extends ObjectListener> RFuture<Integer> addListenerAsync(String name, T listener, BiConsumer<T, String> consumer) {
        return this.addListenerAsync(name, listener, consumer, m -> m.equals(this.getRawName()));
    }

    protected final <T extends ObjectListener> RFuture<Integer> addListenerAsync(String name, T listener, BiConsumer<T, String> consumer, Function<String, Boolean> condition) {
        RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
        RFuture<Integer> f = topic.addListenerAsync(String.class, (pattern, channel, msg) -> {
            if (((Boolean)condition.apply((String)msg)).booleanValue()) {
                consumer.accept(listener, (String)msg);
            }
        });
        CompletionStage<Integer> r = f.thenApply(id -> {
            this.addListenerId(name, (Integer)id);
            return id;
        });
        return new CompletableFutureWrapper<Integer>(r);
    }

    protected final void addListenerId(String name, Integer id) {
        Collection ids = this.listeners.computeIfAbsent(name, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
        ids.add(id);
    }

    protected final void removeListeners() {
        for (Map.Entry<String, Collection<Integer>> entry : this.listeners.entrySet()) {
            for (Integer id : entry.getValue()) {
                this.removeListener(id, entry.getKey());
            }
        }
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof ExpiredObjectListener) {
            return this.addListener("__keyevent@*:expired", (ExpiredObjectListener)listener, ExpiredObjectListener::onExpired);
        }
        if (listener instanceof DeletedObjectListener) {
            return this.addListener("__keyevent@*:del", (DeletedObjectListener)listener, DeletedObjectListener::onDeleted);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof ExpiredObjectListener) {
            return this.addListenerAsync("__keyevent@*:expired", (ExpiredObjectListener)listener, ExpiredObjectListener::onExpired);
        }
        if (listener instanceof DeletedObjectListener) {
            return this.addListenerAsync("__keyevent@*:del", (DeletedObjectListener)listener, DeletedObjectListener::onDeleted);
        }
        throw new IllegalArgumentException("This type of listener can't be added to this object");
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:expired", "__keyevent@*:del");
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(null, listenerId, "__keyevent@*:expired", "__keyevent@*:del");
    }

    protected final RFuture<Void> removeListenerAsync(int listenerId, String ... names) {
        ArrayList<String> ns = new ArrayList<String>(Arrays.asList(names));
        ns.addAll(Arrays.asList("__keyevent@*:expired", "__keyevent@*:del"));
        return this.removeListenerAsync(null, listenerId, ns.toArray(new String[0]));
    }

    protected final void removeTrackingListener(int listenerId) {
        this.removeTrackingListenerAsync(listenerId).toCompletableFuture().join();
    }

    protected final RFuture<Void> removeTrackingListenerAsync(int listenerId) {
        PublishSubscribeService subscribeService = this.commandExecutor.getConnectionManager().getSubscribeService();
        if (!subscribeService.hasEntry(ChannelName.TRACKING)) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        CompletionStage<Void> f = subscribeService.removeListenerAsync(PubSubType.UNSUBSCRIBE, ChannelName.TRACKING, listenerId);
        f = f.whenComplete((r, e) -> {
            if (!this.commandExecutor.isTrackChanges()) {
                this.commandExecutor = this.commandExecutor.copy(false);
            }
        });
        return new CompletableFutureWrapper<Void>((CompletableFuture<Void>)f);
    }

    protected final List<String> map(String[] keys) {
        return Arrays.stream(keys).map(k -> this.mapName((String)k)).collect(Collectors.toList());
    }

    protected final PublishSubscribeService getSubscribeService() {
        return this.commandExecutor.getConnectionManager().getSubscribeService();
    }
}

