/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.redisson.cluster.ClusterSlotRange;

public class ClusterPartition {
    private Type type = Type.MASTER;
    private final String nodeId;
    private boolean masterFail;
    private URI masterAddress;
    private final Set<URI> slaveAddresses = new HashSet<URI>();
    private final Set<URI> failedSlaves = new HashSet<URI>();
    private final Set<Integer> slots = new HashSet<Integer>();
    private final Set<ClusterSlotRange> slotRanges = new HashSet<ClusterSlotRange>();
    private ClusterPartition parent;

    public ClusterPartition(String nodeId) {
        this.nodeId = nodeId;
    }

    public ClusterPartition getParent() {
        return this.parent;
    }

    public void setParent(ClusterPartition parent) {
        this.parent = parent;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setMasterFail(boolean masterFail) {
        this.masterFail = masterFail;
    }

    public boolean isMasterFail() {
        return this.masterFail;
    }

    public void addSlots(Set<Integer> slots) {
        this.slots.addAll(slots);
    }

    public void removeSlots(Set<Integer> slots) {
        this.slots.removeAll(slots);
    }

    public void addSlotRanges(Set<ClusterSlotRange> ranges) {
        for (ClusterSlotRange clusterSlotRange : ranges) {
            for (int i = clusterSlotRange.getStartSlot(); i < clusterSlotRange.getEndSlot() + 1; ++i) {
                this.slots.add(i);
            }
        }
        this.slotRanges.addAll(ranges);
    }

    public void removeSlotRanges(Set<ClusterSlotRange> ranges) {
        for (ClusterSlotRange clusterSlotRange : ranges) {
            for (int i = clusterSlotRange.getStartSlot(); i < clusterSlotRange.getEndSlot() + 1; ++i) {
                this.slots.remove(i);
            }
        }
        this.slotRanges.removeAll(ranges);
    }

    public Set<ClusterSlotRange> getSlotRanges() {
        return this.slotRanges;
    }

    public Set<Integer> getSlots() {
        return this.slots;
    }

    public InetSocketAddress getMasterAddr() {
        return new InetSocketAddress(this.masterAddress.getHost(), this.masterAddress.getPort());
    }

    public URI getMasterAddress() {
        return this.masterAddress;
    }

    public void setMasterAddress(URI masterAddress) {
        this.masterAddress = masterAddress;
    }

    public void addFailedSlaveAddress(URI address) {
        this.failedSlaves.add(address);
    }

    public Set<URI> getFailedSlaveAddresses() {
        return Collections.unmodifiableSet(this.failedSlaves);
    }

    public void removeFailedSlaveAddress(URI uri) {
        this.failedSlaves.remove(uri);
    }

    public void addSlaveAddress(URI address) {
        this.slaveAddresses.add(address);
    }

    public Set<URI> getSlaveAddresses() {
        return Collections.unmodifiableSet(this.slaveAddresses);
    }

    public void removeSlaveAddress(URI uri) {
        this.slaveAddresses.remove(uri);
        this.failedSlaves.remove(uri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterPartition other = (ClusterPartition)obj;
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
    }

    public String toString() {
        return "ClusterPartition [nodeId=" + this.nodeId + ", masterFail=" + this.masterFail + ", masterAddress=" + this.masterAddress + ", slaveAddresses=" + this.slaveAddresses + ", failedSlaves=" + this.failedSlaves + ", slotRanges=" + this.slotRanges + "]";
    }

    public static enum Type {
        MASTER,
        SLAVE;

    }
}

