/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMap;
import org.redisson.RedissonTopic;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.cache.Cache;
import org.redisson.cache.LFUCacheMap;
import org.redisson.cache.LRUCacheMap;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.NoneCacheMap;
import org.redisson.cache.ReferenceCacheMap;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.ObjectMapEntryReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.misc.Hash;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLocalCachedMap<K, V>
extends RedissonMap<K, V>
implements RLocalCachedMap<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RedissonLocalCachedMap.class);
    private static final RedisCommand<Set<Object>> ALL_KEYS = new RedisCommand("EVAL", new ObjectSetReplayDecoder(), RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Set<Map.Entry<Object, Object>>> ALL_ENTRIES = new RedisCommand<Set<Map.Entry<Object, Object>>>("EVAL", new ObjectMapEntryReplayDecoder(), RedisCommand.ValueType.MAP);
    private static final RedisCommand<Map<Object, Object>> ALL_MAP = new RedisCommand<Map<Object, Object>>("EVAL", new ObjectMapReplayDecoder(), RedisCommand.ValueType.MAP);
    private long cacheUpdateLogTime = TimeUnit.MINUTES.toMillis(10L);
    private byte[] instanceId;
    private RTopic<Object> invalidationTopic;
    private Cache<CacheKey, CacheValue> cache;
    private int invalidateEntryOnChange;
    private int invalidationListenerId;
    private int invalidationStatusListenerId;
    private volatile long lastInvalidate;

    protected RedissonLocalCachedMap(CommandAsyncExecutor commandExecutor, String name, LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler, RedissonClient redisson) {
        super(commandExecutor, name, redisson, options);
        this.init(name, options, redisson, evictionScheduler);
    }

    protected RedissonLocalCachedMap(Codec codec, CommandAsyncExecutor connectionManager, String name, LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler, RedissonClient redisson) {
        super(codec, connectionManager, name, redisson, options);
        this.init(name, options, redisson, evictionScheduler);
    }

    private void init(String name, LocalCachedMapOptions<K, V> options, RedissonClient redisson, EvictionScheduler evictionScheduler) {
        this.instanceId = RedissonLocalCachedMap.generateId();
        if (options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE || options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE_WITH_CLEAR_ON_RECONNECT) {
            this.invalidateEntryOnChange = 1;
        }
        if (options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE_WITH_LOAD_ON_RECONNECT) {
            this.invalidateEntryOnChange = 2;
            evictionScheduler.schedule(this.getUpdatesLogName(), this.cacheUpdateLogTime + TimeUnit.MINUTES.toMillis(1L));
        }
        this.cache = this.createCache(options);
        this.addListeners(name, options, redisson);
    }

    private void addListeners(String name, final LocalCachedMapOptions<K, V> options, final RedissonClient redisson) {
        this.invalidationTopic = new RedissonTopic<Object>(this.commandExecutor, this.suffixName(name, "topic"));
        if (options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.NONE) {
            return;
        }
        if (options.getInvalidationPolicy() != LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE) {
            this.invalidationStatusListenerId = this.invalidationTopic.addListener(new BaseStatusListener(){

                @Override
                public void onSubscribe(String channel) {
                    if (options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE_WITH_CLEAR_ON_RECONNECT) {
                        RedissonLocalCachedMap.this.cache.clear();
                    }
                    if (options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE_WITH_LOAD_ON_RECONNECT && RedissonLocalCachedMap.this.lastInvalidate > 0L) {
                        if (System.currentTimeMillis() - RedissonLocalCachedMap.this.lastInvalidate > RedissonLocalCachedMap.this.cacheUpdateLogTime) {
                            RedissonLocalCachedMap.this.cache.clear();
                            return;
                        }
                        RedissonLocalCachedMap.this.isExistsAsync().addListener(new FutureListener<Boolean>(){

                            @Override
                            public void operationComplete(Future<Boolean> future) throws Exception {
                                if (!future.isSuccess()) {
                                    return;
                                }
                                if (!future.getNow().booleanValue()) {
                                    RedissonLocalCachedMap.this.cache.clear();
                                    return;
                                }
                                RScoredSortedSet logs = redisson.getScoredSortedSet(RedissonLocalCachedMap.this.getUpdatesLogName(), ByteArrayCodec.INSTANCE);
                                logs.valueRangeAsync(RedissonLocalCachedMap.this.lastInvalidate, true, Double.POSITIVE_INFINITY, true).addListener(new FutureListener<Collection<byte[]>>(){

                                    @Override
                                    public void operationComplete(Future<Collection<byte[]>> future) throws Exception {
                                        if (!future.isSuccess()) {
                                            log.error("Can't load update log", future.cause());
                                            return;
                                        }
                                        for (byte[] entry : future.getNow()) {
                                            byte[] keyHash = Arrays.copyOf(entry, 16);
                                            CacheKey key = new CacheKey(keyHash);
                                            RedissonLocalCachedMap.this.cache.remove(key);
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        this.invalidationListenerId = this.invalidationTopic.addListener(new MessageListener<Object>(){

            @Override
            public void onMessage(String channel, Object msg) {
                if (msg instanceof LocalCachedMapClear) {
                    RedissonLocalCachedMap.this.cache.clear();
                }
                if (msg instanceof LocalCachedMapInvalidate) {
                    LocalCachedMapInvalidate invalidateMsg = (LocalCachedMapInvalidate)msg;
                    if (!Arrays.equals(invalidateMsg.getExcludedId(), RedissonLocalCachedMap.this.instanceId)) {
                        for (byte[] keyHash : invalidateMsg.getKeyHashes()) {
                            CacheKey key = new CacheKey(keyHash);
                            RedissonLocalCachedMap.this.cache.remove(key);
                        }
                    }
                    if (options.getInvalidationPolicy() == LocalCachedMapOptions.InvalidationPolicy.ON_CHANGE_WITH_LOAD_ON_RECONNECT) {
                        RedissonLocalCachedMap.this.lastInvalidate = System.currentTimeMillis();
                    }
                }
            }
        });
    }

    protected Cache<CacheKey, CacheValue> createCache(LocalCachedMapOptions<K, V> options) {
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.NONE) {
            return new NoneCacheMap<CacheKey, CacheValue>(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LRU) {
            return new LRUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LFU) {
            return new LFUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.SOFT) {
            return ReferenceCacheMap.soft(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.WEAK) {
            return ReferenceCacheMap.weak(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        throw new IllegalArgumentException("Invalid eviction policy: " + (Object)((Object)options.getEvictionPolicy()));
    }

    private CacheKey toCacheKey(Object key) {
        byte[] encoded = this.encodeMapKey(key);
        return this.toCacheKey(encoded);
    }

    private CacheKey toCacheKey(byte[] encodedKey) {
        return new CacheKey(Hash.hash(encodedKey));
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        this.checkKey(key);
        CacheKey cacheKey = this.toCacheKey(key);
        if (!this.cache.containsKey(cacheKey)) {
            return super.containsKeyAsync(key);
        }
        return this.newSucceededFuture(true);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkValue(value);
        CacheValue cacheValue = new CacheValue(null, value);
        if (!this.cache.containsValue(cacheValue)) {
            return super.containsValueAsync(value);
        }
        return this.newSucceededFuture(true);
    }

    @Override
    public RFuture<V> getAsync(final Object key) {
        this.checkKey(key);
        final CacheKey cacheKey = this.toCacheKey(key);
        CacheValue cacheValue = (CacheValue)this.cache.get(cacheKey);
        if (cacheValue != null && cacheValue.getValue() != null) {
            return this.newSucceededFuture(cacheValue.getValue());
        }
        RFuture future = super.getAsync(key);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Object value = future.getNow();
                if (value != null) {
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    String getUpdatesLogName() {
        return this.prefixName("redisson__cache_updates_log", this.getName());
    }

    protected static byte[] generateId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return id;
    }

    protected static byte[] generateLogEntryId(byte[] keyHash) {
        byte[] result = new byte[keyHash.length + 1 + 8];
        result[16] = 58;
        byte[] id = new byte[8];
        ThreadLocalRandom.current().nextBytes(id);
        System.arraycopy(keyHash, 0, result, 0, keyHash.length);
        System.arraycopy(id, 0, result, 17, id.length);
        return result;
    }

    @Override
    protected RFuture<V> putOperationAsync(K key, V value) {
        byte[] mapKey = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(mapKey);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        CacheValue cacheValue = new CacheValue(key, value);
        this.cache.put(cacheKey, cacheValue);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); if redis.call('hset', KEYS[1], ARGV[1], ARGV[2]) == 0 then if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[3]); end;end; return v; ", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), mapKey, this.encodeMapValue(value), msg, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        byte[] encodedKey = this.encodeMapKey(key);
        byte[] encodedValue = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(encodedKey);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        CacheValue cacheValue = new CacheValue(key, value);
        this.cache.put(cacheKey, cacheValue);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hset', KEYS[1], ARGV[1], ARGV[2]) == 0 then if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[3]); end;return 0; end; return 1; ", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), encodedKey, encodedValue, msg, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    public void destroy() {
        if (this.invalidationListenerId != 0) {
            this.invalidationTopic.removeListener(this.invalidationListenerId);
        }
        if (this.invalidationStatusListenerId != 0) {
            this.invalidationTopic.removeListener(this.invalidationStatusListenerId);
        }
    }

    @Override
    public RFuture<V> removeOperationAsync(K key) {
        byte[] keyEncoded = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(keyEncoded);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        this.cache.remove(cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); if redis.call('hdel', KEYS[1], ARGV[1]) == 1 then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[2]); end; if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[4], ARGV[5]);redis.call('publish', KEYS[2], ARGV[2]); end;end; return v", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), keyEncoded, msgEncoded, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    protected RFuture<List<Long>> fastRemoveOperationBatchAsync(K ... keys) {
        if (this.invalidateEntryOnChange == 1) {
            ArrayList<byte[]> params = new ArrayList<byte[]>(keys.length * 2);
            for (K k : keys) {
                byte[] keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for j = 1, #ARGV, 2 do local val = redis.call('hdel', KEYS[1], ARGV[j]);if val == 1 then redis.call('publish', KEYS[2], ARGV[j+1]); end;table.insert(result, val);end;return result;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), params.toArray());
        }
        if (this.invalidateEntryOnChange == 2) {
            ArrayList<Object> params = new ArrayList<Object>(keys.length * 3);
            params.add(System.currentTimeMillis());
            for (K k : keys) {
                byte[] keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
                params.add(entryId);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for j = 2, #ARGV, 3 do local val = redis.call('hdel', KEYS[1], ARGV[j]);if val == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[j+2]);redis.call('publish', KEYS[2], ARGV[j+1]); end;table.insert(result, val);end;return result;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), params.toArray());
        }
        ArrayList<byte[]> params = new ArrayList<byte[]>(keys.length);
        for (K k : keys) {
            byte[] keyEncoded = this.encodeMapKey(k);
            params.add(keyEncoded);
            CacheKey cacheKey = this.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
        }
        RFuture<List<Long>> future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for i = 1, #ARGV, 1 do local val = redis.call('hdel', KEYS[1], ARGV[i]); table.insert(result, val); end;return result;", Arrays.asList(this.getName()), params.toArray());
        return future;
    }

    @Override
    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        if (this.invalidateEntryOnChange == 1) {
            ArrayList<byte[]> params = new ArrayList<byte[]>(keys.length * 2);
            for (K k : keys) {
                byte[] keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 1, #ARGV, 2 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then redis.call('publish', KEYS[2], ARGV[j+1]); counter = counter + 1;end;end;return counter;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), params.toArray());
        }
        if (this.invalidateEntryOnChange == 2) {
            ArrayList<Object> params = new ArrayList<Object>(keys.length * 3);
            params.add(System.currentTimeMillis());
            for (K k : keys) {
                byte[] keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
                params.add(entryId);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 2, #ARGV, 3 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[j+2]);redis.call('publish', KEYS[2], ARGV[j+1]); counter = counter + 1;end;end;return counter;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), params.toArray());
        }
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.add(this.getName());
        for (K k : keys) {
            byte[] keyEncoded = this.encodeMapKey(k);
            params.add(keyEncoded);
            CacheKey cacheKey = this.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.HDEL, params.toArray());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.cache.clear();
        byte[] msgEncoded = this.encode(new LocalCachedMapClear());
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1], KEYS[3]) > 0 and ARGV[2] ~= '0' then redis.call('publish', KEYS[2], ARGV[1]); return 1;end; return 0;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), msgEncoded, this.invalidateEntryOnChange);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private Iterator<Map.Entry<K, V>> cacheEntrySetIterator() {
        final Iterator iter = this.cache.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry entry = (Map.Entry)iter.next();
                return new AbstractMap.SimpleEntry<Object, Object>(((CacheValue)entry.getValue()).getKey(), ((CacheValue)entry.getValue()).getValue());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    private Iterator<K> cacheKeySetIterator() {
        final Iterator iter = this.cache.values().iterator();
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public K next() {
                CacheValue value = (CacheValue)iter.next();
                return value.getKey();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        final HashMap result = new HashMap();
        HashSet<K> mapKeys = new HashSet<K>(keys);
        Iterator iterator = mapKeys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            CacheKey cacheKey = this.toCacheKey(key);
            CacheValue value = (CacheValue)this.cache.get(cacheKey);
            if (value == null) continue;
            result.put(key, value.getValue());
            iterator.remove();
        }
        final RPromise<Map<K, V>> promise = this.newPromise();
        RFuture future = super.getAllAsync(mapKeys);
        future.addListener(new FutureListener<Map<K, V>>(){

            @Override
            public void operationComplete(Future<Map<K, V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Map map = future.getNow();
                result.putAll(map);
                RedissonLocalCachedMap.this.cacheMap(map);
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    private void cacheMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            byte[] mapKey = this.encodeMapKey(entry.getKey());
            CacheKey cacheKey = this.toCacheKey(mapKey);
            CacheValue cacheValue = new CacheValue(entry.getKey(), entry.getValue());
            this.cache.put(cacheKey, cacheValue);
        }
    }

    @Override
    public RFuture<Void> putAllOperationAsync(final Map<? extends K, ? extends V> map) {
        ArrayList<Object> params = new ArrayList<Object>(map.size() * 3);
        params.add(this.invalidateEntryOnChange);
        params.add(map.size() * 2);
        byte[][] hashes = new byte[map.size()][];
        int i = 0;
        for (Map.Entry<K, V> t : map.entrySet()) {
            byte[] byArray = this.encodeMapKey(t.getKey());
            byte[] mapValue = this.encodeMapValue(t.getValue());
            params.add(byArray);
            params.add(mapValue);
            CacheKey cacheKey = this.toCacheKey(byArray);
            hashes[i] = cacheKey.getKeyHash();
            ++i;
        }
        if (this.invalidateEntryOnChange == 2) {
            long time = System.currentTimeMillis();
            for (byte[] hash : hashes) {
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(hash);
                params.add(time);
                params.add(entryId);
            }
        }
        byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, hashes));
        params.add(msgEncoded);
        final RPromise<Void> result = this.newPromise();
        RFuture rFuture = this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('hmset', KEYS[1], unpack(ARGV, 3, tonumber(ARGV[2]) + 2));if ARGV[1] == '1' then redis.call('publish', KEYS[2], ARGV[#ARGV]); end;if ARGV[1] == '2' then redis.call('zadd', KEYS[3], unpack(ARGV, tonumber(ARGV[2]) + 2 + 1, #ARGV - 1));redis.call('publish', KEYS[2], ARGV[#ARGV]); end;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), params.toArray());
        rFuture.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                RedissonLocalCachedMap.this.cacheMap(map);
                result.trySuccess(null);
            }
        });
        return result;
    }

    @Override
    public RFuture<V> addAndGetOperationAsync(final K key, Number value) {
        final byte[] keyState = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        RFuture future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("EVAL", new NumberConvertor(value.getClass())), "local result = redis.call('HINCRBYFLOAT', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return result; ", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), keyState, new BigDecimal(value.toString()).toPlainString(), this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Object value = future.getNow();
                if (value != null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(keyState);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(final K key, final V value) {
        RFuture<Boolean> future = super.fastPutIfAbsentAsync(key, value);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        final ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<byte[]> mapKeys = new ArrayList<byte[]>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.add(value.getValue());
        }
        final RPromise<Collection<V>> promise = this.newPromise();
        RFuture future = this.commandExecutor.evalReadAsync(this.getName(), this.codec, ALL_KEYS, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 ~= 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getName()), mapKeys.toArray());
        future.addListener(new FutureListener<Collection<V>>(){

            @Override
            public void operationComplete(Future<Collection<V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                result.addAll((Collection)future.get());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        final HashMap<Object, Object> result = new HashMap<Object, Object>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.put(value.getKey(), value.getValue());
        }
        final RPromise<Map<K, V>> promise = this.newPromise();
        RFuture future = this.readAll(ALL_MAP, mapKeys, result);
        future.addListener(new FutureListener<Map<K, V>>(){

            @Override
            public void operationComplete(Future<Map<K, V>> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                for (Map.Entry entry : future.getNow().entrySet()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(entry.getKey(), entry.getValue()));
                }
                result.putAll(future.getNow());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    @Override
    public void preloadCache() {
        for (Map.Entry entry : super.entrySet()) {
            CacheKey cacheKey = this.toCacheKey(entry.getKey());
            this.cache.put(cacheKey, new CacheValue(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        final HashSet<AbstractMap.SimpleEntry<Object, Object>> result = new HashSet<AbstractMap.SimpleEntry<Object, Object>>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.add(new AbstractMap.SimpleEntry<Object, Object>(value.getKey(), value.getValue()));
        }
        final RPromise<Set<Map.Entry<K, V>>> promise = this.newPromise();
        RFuture future = this.readAll(ALL_ENTRIES, mapKeys, result);
        future.addListener(new FutureListener<Set<Map.Entry<K, V>>>(){

            @Override
            public void operationComplete(Future<Set<Map.Entry<K, V>>> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                for (Map.Entry entry : future.getNow()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(entry.getKey(), entry.getValue()));
                }
                result.addAll(future.getNow());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    private <R> RFuture<R> readAll(RedisCommand<?> evalCommandType, List<Object> mapKeys, R result) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, evalCommandType, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 ~= 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j]);table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getName()), mapKeys.toArray());
    }

    @Override
    protected RFuture<V> replaceOperationAsync(K key, V value) {
        byte[] keyState = this.encodeMapKey(key);
        byte[] valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return v; else return nil; end", Arrays.asList(this.getName(key), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<V> replaceAsync(final K key, final V value) {
        byte[] keyState = this.encodeMapKey(key);
        final CacheKey cacheKey = this.toCacheKey(keyState);
        RFuture<V> future = super.replaceAsync(key, value);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow() != null) {
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    @Override
    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        byte[] keyState = this.encodeMapKey(key);
        byte[] oldValueState = this.encodeMapValue(oldValue);
        byte[] newValueState = this.encodeMapValue(newValue);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        return this.commandExecutor.evalWriteAsync(this.getName(key), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[5]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[6], ARGV[7]);redis.call('publish', KEYS[2], ARGV[5]); end;return 1; else return 0; end", Arrays.asList(this.getName(key), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), keyState, oldValueState, newValueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<Boolean> replaceAsync(final K key, V oldValue, final V newValue) {
        byte[] keyState = this.encodeMapKey(key);
        final CacheKey cacheKey = this.toCacheKey(keyState);
        RFuture<Boolean> future = super.replaceAsync(key, oldValue, newValue);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, newValue));
                }
            }
        });
        return future;
    }

    @Override
    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        byte[] keyState = this.encodeMapKey(key);
        byte[] valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        return this.commandExecutor.evalWriteAsync(this.getName(key), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Arrays.asList(this.getName(key), this.invalidationTopic.getChannelNames().get(0), this.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        byte[] keyState = this.encodeMapKey(key);
        final CacheKey cacheKey = this.toCacheKey(keyState);
        RFuture<Boolean> future = super.removeAsync(key, value);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonLocalCachedMap.this.cache.remove(cacheKey);
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<V> putIfAbsentAsync(final K key, final V value) {
        RFuture<V> future = super.putIfAbsentAsync(key, value);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow() == null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    abstract class CompositeIterable<T>
    implements Iterator<T> {
        private T currentObject;
        private Iterator<T> cacheIterator;
        private Iterator<T> mapIterator;

        public CompositeIterable(Iterator<T> cacheIterator, Iterator<T> mapIterator) {
            this.cacheIterator = cacheIterator;
            this.mapIterator = mapIterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.cacheIterator.hasNext()) {
                while (this.mapIterator.hasNext()) {
                    this.currentObject = this.mapIterator.next();
                    if (this.isCacheContains(this.currentObject)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        abstract boolean isCacheContains(T var1);

        @Override
        public T next() {
            if (this.currentObject != null) {
                T val = this.currentObject;
                this.currentObject = null;
                return val;
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cacheIterator.next();
        }

        @Override
        public void remove() {
            if (this.currentObject != null) {
                this.mapIterator.remove();
                this.currentObject = null;
                return;
            }
            this.cacheIterator.remove();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new CompositeIterable<Map.Entry<K, V>>(RedissonLocalCachedMap.this.cacheEntrySetIterator(), RedissonLocalCachedMap.super.entrySet().iterator()){

                @Override
                boolean isCacheContains(Map.Entry<K, V> entry) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    return RedissonLocalCachedMap.this.cache.containsKey(cacheKey);
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = RedissonLocalCachedMap.this.get(key);
            return value != null && value.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonLocalCachedMap.super.remove(key, value);
            }
            return false;
        }

        @Override
        public final int size() {
            return RedissonLocalCachedMap.this.size();
        }

        @Override
        public final void clear() {
            RedissonLocalCachedMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iter = RedissonLocalCachedMap.this.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)iter.next()).getValue();
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return RedissonLocalCachedMap.this.containsValue(o);
        }

        @Override
        public int size() {
            return RedissonLocalCachedMap.this.size();
        }

        @Override
        public void clear() {
            RedissonLocalCachedMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new CompositeIterable<K>(RedissonLocalCachedMap.this.cacheKeySetIterator(), RedissonLocalCachedMap.super.keySet().iterator()){

                @Override
                boolean isCacheContains(Object object) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(object);
                    return RedissonLocalCachedMap.this.cache.containsKey(cacheKey);
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return RedissonLocalCachedMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonLocalCachedMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return RedissonLocalCachedMap.this.size();
        }

        @Override
        public void clear() {
            RedissonLocalCachedMap.this.clear();
        }
    }

    public static class CacheValue
    implements Serializable {
        private final Object key;
        private final Object value;

        public CacheValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheValue other = (CacheValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "CacheValue [key=" + this.key + ", value=" + this.value + "]";
        }
    }

    public static class CacheKey
    implements Serializable {
        private final byte[] keyHash;

        public CacheKey(byte[] keyHash) {
            this.keyHash = keyHash;
        }

        public byte[] getKeyHash() {
            return this.keyHash;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.keyHash);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Arrays.equals(this.keyHash, other.keyHash);
        }

        public String toString() {
            return "CacheKey [keyHash=" + Arrays.toString(this.keyHash) + "]";
        }
    }
}

