/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.redisson.Redisson;
import org.redisson.RedissonPriorityQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RPriorityDeque;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.command.CommandExecutor;

public class RedissonPriorityDeque<V>
extends RedissonPriorityQueue<V>
implements RPriorityDeque<V> {
    private static final RedisCommand<Void> RPUSH_VOID = new RedisCommand<Void>("RPUSH", new VoidReplayConvertor(), 2, RedisCommand.ValueType.OBJECTS);
    private static final RedisCommand<Object> LRANGE_SINGLE = new RedisCommand<Object>("LRANGE", new ListFirstObjectDecoder());

    protected RedissonPriorityDeque(CommandExecutor commandExecutor, String name, Redisson redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonPriorityDeque(Codec codec, CommandExecutor commandExecutor, String name, Redisson redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public void addFirst(V e) {
        this.get(this.addFirstAsync(e));
    }

    public RFuture<Void> addFirstAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPUSH_VOID, this.getName(), e);
    }

    @Override
    public void addLast(V e) {
        this.get(this.addLastAsync(e));
    }

    public RFuture<Void> addLastAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RPUSH_VOID, this.getName(), e);
    }

    @Override
    public Iterator<V> descendingIterator() {
        return new Iterator<V>(){
            private int currentIndex;
            private boolean removeExecuted;
            {
                this.currentIndex = RedissonPriorityDeque.this.size();
            }

            @Override
            public boolean hasNext() {
                int size = RedissonPriorityDeque.this.size();
                return this.currentIndex > 0 && size > 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.removeExecuted = false;
                return RedissonPriorityDeque.this.get(this.currentIndex);
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonPriorityDeque.this.remove(this.currentIndex);
                ++this.currentIndex;
                this.removeExecuted = true;
            }
        };
    }

    public RFuture<V> getLastAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, LRANGE_SINGLE, this.getName(), -1, -1);
    }

    @Override
    public V getLast() {
        V result = this.get(this.getLastAsync());
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean offerFirst(V e) {
        return this.get(this.offerFirstAsync(e));
    }

    public RFuture<Boolean> offerFirstAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPUSH_BOOLEAN, this.getName(), e);
    }

    public RFuture<Boolean> offerLastAsync(V e) {
        return this.offerAsync(e);
    }

    @Override
    public boolean offerLast(V e) {
        return this.get(this.offerLastAsync(e));
    }

    public RFuture<V> peekFirstAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peekFirst() {
        return this.get(this.peekFirstAsync());
    }

    public RFuture<V> peekLastAsync() {
        return this.getLastAsync();
    }

    @Override
    public V peekLast() {
        return this.get(this.getLastAsync());
    }

    public RFuture<V> pollFirstAsync() {
        return this.pollAsync();
    }

    @Override
    public V pollFirst() {
        return this.poll();
    }

    public RFuture<V> pollLastAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPOP, this.getName());
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    public RFuture<V> popAsync() {
        return this.pollAsync();
    }

    @Override
    public V pop() {
        return this.removeFirst();
    }

    public RFuture<Void> pushAsync(V e) {
        return this.addFirstAsync(e);
    }

    @Override
    public void push(V e) {
        this.addFirst(e);
    }

    public RFuture<Boolean> removeFirstOccurrenceAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o, 1);
    }

    public RFuture<V> removeFirstAsync() {
        return this.pollAsync();
    }

    public RFuture<V> removeLastAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPOP, this.getName());
    }

    @Override
    public V removeLast() {
        V value = this.get(this.removeLastAsync());
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    public RFuture<Boolean> removeLastOccurrenceAsync(Object o) {
        return this.removeAsync(o, -1);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.remove(o, -1);
    }
}

