/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.util.Pool;
import com.esotericsoftware.kryo.util.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kryo5Codec
extends BaseCodec {
    private static final Logger logger = LoggerFactory.getLogger(Kryo5Codec.class);
    private static final List<String> MISSED_COLLECTION_CLASSES = Arrays.asList("Unmodifiable", "Synchronized", "Checked");
    private final Pool<Kryo> kryoPool;
    private final Pool<Input> inputPool;
    private final Pool<Output> outputPool;
    private final boolean registrationRequired;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Kryo kryo = (Kryo)Kryo5Codec.this.kryoPool.obtain();
            Input input = (Input)Kryo5Codec.this.inputPool.obtain();
            try {
                input.setInputStream(new ByteBufInputStream(buf));
                Object object = kryo.readClassAndObject(input);
                return object;
            }
            finally {
                Kryo5Codec.this.kryoPool.free(kryo);
                Kryo5Codec.this.inputPool.free(input);
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            Kryo kryo = (Kryo)Kryo5Codec.this.kryoPool.obtain();
            Output output = (Output)Kryo5Codec.this.outputPool.obtain();
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                output.setOutputStream(baos);
                kryo.writeClassAndObject(output, in);
                output.flush();
                ByteBuf byteBuf = baos.buffer();
                return byteBuf;
            }
            catch (RuntimeException e) {
                out.release();
                throw e;
            }
            finally {
                Kryo5Codec.this.kryoPool.free(kryo);
                Kryo5Codec.this.outputPool.free(output);
            }
        }
    };

    public Kryo5Codec() {
        this(null, false);
    }

    public Kryo5Codec(boolean registrationRequired) {
        this(null, registrationRequired);
    }

    public Kryo5Codec(ClassLoader classLoader, Kryo5Codec codec) {
        this(classLoader, codec.registrationRequired);
    }

    public Kryo5Codec(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public Kryo5Codec(final ClassLoader classLoader, boolean registrationRequired) {
        this.registrationRequired = registrationRequired;
        this.kryoPool = new Pool<Kryo>(true, false, 1024){

            @Override
            protected Kryo create() {
                return Kryo5Codec.this.createKryo(classLoader);
            }
        };
        this.inputPool = new Pool<Input>(true, false, 512){

            @Override
            protected Input create() {
                return new Input(8192);
            }
        };
        this.outputPool = new Pool<Output>(true, false, 512){

            @Override
            protected Output create() {
                return new Output(8192, -1);
            }
        };
    }

    protected Kryo createKryo(ClassLoader classLoader) {
        Kryo kryo = new Kryo();
        if (classLoader != null) {
            kryo.setClassLoader(classLoader);
        }
        kryo.setInstantiatorStrategy(new SimpleInstantiatorStrategy());
        kryo.setRegistrationRequired(this.registrationRequired);
        kryo.setReferences(false);
        try {
            Class<?>[] f = Collections.class.getDeclaredClasses();
            Arrays.stream(f).filter(cls -> MISSED_COLLECTION_CLASSES.stream().anyMatch(s -> cls.getName().contains((CharSequence)s))).forEach(cls -> kryo.addDefaultSerializer((Class)cls, new JavaSerializer()));
        }
        catch (Exception e) {
            logger.warn("Unable to register Collections serializer", e);
        }
        kryo.addDefaultSerializer(Throwable.class, new JavaSerializer());
        kryo.addDefaultSerializer(UUID.class, new DefaultSerializers.UUIDSerializer());
        kryo.addDefaultSerializer(URI.class, new DefaultSerializers.URISerializer());
        kryo.addDefaultSerializer(Pattern.class, new DefaultSerializers.PatternSerializer());
        return kryo;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    private static final class SimpleInstantiatorStrategy
    implements InstantiatorStrategy {
        private final StdInstantiatorStrategy ss = new StdInstantiatorStrategy();

        private SimpleInstantiatorStrategy() {
        }

        @Override
        public <T> ObjectInstantiator<T> newInstantiatorOf(final Class<T> type) {
            try {
                Constructor<T> ctor;
                try {
                    ctor = type.getConstructor(null);
                }
                catch (Exception ex) {
                    ctor = type.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                }
                final Constructor<T> constructor = ctor;
                return new ObjectInstantiator(){

                    public Object newInstance() {
                        try {
                            return constructor.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new KryoException("Error constructing instance of class: " + Util.className(type), ex);
                        }
                    }
                };
            }
            catch (Exception exception) {
                return this.ss.newInstantiatorOf(type);
            }
        }
    }
}

