/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.redisson.MapWriterTask;
import org.redisson.RedissonMap;
import org.redisson.WriteBehindService;
import org.redisson.api.MapOptions;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCacheNative;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MapExpiredListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonMapCacheNative<K, V>
extends RedissonMap<K, V>
implements RMapCacheNative<K, V> {
    public RedissonMapCacheNative(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(commandExecutor, name, redisson, options, writeBehindService);
    }

    public RedissonMapCacheNative(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    public RedissonMapCacheNative(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(codec, commandExecutor, name, redisson, options, writeBehindService);
    }

    @Override
    public V put(K key, V value, Duration ttl) {
        return this.get(this.putAsync(key, value, ttl));
    }

    @Override
    public RFuture<V> putAsync(K key, V value, Duration ttl) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl.toMillis() < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ttl.toMillis() == 0L) {
            return this.putAsync(key, value);
        }
        RFuture<V> future = this.putOperationAsync(key, value, ttl);
        future = new CompletableFutureWrapper<V>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, listener);
    }

    protected RFuture<V> putOperationAsync(K key, V value, Duration ttl) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return currValue; ", Collections.singletonList(name), ttl.toMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPut(K key, V value, Duration ttl) {
        return this.get(this.fastPutAsync(key, value, ttl));
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value, Duration ttl) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl.toMillis() < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ttl.toMillis() == 0L) {
            return this.fastPutAsync(key, value);
        }
        RFuture<Boolean> future = this.fastPutOperationAsync(key, value, ttl);
        future = new CompletableFutureWrapper<Boolean>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value, Duration ttl) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local added = redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return added;", Collections.singletonList(name), ttl.toMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public V putIfAbsent(K key, V value, Duration ttl) {
        return this.get(this.putIfAbsentAsync(key, value, ttl));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, Duration ttl) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl.toMillis() < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ttl.toMillis() == 0L) {
            return this.putIfAbsentAsync(key, value);
        }
        RFuture<V> future = this.putIfAbsentOperationAsync(key, value, ttl);
        future = new CompletableFutureWrapper<V>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r == null);
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value, Duration ttl) {
        String name = this.getRawName(key);
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local currValue = redis.call('hget', KEYS[1], ARGV[1]); if currValue ~= false then return currValue;end;redis.call('hdel', KEYS[1], ARGV[1]); return nil; ", Collections.singletonList(name), this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); if currValue ~= false then return currValue;end;redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return nil; ", Collections.singletonList(name), ttl.toMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value, Duration ttl) {
        return this.get(this.fastPutIfAbsentAsync(key, value, ttl));
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, Duration ttl) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl.toMillis() < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (ttl.toMillis() == 0L) {
            return this.fastPutIfAbsentAsync(key, value);
        }
        RFuture<Boolean> future = this.fastPutIfAbsentOperationAsync(key, value, ttl);
        future = new CompletableFutureWrapper<Boolean>(future);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value, Duration ttl) {
        String name = this.getRawName(key);
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('hget', KEYS[1], ARGV[1]); if currValue ~= false then return 0;end;redis.call('hdel', KEYS[1], ARGV[1]); return 1; ", Collections.singletonList(name), this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('hget', KEYS[1], ARGV[2]); if currValue ~= false then return 0;end;redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); return 1; ", Collections.singletonList(name), ttl.toMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public long remainTimeToLive(K key) {
        return this.get(this.remainTimeToLiveAsync(key));
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync(K key) {
        this.checkKey(key);
        String name = this.getRawName(key);
        return this.commandExecutor.readAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.HPTTL, name, "FIELDS", 1, this.encodeMapKey(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Duration ttl) {
        this.get(this.putAllAsync(map, ttl));
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Duration ttl) {
        if (map.isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<Void> future = this.putAllOperationAsync(map, ttl);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(map);
        return this.mapWriterFuture(future, listener);
    }

    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map, Duration ttl) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(ttl.toMillis());
        this.encodeMapKeys(args, map);
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "for i = 2, #ARGV, 2 do redis.call('hset', KEYS[1], ARGV[i], ARGV[i + 1]); redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[i]); end; ", Collections.singletonList(this.name), args.toArray());
    }

    @Override
    public boolean expireEntry(K key, Duration ttl) {
        return this.get(this.expireEntryAsync(key, ttl));
    }

    @Override
    public RFuture<Boolean> expireEntryAsync(K key, Duration ttl) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expireSet = redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[2]); if #expireSet > 0 and expireSet[1] >= 1 then return 1;end; return 0; ", Arrays.asList(name), ttl.toMillis(), this.encodeMapKey(key));
    }

    @Override
    public boolean expireEntryIfNotSet(K key, Duration ttl) {
        return this.get(this.expireEntryIfNotSetAsync(key, ttl));
    }

    @Override
    public RFuture<Boolean> expireEntryIfNotSetAsync(K key, Duration ttl) {
        return this.expireEntryAsync("NX", key, ttl);
    }

    private RFuture<Boolean> expireEntryAsync(String param, K key, Duration ttl) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expireSet = redis.call('hpexpire', KEYS[1], ARGV[1], ARGV[3], 'fields', 1, ARGV[2]); if #expireSet > 0 and expireSet[1] >= 1 then return 1;end; return 0; ", Arrays.asList(name), ttl.toMillis(), this.encodeMapKey(key), param);
    }

    @Override
    public int expireEntries(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesAsync(keys, ttl));
    }

    @Override
    public RFuture<Integer> expireEntriesAsync(Set<K> keys, Duration ttl) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(ttl.toMillis());
        this.encodeMapKeys(args, keys);
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local result = 0;for j = 2, #ARGV, 1 do local expireSet = redis.call('hpexpire', KEYS[1], ARGV[1], 'fields', 1, ARGV[j]); if #expireSet > 0 and expireSet[1] >= 1 then result = result + 1;end; end; return result; ", Arrays.asList(this.name), args.toArray());
    }

    @Override
    public int expireEntriesIfNotSet(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesIfNotSetAsync(keys, ttl));
    }

    @Override
    public RFuture<Integer> expireEntriesIfNotSetAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsync("NX", keys, ttl);
    }

    private RFuture<Integer> expireEntriesAsync(String param, Set<K> keys, Duration ttl) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(param);
        args.add(ttl.toMillis());
        this.encodeMapKeys(args, keys);
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local result = 0;for j = 3, #ARGV, 1 do local expireSet = redis.call('hpexpire', KEYS[1], ARGV[2], ARGV[1], 'fields', 1, ARGV[j]); if #expireSet > 0 and expireSet[1] >= 1 then result = result + 1;end; end; return result; ", Arrays.asList(this.name), args.toArray());
    }

    @Override
    public boolean expireEntryIfGreater(K key, Duration ttl) {
        return this.get(this.expireEntryIfGreaterAsync(key, ttl));
    }

    @Override
    public boolean expireEntryIfLess(K key, Duration ttl) {
        return this.get(this.expireEntryIfLessAsync(key, ttl));
    }

    @Override
    public int expireEntriesIfGreater(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesIfGreaterAsync(keys, ttl));
    }

    @Override
    public int expireEntriesIfLess(Set<K> keys, Duration ttl) {
        return this.get(this.expireEntriesIfLessAsync(keys, ttl));
    }

    @Override
    public RFuture<Boolean> expireEntryIfGreaterAsync(K key, Duration ttl) {
        return this.expireEntryAsync("GT", key, ttl);
    }

    @Override
    public RFuture<Boolean> expireEntryIfLessAsync(K key, Duration ttl) {
        return this.expireEntryAsync("LT", key, ttl);
    }

    @Override
    public RFuture<Integer> expireEntriesIfGreaterAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsync("GT", keys, ttl);
    }

    @Override
    public RFuture<Integer> expireEntriesIfLessAsync(Set<K> keys, Duration ttl) {
        return this.expireEntriesAsync("LT", keys, ttl);
    }

    @Override
    public boolean clearExpire(K key) {
        return this.get(this.clearExpireAsync(key));
    }

    @Override
    public RFuture<Boolean> clearExpireAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.HPERSIST, name, this.encodeMapKey(key));
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof MapExpiredListener) {
            return this.addListener("__keyevent@*:hexpire", (MapExpiredListener)listener, MapExpiredListener::onExpired);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof MapExpiredListener) {
            return this.addListenerAsync("__keyevent@*:hexpire", (MapExpiredListener)listener, MapExpiredListener::onExpired);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:hexpire");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(super.removeListenerAsync(listenerId), listenerId, "__keyevent@*:hexpire");
    }
}

