/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Descriptor;
import jodd.introspector.Mapper;
import jodd.introspector.MapperFunction;
import jodd.introspector.MapperFunctionInstances;
import jodd.introspector.MethodParamDescriptor;
import jodd.util.ClassUtil;

public class MethodDescriptor
extends Descriptor {
    private static final MethodParamDescriptor[] NO_PARAMS = new MethodParamDescriptor[0];
    protected final Method method;
    protected final Type returnType;
    protected final Class rawReturnType;
    protected final Class rawReturnComponentType;
    protected final Class rawReturnKeyComponentType;
    protected final MethodParamDescriptor[] parameters;
    protected final MapperFunction mapperFunction;

    public MethodDescriptor(ClassDescriptor classDescriptor, Method method) {
        super(classDescriptor, ClassUtil.isPublic(method));
        this.method = method;
        this.returnType = method.getGenericReturnType();
        this.rawReturnType = ClassUtil.getRawType(this.returnType, classDescriptor.getType());
        Class[] componentTypes = ClassUtil.getComponentTypes(this.returnType, classDescriptor.getType());
        if (componentTypes != null) {
            this.rawReturnComponentType = componentTypes[componentTypes.length - 1];
            this.rawReturnKeyComponentType = componentTypes[0];
        } else {
            this.rawReturnComponentType = null;
            this.rawReturnKeyComponentType = null;
        }
        ClassUtil.forceAccess(method);
        Mapper mapper = method.getAnnotation(Mapper.class);
        this.mapperFunction = mapper != null ? MapperFunctionInstances.get().lookup(mapper.value()) : null;
        if (method.getParameterCount() == 0) {
            this.parameters = NO_PARAMS;
        } else {
            this.parameters = new MethodParamDescriptor[method.getParameterCount()];
            Class<?>[] params = method.getParameterTypes();
            Type[] genericParams = method.getGenericParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                Class<?> parameterType = params[i];
                Class<?> rawParameterType = genericParams.length == 0 ? parameterType : ClassUtil.getRawType(genericParams[i], classDescriptor.getType());
                Class rawParameterComponentType = genericParams.length == 0 ? null : ClassUtil.getComponentType(genericParams[i], classDescriptor.getType(), -1);
                this.parameters[i] = new MethodParamDescriptor(parameterType, rawParameterType, rawParameterComponentType);
            }
        }
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getRawReturnType() {
        return this.rawReturnType;
    }

    public Class getRawReturnComponentType() {
        return this.rawReturnComponentType;
    }

    public Class getRawReturnKeyComponentType() {
        return this.rawReturnKeyComponentType;
    }

    public Class[] resolveRawReturnComponentTypes() {
        return ClassUtil.getComponentTypes(this.returnType, this.classDescriptor.getType());
    }

    public MethodParamDescriptor[] getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public String toString() {
        return this.classDescriptor.getType().getSimpleName() + '#' + this.method.getName() + "()";
    }
}

