/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class AsyncSemaphore {
    private final AtomicInteger counter;
    private final Queue<CompletableFuture<Void>> listeners = new ConcurrentLinkedQueue<CompletableFuture<Void>>();

    public AsyncSemaphore(int permits) {
        this.counter = new AtomicInteger(permits);
    }

    public int queueSize() {
        return this.listeners.size();
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public CompletableFuture<Void> acquire() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listeners.add(future);
        this.tryRun();
        return future;
    }

    private void tryRun() {
        do {
            if (this.counter.decrementAndGet() < 0) continue;
            CompletableFuture<Void> future = this.listeners.poll();
            if (future == null) {
                this.counter.incrementAndGet();
                return;
            }
            if (!future.complete(null)) continue;
            return;
        } while (this.counter.incrementAndGet() > 0);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void release() {
        this.counter.incrementAndGet();
        this.tryRun();
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }
}

