/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonLock;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonSemaphore;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.ObjectListener;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.redisson.api.SortOrder;
import org.redisson.api.listener.SetAddListener;
import org.redisson.api.listener.SetRemoveListener;
import org.redisson.api.listener.SetRemoveRandomListener;
import org.redisson.api.listener.TrackingListener;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonSet<V>
extends RedissonExpirable
implements RSet<V>,
ScanIterator {
    RedissonClient redisson;

    public RedissonSet(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        this.redisson = redisson;
    }

    public RedissonSet(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        this.redisson = redisson;
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SCARD_INT, this.getRawName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        String name = this.getRawName(o);
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.SISMEMBER, name, this.encode(o));
    }

    @Override
    public ScanResult<Object> scanIterator(String name, RedisClient client, String startPos, String pattern, int count) {
        return this.get(this.scanIteratorAsync(name, client, startPos, pattern, count));
    }

    @Override
    public Iterator<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Iterator<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Iterator<V> iterator(final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return RedissonSet.this.scanIterator(RedissonSet.this.getRawName(), client, nextIterPos, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSet.this.remove(value);
            }
        };
    }

    @Override
    public Iterator<V> distributedIterator(String pattern) {
        String iteratorName = "__redisson_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, pattern, 10);
    }

    @Override
    public Iterator<V> distributedIterator(int count) {
        String iteratorName = "__redisson_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, null, count);
    }

    @Override
    public Iterator<V> distributedIterator(final String iteratorName, final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return RedissonSet.this.distributedScanIterator(iteratorName, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSet.this.remove(value);
            }
        };
    }

    private ScanResult<Object> distributedScanIterator(String iteratorName, String pattern, int count) {
        return this.get(this.distributedScanIteratorAsync(iteratorName, pattern, count));
    }

    private RFuture<ScanResult<Object>> distributedScanIteratorAsync(String iteratorName, String pattern, int count) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        if (pattern != null) {
            args.add(pattern);
        }
        args.add(count);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SCAN, "local cursor = redis.call('get', KEYS[2]); if cursor ~= false then cursor = tonumber(cursor); else cursor = 0;end;if cursor == -1 then return {'0', {}}; end;local result; if (#ARGV == 2) then result = redis.call('sscan', KEYS[1], cursor, 'match', ARGV[1], 'count', ARGV[2]); else result = redis.call('sscan', KEYS[1], cursor, 'count', ARGV[1]); end;local next_cursor = result[1]if next_cursor ~= \"0\" then redis.call('setex', KEYS[2], 3600, next_cursor);else redis.call('setex', KEYS[2], 3600, -1);end; return result;", Arrays.asList(this.getRawName(), iteratorName), args.toArray());
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SMEMBERS, this.getRawName());
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        String name = this.getRawName(e);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.SADD_SINGLE, name, this.encode(e));
    }

    @Override
    public V removeRandom() {
        return this.get(this.removeRandomAsync());
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SPOP_SINGLE, this.getRawName());
    }

    @Override
    public Set<V> removeRandom(int amount) {
        return this.get(this.removeRandomAsync(amount));
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SPOP, this.getRawName(), amount);
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public RFuture<V> randomAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SRANDMEMBER_SINGLE, this.getRawName());
    }

    @Override
    public Set<V> random(int count) {
        return this.get(this.randomAsync(count));
    }

    @Override
    public RFuture<Set<V>> randomAsync(int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SRANDMEMBER, this.getRawName(), count);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        String name = this.getRawName(o);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.SREM_SINGLE, name, this.encode(o));
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        String name = this.getRawName(member);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.SMOVE, name, destination, this.encode(member));
    }

    @Override
    public boolean move(String destination, V member) {
        return this.get(this.moveAsync(destination, member));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(true);
        }
        String tempName = RedissonSet.suffixName(this.getRawName(), "redisson_temp");
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('sadd', KEYS[2], unpack(ARGV)); local size = redis.call('sdiff', KEYS[2], KEYS[1]);redis.call('del', KEYS[2]); return #size == 0 and 1 or 0; ", Arrays.asList(this.getRawName(), tempName), this.encode(c).toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SADD_BOOL, args.toArray());
    }

    @Override
    public RFuture<Integer> addAllCountedAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SADD, args.toArray());
    }

    @Override
    public int addAllCounted(Collection<? extends V> c) {
        return this.get(this.addAllCountedAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        String tempName = RedissonSet.suffixName(this.getRawName(), "redisson_temp");
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('sadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('scard', KEYS[1]); local size = redis.call('sinterstore', KEYS[1], KEYS[1], KEYS[2]);redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getRawName(), tempName), this.encode(c).toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SREM_SINGLE, args.toArray());
    }

    @Override
    public int removeAllCounted(Collection<? extends V> c) {
        return this.get(this.removeAllCountedAsync(c));
    }

    @Override
    public RFuture<Integer> removeAllCountedAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SREM, args.toArray());
    }

    @Override
    public RFuture<List<V>> containsEachAsync(Collection<V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<List<V>>(Collections.emptyList());
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encode(args, c);
        RFuture future = this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SMISMEMBER, args.toArray());
        ArrayList keysToCheck = new ArrayList(c);
        CompletionStage<List> f = future.thenApply(res -> {
            ArrayList containedKeys = new ArrayList();
            for (int i = 0; i < res.size(); ++i) {
                if ((Long)res.get(i) != 1L) continue;
                containedKeys.add(keysToCheck.get(i));
            }
            return containedKeys;
        });
        return new CompletableFutureWrapper<List<V>>(f);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SUNION, args.toArray());
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SDIFFSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SDIFF, args.toArray());
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SINTERSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SINTER, args.toArray());
    }

    @Override
    public Integer countIntersection(String ... names) {
        return this.get(this.countIntersectionAsync(names));
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(String ... names) {
        return this.countIntersectionAsync(0, names);
    }

    @Override
    public Integer countIntersection(int limit, String ... names) {
        return this.get(this.countIntersectionAsync(limit, names));
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(int limit, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 1);
        args.add(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        if (limit > 0) {
            args.add("LIMIT");
            args.add(limit);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SINTERCARD_INT, args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), order});
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "LIMIT", offset, count, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, "LIMIT", offset, count, order});
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, false);
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order) {
        return this.get(this.readSortAlphaAsync(order));
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(order, offset, count));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, order));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, order, offset, count));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "ALPHA", order});
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "LIMIT", offset, count, "ALPHA", order});
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, "ALPHA", order});
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, "LIMIT", offset, count, "ALPHA", order});
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAlphaAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, true);
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        params.add("STORE");
        params.add(destName);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SORT_TO, params.toArray());
    }

    @Override
    public boolean tryAdd(V ... values) {
        return this.get(this.tryAddAsync(values));
    }

    @Override
    public List<V> containsEach(Collection<V> c) {
        return this.get(this.containsEachAsync(c));
    }

    @Override
    public RFuture<Boolean> tryAddAsync(V ... values) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for i, v in ipairs(ARGV) do if redis.call('sismember', KEYS[1], v) == 1 then return 0; end; end; for i=1, #ARGV, 5000 do redis.call('sadd', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); end; return 1; ", Arrays.asList(this.getRawName()), this.encode(Arrays.asList(values)).toArray());
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        String lockName = this.getLockByValue(value, "permitexpirablesemaphore");
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RSemaphore getSemaphore(V value) {
        String lockName = this.getLockByValue(value, "semaphore");
        return new RedissonSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RCountDownLatch getCountDownLatch(V value) {
        String lockName = this.getLockByValue(value, "countdownlatch");
        return new RedissonCountDownLatch(this.commandExecutor, lockName);
    }

    @Override
    public RLock getFairLock(V value) {
        String lockName = this.getLockByValue(value, "fairlock");
        return new RedissonFairLock(this.commandExecutor, lockName);
    }

    @Override
    public RLock getLock(V value) {
        String lockName = this.getLockByValue(value, "lock");
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(V value) {
        String lockName = this.getLockByValue(value, "rw_lock");
        return new RedissonReadWriteLock(this.commandExecutor, lockName);
    }

    @Override
    public RFuture<ScanResult<Object>> scanIteratorAsync(String name, RedisClient client, String startPos, String pattern, int count) {
        if (pattern == null) {
            return this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.SSCAN, name, startPos, "COUNT", count);
        }
        return this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.SSCAN, name, startPos, "MATCH", pattern, "COUNT", count);
    }

    private <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count, boolean alpha) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        if (getPatterns != null) {
            for (String pattern : getPatterns) {
                params.add("GET");
                params.add(pattern);
            }
        }
        if (alpha) {
            params.add("ALPHA");
        }
        if (order != null) {
            params.add((Object)order);
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, params.toArray());
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public Stream<V> stream(String pattern, int count) {
        return this.toStream(this.iterator(pattern, count));
    }

    @Override
    public Stream<V> stream(String pattern) {
        return this.toStream(this.iterator(pattern));
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof SetAddListener) {
            return this.addListener("__keyevent@*:sadd", (SetAddListener)listener, SetAddListener::onAdd);
        }
        if (listener instanceof SetRemoveListener) {
            return this.addListener("__keyevent@*:srem", (SetRemoveListener)listener, SetRemoveListener::onRemove);
        }
        if (listener instanceof SetRemoveRandomListener) {
            return this.addListener("__keyevent@*:spop", (SetRemoveRandomListener)listener, SetRemoveRandomListener::onRandomRemove);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListener((TrackingListener)listener);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof SetAddListener) {
            return this.addListenerAsync("__keyevent@*:sadd", (SetAddListener)listener, SetAddListener::onAdd);
        }
        if (listener instanceof SetRemoveListener) {
            return this.addListenerAsync("__keyevent@*:srem", (SetRemoveListener)listener, SetRemoveListener::onRemove);
        }
        if (listener instanceof SetRemoveRandomListener) {
            return this.addListenerAsync("__keyevent@*:spop", (SetRemoveRandomListener)listener, SetRemoveRandomListener::onRandomRemove);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListenerAsync((TrackingListener)listener);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeTrackingListener(listenerId);
        this.removeListener(listenerId, "__keyevent@*:sadd", "__keyevent@*:srem", "__keyevent@*:spop");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RFuture<Void> f1 = this.removeTrackingListenerAsync(listenerId);
        RFuture<Void> f2 = this.removeListenerAsync(listenerId, "__keyevent@*:sadd", "__keyevent@*:srem", "__keyevent@*:spop");
        return new CompletableFutureWrapper<Void>(CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture()));
    }
}

