/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedisURI;

public class SingleEntry
extends MasterSlaveEntry {
    public SingleEntry(ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        super(connectionManager, config);
    }

    @Override
    public CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, RedisURI addr) {
        return super.connectionWriteOp(command);
    }

    @Override
    public CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, boolean trackChanges) {
        if (trackChanges) {
            return super.trackedConnectionWriteOp(command);
        }
        return super.connectionWriteOp(command);
    }

    @Override
    public void releaseRead(RedisConnection connection, boolean trackChanges) {
        if (trackChanges) {
            super.releaseTrackedWrite(connection);
            return;
        }
        super.releaseWrite(connection);
    }

    @Override
    public Collection<ClientConnectionsEntry> getAllEntries() {
        return Collections.singletonList(this.masterEntry);
    }

    @Override
    public ClientConnectionsEntry getEntry(RedisClient redisClient) {
        if (this.masterEntry.getClient().equals(redisClient)) {
            return this.masterEntry;
        }
        return null;
    }

    @Override
    public ClientConnectionsEntry getEntry(RedisURI addr) {
        if (addr.equals(this.masterEntry.getClient().getAddr())) {
            return this.masterEntry;
        }
        return null;
    }
}

