/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.CommandReactiveService;
import reactor.core.publisher.Mono;

public class CommandReactiveBatchService
extends CommandReactiveService {
    private final CommandBatchService batchService;

    public CommandReactiveBatchService(ConnectionManager connectionManager, CommandReactiveExecutor commandExecutor, BatchOptions options) {
        super(connectionManager, commandExecutor.getObjectBuilder());
        this.batchService = new CommandBatchService(commandExecutor, options, RedissonObjectBuilder.ReferenceType.REACTIVE);
    }

    @Override
    public <R> Mono<R> reactive(final Callable<RFuture<R>> supplier) {
        Mono mono = super.reactive(new Callable<RFuture<R>>(){
            final CompletableFuture<R> future = new CompletableFuture();
            final AtomicBoolean lock = new AtomicBoolean();

            @Override
            public RFuture<R> call() throws Exception {
                if (this.lock.compareAndSet(false, true)) {
                    CommandReactiveBatchService.this.transfer(((RFuture)supplier.call()).toCompletableFuture(), this.future);
                }
                return new CompletableFutureWrapper(this.future);
            }
        });
        mono.subscribe();
        return mono;
    }

    @Override
    protected <R> CompletableFuture<R> createPromise() {
        return this.batchService.createPromise();
    }

    @Override
    public <V, R> RFuture<R> async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, boolean ignoreRedirect, boolean noRetry) {
        return this.batchService.async(readOnlyMode, nodeSource, codec, command, params, ignoreRedirect, noRetry);
    }

    public RFuture<BatchResult<?>> executeAsync() {
        return this.batchService.executeAsync();
    }

    @Override
    protected boolean isEvalCacheActive() {
        return false;
    }

    public RFuture<Void> discardAsync() {
        return this.batchService.discardAsync();
    }
}

