/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.ConnectionsHolder;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.WrappedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionsEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionsHolder<RedisConnection> connectionsHolder;
    private final ConnectionsHolder<RedisPubSubConnection> pubSubConnectionsHolder;
    private volatile FreezeReason freezeReason;
    final RedisClient client;
    private volatile NodeType nodeType;
    private final IdleConnectionWatcher idleConnectionWatcher;
    private final ConnectionManager connectionManager;
    private final MasterSlaveServersConfig config;
    private volatile boolean initialized = false;
    private final WrappedLock lock = new WrappedLock();

    public ClientConnectionsEntry(RedisClient client, int poolMinSize, int poolMaxSize, ConnectionManager connectionManager, NodeType nodeType, MasterSlaveServersConfig config) {
        this.client = client;
        this.connectionsHolder = new ConnectionsHolder(client, poolMaxSize, r -> r.connectAsync(), connectionManager.getServiceManager(), true);
        this.idleConnectionWatcher = connectionManager.getServiceManager().getConnectionWatcher();
        this.connectionManager = connectionManager;
        this.nodeType = nodeType;
        this.config = config;
        this.pubSubConnectionsHolder = new ConnectionsHolder(client, config.getSubscriptionConnectionPoolSize(), r -> r.connectPubSubAsync(), connectionManager.getServiceManager(), false);
        if (config.getSubscriptionConnectionPoolSize() > 0) {
            this.idleConnectionWatcher.add(this, config.getSubscriptionConnectionMinimumIdleSize(), config.getSubscriptionConnectionPoolSize(), this.pubSubConnectionsHolder);
        }
        this.idleConnectionWatcher.add(this, poolMinSize, poolMaxSize, this.connectionsHolder);
    }

    public CompletableFuture<Void> initConnections(int minimumIdleSize) {
        return this.connectionsHolder.initConnections(minimumIdleSize);
    }

    public CompletableFuture<Void> initPubSubConnections(int minimumIdleSize) {
        return this.pubSubConnectionsHolder.initConnections(minimumIdleSize);
    }

    public boolean isMasterForRead() {
        return this.getFreezeReason() == FreezeReason.SYSTEM && this.config.getReadMode() == ReadMode.MASTER_SLAVE && this.getNodeType() == NodeType.MASTER;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean isInited) {
        this.initialized = isInited;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public CompletableFuture<Void> shutdownAsync() {
        this.idleConnectionWatcher.remove(this);
        return this.client.shutdownAsync().toCompletableFuture();
    }

    public RedisClient getClient() {
        return this.client;
    }

    public boolean isFreezed() {
        return this.freezeReason != null;
    }

    public void setFreezeReason(FreezeReason freezeReason) {
        this.freezeReason = freezeReason;
        if (freezeReason != null) {
            this.initialized = false;
        }
    }

    public FreezeReason getFreezeReason() {
        return this.freezeReason;
    }

    public WrappedLock getLock() {
        return this.lock;
    }

    public void reattachPubSub() {
        this.pubSubConnectionsHolder.getFreeConnectionsCounter().removeListeners();
        for (RedisPubSubConnection connection : this.pubSubConnectionsHolder.getAllConnections()) {
            connection.closeAsync();
            this.connectionManager.getSubscribeService().reattachPubSub(connection);
        }
        this.pubSubConnectionsHolder.getFreeConnections().clear();
        this.pubSubConnectionsHolder.getAllConnections().clear();
    }

    public void nodeDown() {
        this.connectionsHolder.getFreeConnectionsCounter().removeListeners();
        for (RedisConnection connection : this.connectionsHolder.getAllConnections()) {
            connection.closeAsync();
            this.reattachBlockingQueue(connection.getCurrentCommand());
        }
        this.connectionsHolder.getFreeConnections().clear();
        this.connectionsHolder.getAllConnections().clear();
        this.reattachPubSub();
    }

    private void reattachBlockingQueue(CommandData<?, ?> commandData) {
        MasterSlaveEntry entry;
        if (commandData == null || !commandData.isBlockingCommand() || commandData.getPromise().isDone()) {
            return;
        }
        String key = null;
        for (int i = 0; i < commandData.getParams().length; ++i) {
            Object param = commandData.getParams()[i];
            if (!"STREAMS".equals(param)) continue;
            key = (String)commandData.getParams()[i + 1];
            break;
        }
        if (key == null) {
            key = (String)commandData.getParams()[0];
        }
        if ((entry = this.connectionManager.getEntry(key)) == null) {
            this.connectionManager.getServiceManager().newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
            return;
        }
        CompletableFuture<RedisConnection> newConnectionFuture = entry.connectionWriteOp(commandData.getCommand());
        newConnectionFuture.whenComplete((newConnection, e) -> {
            if (e != null) {
                this.connectionManager.getServiceManager().newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
                return;
            }
            commandData.getPromise().whenComplete((r, ex) -> entry.releaseWrite((RedisConnection)newConnection));
            ChannelFuture channelFuture = newConnection.send(commandData);
            channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    this.connectionManager.getServiceManager().newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
                    return;
                }
                this.log.info("command '{}' has been resent to '{}'", (Object)commandData, (Object)newConnection.getRedisClient());
            }));
        });
    }

    public ConnectionsHolder<RedisConnection> getConnectionsHolder() {
        return this.connectionsHolder;
    }

    public ConnectionsHolder<RedisPubSubConnection> getPubSubConnectionsHolder() {
        return this.pubSubConnectionsHolder;
    }

    public String toString() {
        return "ClientConnectionsEntry{connectionsHolder=" + this.connectionsHolder + ", pubSubConnectionsHolder=" + this.pubSubConnectionsHolder + ", freezeReason=" + (Object)((Object)this.freezeReason) + ", client=" + this.client + ", nodeType=" + (Object)((Object)this.nodeType) + ", initialized=" + this.initialized + '}';
    }

    public static enum FreezeReason {
        MANAGER,
        RECONNECT,
        SYSTEM;

    }
}

