/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.BatchOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandBatchService;
import org.redisson.command.RedisExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;

public class BaseRedisBatchExecutor<V, R>
extends RedisExecutor<V, R> {
    final ConcurrentMap<NodeSource, CommandBatchService.Entry> commands;
    final BatchOptions options;
    final AtomicInteger index;
    final AtomicBoolean executed;

    public BaseRedisBatchExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, CompletableFuture<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, ConcurrentMap<NodeSource, CommandBatchService.Entry> commands, BatchOptions options, AtomicInteger index, AtomicBoolean executed, RedissonObjectBuilder.ReferenceType referenceType, boolean noRetry) {
        super(readOnlyMode, source, codec, command, params, mainPromise, ignoreRedirect, connectionManager, objectBuilder, referenceType, noRetry, BaseRedisBatchExecutor.retryAttempts(connectionManager, options), BaseRedisBatchExecutor.retryInterval(connectionManager, options), BaseRedisBatchExecutor.timeout(connectionManager, options));
        this.commands = commands;
        this.options = options;
        this.index = index;
        this.executed = executed;
    }

    private static int timeout(ConnectionManager connectionManager, BatchOptions options) {
        int result = connectionManager.getServiceManager().getConfig().getTimeout();
        if (options.getResponseTimeout() > 0L) {
            result = (int)options.getResponseTimeout();
        }
        if (options.getSyncSlaves() > 0) {
            result += (int)options.getSyncTimeout();
        }
        return result;
    }

    private static int retryInterval(ConnectionManager connectionManager, BatchOptions options) {
        if (options.getRetryInterval() > 0L) {
            return (int)options.getRetryInterval();
        }
        return connectionManager.getServiceManager().getConfig().getRetryInterval();
    }

    private static int retryAttempts(ConnectionManager connectionManager, BatchOptions options) {
        if (options.getRetryAttempts() >= 0) {
            return options.getRetryAttempts();
        }
        return connectionManager.getServiceManager().getConfig().getRetryAttempts();
    }

    protected final void addBatchCommandData(Object[] batchParams) {
        CommandBatchService.Entry entry = this.commands.computeIfAbsent(this.source, k -> new CommandBatchService.Entry());
        if (!this.readOnlyMode) {
            entry.setReadOnlyMode(false);
        }
        Codec codecToUse = this.getCodec(this.codec);
        BatchCommandData commandData = new BatchCommandData(this.mainPromise, codecToUse, this.command, batchParams, this.index.incrementAndGet());
        entry.addCommand(commandData);
    }
}

