/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;

public class RedissonTopicRx {
    private final RTopic topic;

    public RedissonTopicRx(RTopic topic) {
        this.topic = topic;
    }

    public <M> Flowable<M> getMessages(final Class<M> type) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long n) throws Exception {
                final AtomicLong counter = new AtomicLong(n);
                RFuture<Integer> t = RedissonTopicRx.this.topic.addListenerAsync(type, new MessageListener<M>(){

                    @Override
                    public void onMessage(CharSequence channel, M msg) {
                        p.onNext(msg);
                        if (counter.decrementAndGet() == 0L) {
                            RedissonTopicRx.this.topic.removeListenerAsync(this);
                            p.onComplete();
                        }
                    }
                });
                t.whenComplete((id, e) -> {
                    if (e != null) {
                        p.onError((Throwable)e);
                        return;
                    }
                    p.doOnCancel(new Action(){
                        final /* synthetic */ Integer val$id;
                        {
                            this.val$id = n;
                        }

                        @Override
                        public void run() throws Exception {
                            RedissonTopicRx.this.topic.removeListenerAsync(this.val$id);
                        }
                    });
                });
            }
        });
    }
}

