/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final AtomicLong index = new AtomicLong();
    private final List<Collection<CachedValue<K, V>>> queues = new ArrayList<Collection<CachedValue<K, V>>>();
    private final Map<Collection<CachedValue<K, V>>, Lock> queueLocks = new IdentityHashMap<Collection<CachedValue<K, V>>, Lock>();

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2; ++i) {
            Set instance = Collections.synchronizedSet(new LinkedHashSet());
            this.queues.add(instance);
            this.queueLocks.put(instance, new ReentrantLock());
        }
    }

    @Override
    protected void onValueCreate(CachedValue<K, V> value) {
        Collection<CachedValue<K, V>> queue = this.getQueue(value);
        queue.add(value);
    }

    private Collection<CachedValue<K, V>> getQueue(CachedValue<K, V> value) {
        return this.queues.get(Math.abs(value.hashCode() % this.queues.size()));
    }

    @Override
    protected void onValueRemove(CachedValue<K, V> value) {
        Collection<CachedValue<K, V>> queue = this.getQueue(value);
        queue.remove(value);
    }

    @Override
    protected void onValueRead(CachedValue<K, V> value) {
        Collection<CachedValue<K, V>> queue = this.getQueue(value);
        if (queue.remove(value)) {
            queue.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMapFull() {
        CachedValue<K, V> removedValue;
        int startIndex = -1;
        do {
            int queueIndex;
            if ((queueIndex = (int)Math.abs(this.index.incrementAndGet() % (long)this.queues.size())) == startIndex) {
                return;
            }
            if (startIndex == -1) {
                startIndex = queueIndex;
            }
            Collection<CachedValue<K, V>> queue = this.queues.get(queueIndex);
            removedValue = null;
            Lock lock = this.queueLocks.get(queue);
            lock.lock();
            try {
                Iterator<CachedValue<K, V>> iter = queue.iterator();
                if (!iter.hasNext()) continue;
                removedValue = iter.next();
                iter.remove();
            }
            finally {
                lock.unlock();
            }
        } while (removedValue == null);
        this.map.remove(removedValue.getKey(), removedValue);
    }

    @Override
    public void clear() {
        for (Collection<CachedValue<K, V>> collection : this.queues) {
            collection.clear();
        }
        super.clear();
    }
}

