/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.redisson.RedissonPatternTopic;
import org.redisson.api.DeletedObjectListener;
import org.redisson.api.ExpiredObjectListener;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.ServiceManager;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.Hash;
import org.redisson.pubsub.PublishSubscribeService;

public abstract class RedissonObject
implements RObject {
    protected final CommandAsyncExecutor commandExecutor;
    protected String name;
    protected final Codec codec;

    public RedissonObject(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        this.setName(name);
    }

    public RedissonObject(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor, name);
    }

    public static String prefixName(String prefix, String name) {
        if (name.contains("{")) {
            return prefix + ":" + name;
        }
        return prefix + ":{" + name + "}";
    }

    public ServiceManager getServiceManager() {
        return this.commandExecutor.getServiceManager();
    }

    public static String suffixName(String name, String suffix) {
        if (name.contains("{")) {
            return name + ":" + suffix;
        }
        return "{" + name + "}:" + suffix;
    }

    protected final <T> Stream<T> toStream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false);
    }

    protected final <V> V get(RFuture<V> future) {
        return this.commandExecutor.get(future);
    }

    protected final long toSeconds(long timeout, TimeUnit unit) {
        long seconds = unit.toSeconds(timeout);
        if (timeout != 0L && seconds == 0L) {
            seconds = 1L;
        }
        return seconds;
    }

    @Override
    public String getName() {
        return this.commandExecutor.getServiceManager().getConfig().getNameMapper().unmap(this.name);
    }

    public final String getRawName() {
        return this.name;
    }

    protected String getRawName(Object o) {
        return this.getRawName();
    }

    protected final void setName(String name) {
        this.name = this.commandExecutor.getServiceManager().getConfig().getNameMapper().map(name);
    }

    @Override
    public void rename(String newName) {
        this.get(this.renameAsync(newName));
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MEMORY_USAGE, this.getRawName());
    }

    public final RFuture<Long> sizeInMemoryAsync(List<Object> keys) {
        return this.sizeInMemoryAsync(this.commandExecutor, keys);
    }

    public final RFuture<Long> sizeInMemoryAsync(CommandAsyncExecutor commandExecutor, List<Object> keys) {
        return commandExecutor.evalWriteAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG, "local total = 0;for j = 1, #KEYS, 1 do local size = redis.call('memory', 'usage', KEYS[j]); if size ~= false then total = total + size;end; end; return total; ", keys, new Object[0]);
    }

    @Override
    public long sizeInMemory() {
        return this.get(this.sizeInMemoryAsync());
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RENAME, this.getRawName(), newName);
        CompletionStage<Void> f = future.thenAccept(r -> this.setName(newName));
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void migrate(String host, int port, int database, long timeout) {
        this.get(this.migrateAsync(host, port, database, timeout));
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MIGRATE, host, port, this.getRawName(), database, timeout);
    }

    @Override
    public void copy(String host, int port, int database, long timeout) {
        this.get(this.copyAsync(host, port, database, timeout));
    }

    @Override
    public RFuture<Void> copyAsync(String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MIGRATE, host, port, this.getRawName(), database, timeout, "COPY");
    }

    @Override
    public boolean move(int database) {
        return this.get(this.moveAsync(database));
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.MOVE, this.getRawName(), database);
    }

    @Override
    public boolean renamenx(String newName) {
        return this.get(this.renamenxAsync(newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RENAMENX, this.getRawName(), newName);
        CompletionStage<Boolean> f = future.thenApply(value -> {
            if (value.booleanValue()) {
                this.setName(newName);
            }
            return value;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public boolean delete() {
        return this.get(this.deleteAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.DEL_BOOL, this.getRawName());
    }

    protected RFuture<Boolean> deleteAsync(String ... keys) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.DEL_OBJECTS, (Object[])keys);
    }

    @Override
    public boolean unlink() {
        return this.get(this.unlinkAsync());
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.UNLINK_BOOL, this.getRawName());
    }

    @Override
    public boolean touch() {
        return this.get(this.touchAsync());
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.TOUCH, this.getRawName());
    }

    @Override
    public boolean isExists() {
        return this.get(this.isExistsAsync());
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EXISTS, this.getRawName());
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected List<ByteBuf> encode(Collection<?> values) {
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>(values.size());
        for (Object object : values) {
            this.encode(result, object);
        }
        return result;
    }

    public void encode(Collection<Object> params, Collection<?> values) {
        try {
            for (Object object : values) {
                params.add(this.encode(object));
            }
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockByMapKey(Object key, String suffix) {
        ByteBuf keyState = this.encodeMapKey(key);
        try {
            String string = RedissonObject.suffixName(this.getRawName(key), Hash.hash128toBase64(keyState) + ":" + suffix);
            return string;
        }
        finally {
            keyState.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockByValue(Object key, String suffix) {
        ByteBuf keyState = this.encode(key);
        try {
            String string = RedissonObject.suffixName(this.getRawName(key), Hash.hash128toBase64(keyState) + ":" + suffix);
            return string;
        }
        finally {
            keyState.release();
        }
    }

    protected void encodeMapKeys(Collection<Object> params, Collection<?> values) {
        try {
            for (Object object : values) {
                params.add(this.encodeMapKey(object));
            }
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    protected void encodeMapValues(Collection<Object> params, Collection<?> values) {
        try {
            for (Object object : values) {
                params.add(this.encodeMapValue(object));
            }
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    public ByteBuf encode(Object value) {
        return this.commandExecutor.encode(this.codec, value);
    }

    public void encode(Collection<?> params, Object value) {
        try {
            ByteBuf v2 = this.encode(value);
            params.add(v2);
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    public ByteBuf encodeMapKey(Object value) {
        return this.commandExecutor.encodeMapKey(this.codec, value);
    }

    public ByteBuf encodeMapKey(Object value, Collection<Object> params) {
        try {
            return this.encodeMapKey(value);
        }
        catch (Exception e) {
            params.forEach(v -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    public ByteBuf encodeMapValue(Object value) {
        return this.commandExecutor.encodeMapValue(this.codec, value);
    }

    @Override
    public byte[] dump() {
        return this.get(this.dumpAsync());
    }

    @Override
    public RFuture<byte[]> dumpAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.DUMP, this.getRawName());
    }

    @Override
    public void restore(byte[] state) {
        this.get(this.restoreAsync(state));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] state) {
        return this.restoreAsync(state, 0L, null);
    }

    @Override
    public void restore(byte[] state, long timeToLive, TimeUnit timeUnit) {
        this.get(this.restoreAsync(state, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        long ttl = 0L;
        if (timeToLive > 0L) {
            ttl = timeUnit.toMillis(timeToLive);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, this.getRawName(), ttl, state);
    }

    @Override
    public void restoreAndReplace(byte[] state, long timeToLive, TimeUnit timeUnit) {
        this.get(this.restoreAndReplaceAsync(state, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        long ttl = 0L;
        if (timeToLive > 0L) {
            ttl = timeUnit.toMillis(timeToLive);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, this.getRawName(), ttl, state, "REPLACE");
    }

    @Override
    public void restoreAndReplace(byte[] state) {
        this.get(this.restoreAndReplaceAsync(state));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] state) {
        return this.restoreAndReplaceAsync(state, 0L, null);
    }

    @Override
    public Long getIdleTime() {
        return this.get(this.getIdleTimeAsync());
    }

    @Override
    public RFuture<Long> getIdleTimeAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.OBJECT_IDLETIME, this.getRawName());
    }

    protected final <T extends ObjectListener> int addListener(String name, T listener, BiConsumer<T, String> consumer) {
        RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
        return topic.addListener(String.class, (pattern, channel, msg) -> {
            if (msg.equals(this.getRawName())) {
                consumer.accept(listener, (String)msg);
            }
        });
    }

    protected final <T extends ObjectListener> RFuture<Integer> addListenerAsync(String name, T listener, BiConsumer<T, String> consumer) {
        RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
        return topic.addListenerAsync(String.class, (pattern, channel, msg) -> {
            if (msg.equals(this.getRawName())) {
                consumer.accept(listener, (String)msg);
            }
        });
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof ExpiredObjectListener) {
            return this.addListener("__keyevent@*:expired", (ExpiredObjectListener)listener, ExpiredObjectListener::onExpired);
        }
        if (listener instanceof DeletedObjectListener) {
            return this.addListener("__keyevent@*:del", (DeletedObjectListener)listener, DeletedObjectListener::onDeleted);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof ExpiredObjectListener) {
            return this.addListenerAsync("__keyevent@*:expired", (ExpiredObjectListener)listener, ExpiredObjectListener::onExpired);
        }
        if (listener instanceof DeletedObjectListener) {
            return this.addListenerAsync("__keyevent@*:del", (DeletedObjectListener)listener, DeletedObjectListener::onDeleted);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void removeListener(int listenerId) {
        RedissonPatternTopic expiredTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
        expiredTopic.removeListener(listenerId);
        RedissonPatternTopic deletedTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:del");
        deletedTopic.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RedissonPatternTopic expiredTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
        RFuture<Void> f1 = expiredTopic.removeListenerAsync(listenerId);
        RedissonPatternTopic deletedTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:del");
        RFuture<Void> f2 = deletedTopic.removeListenerAsync(listenerId);
        CompletableFuture<Void> f = CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture());
        return new CompletableFutureWrapper<Void>(f);
    }

    protected final List<String> map(String[] keys) {
        return Arrays.stream(keys).map(k -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)k)).collect(Collectors.toList());
    }

    protected PublishSubscribeService getSubscribeService() {
        return this.commandExecutor.getConnectionManager().getSubscribeService();
    }
}

