/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonSet;
import org.redisson.ScanResult;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSet;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.iterator.RedissonBaseIterator;

public class RedissonSetMultimapValues<V>
extends RedissonExpirable
implements RSet<V> {
    private static final RedisCommand<ListScanResult<Object>> EVAL_SSCAN = new RedisCommand<Object>("EVAL", new ListMultiDecoder2(new ListScanResultReplayDecoder(), new MapValueDecoder(new ObjectListReplayDecoder())));
    private final RSet<V> set;
    private final Object key;
    private final String timeoutSetName;

    public RedissonSetMultimapValues(Codec codec, CommandAsyncExecutor commandExecutor, String name, String timeoutSetName, Object key) {
        super(codec, commandExecutor, name);
        this.timeoutSetName = timeoutSetName;
        this.key = key;
        this.set = new RedissonSet(codec, commandExecutor, name, null);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return null;
    }

    @Override
    public boolean tryAdd(V ... values) {
        return this.get(this.tryAddAsync(values));
    }

    @Override
    public List<V> containsEach(Collection<V> c) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Boolean> tryAddAsync(V ... values) {
        return this.set.tryAddAsync(values);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local res = redis.call('zrem', KEYS[1], ARGV[2]); if res > 0 then redis.call('del', KEYS[2]); end; return res; ", Arrays.asList(this.timeoutSetName, this.getRawName()), System.currentTimeMillis(), this.encodeMapKey(this.key));
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.timeoutSetName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('scard', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getRawName()), System.currentTimeMillis(), this.encodeMapKey(this.key));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('sismember', KEYS[2], ARGV[3]);", Arrays.asList(this.timeoutSetName, this.getRawName()), System.currentTimeMillis(), this.encodeMapKey(this.key), this.encodeMapValue(o));
    }

    private ListScanResult<Object> scanIterator(RedisClient client, long startPos, String pattern, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(System.currentTimeMillis());
        params.add(startPos);
        params.add(this.encodeMapKey(this.key));
        if (pattern != null) {
            params.add(pattern);
        }
        params.add(count);
        RFuture f = this.commandExecutor.evalReadAsync(client, this.getRawName(), this.codec, EVAL_SSCAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {0, {}};end;local res; if (#ARGV == 5) then res = redis.call('sscan', KEYS[2], ARGV[2], 'match', ARGV[4], 'count', ARGV[5]); else res = redis.call('sscan', KEYS[2], ARGV[2], 'count', ARGV[4]); end;return res;", Arrays.asList(this.timeoutSetName, this.getRawName()), params.toArray());
        return (ListScanResult)this.get(f);
    }

    @Override
    public Iterator<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Iterator<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Iterator<V> distributedIterator(String pattern) {
        String iteratorName = "__redisson_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, pattern, 10);
    }

    @Override
    public Iterator<V> distributedIterator(int count) {
        String iteratorName = "__redisson_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, null, count);
    }

    @Override
    public Iterator<V> distributedIterator(final String iteratorName, final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonSetMultimapValues.this.distributedScanIterator(iteratorName, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSetMultimapValues.this.remove(value);
            }
        };
    }

    private ScanResult<Object> distributedScanIterator(String iteratorName, String pattern, int count) {
        return this.get(this.distributedScanIteratorAsync(iteratorName, pattern, count));
    }

    private RFuture<ScanResult<Object>> distributedScanIteratorAsync(String iteratorName, String pattern, int count) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(System.currentTimeMillis());
        if (pattern != null) {
            args.add(pattern);
        }
        args.add(count);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SCAN, "local cursor = redis.call('get', KEYS[3]); if cursor ~= false then cursor = tonumber(cursor); else cursor = 0;end;if cursor == -1 then return {0, {}}; end;local result; if (#ARGV == 3) then result = redis.call('sscan', KEYS[2], cursor, 'match', ARGV[2], 'count', ARGV[3]); elseresult = redis.call('sscan', KEYS[2], cursor, 'count', ARGV[2]); end;local next_cursor = result[1]if next_cursor ~= \"0\" then redis.call('setex', KEYS[3], 3600, next_cursor);else redis.call('setex', KEYS[3], 3600, -1);end; local expireDate = 92233720368547758; local expirations = redis.call('zmscore', KEYS[1], result[2])for i = #expirations, 1, -1 do if expirations[i] ~= false then local expireDate = tonumber(expireDateScore) if expireDate <= tonumber(ARGV[1]) then table.remove(result[2], i);end; end; end; return result;", Arrays.asList(this.timeoutSetName, this.getRawName(), iteratorName), args.toArray());
    }

    @Override
    public Iterator<V> iterator(final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ListScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonSetMultimapValues.this.scanIterator(client, nextIterPos, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonSetMultimapValues.this.remove(value);
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_VALUE_SET, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {};end; return redis.call('smembers', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getRawName()), System.currentTimeMillis(), this.encodeMapKey(this.key));
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.set.add(e);
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.set.addAsync(e);
    }

    @Override
    public V removeRandom() {
        return this.set.removeRandom();
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SPOP_SINGLE, this.getRawName());
    }

    @Override
    public Set<V> removeRandom(int amount) {
        return this.get(this.removeRandomAsync(amount));
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SPOP, this.getRawName(), amount);
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public RFuture<V> randomAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SRANDMEMBER_SINGLE, this.getRawName());
    }

    @Override
    public Set<V> random(int count) {
        return this.get(this.randomAsync(count));
    }

    @Override
    public RFuture<Set<V>> randomAsync(int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SRANDMEMBER, this.getRawName(), count);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('srem', KEYS[2], ARGV[3]) > 0 and 1 or 0;", Arrays.asList(this.timeoutSetName, this.getRawName()), System.currentTimeMillis(), this.encodeMapKey(this.key), this.encodeMapValue(o));
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SMOVE, this.getRawName(), destination, this.encode(member));
    }

    @Override
    public boolean move(String destination, V member) {
        return this.get(this.moveAsync(destination, member));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        args.add(System.currentTimeMillis());
        args.add(this.encodeMapKey(this.key));
        this.encodeMapValues(args, c);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local s = redis.call('smembers', KEYS[2]);for i = 1, #s, 1 do for j = 2, #ARGV, 1 do if ARGV[j] == s[i] then table.remove(ARGV, j) end end; end;return #ARGV == 2 and 1 or 0; ", Arrays.asList(this.timeoutSetName, this.getRawName()), args.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return false;
        }
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encodeMapValues(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SADD_BOOL, args.toArray());
    }

    @Override
    public RFuture<Integer> addAllCountedAsync(Collection<? extends V> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getRawName());
        this.encodeMapValues(args, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SADD, args.toArray());
    }

    @Override
    public int addAllCounted(Collection<? extends V> c) {
        return this.get(this.addAllCountedAsync(c));
    }

    @Override
    public int removeAllCounted(Collection<? extends V> c) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<Integer> removeAllCountedAsync(Collection<? extends V> c) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public RFuture<List<V>> containsEachAsync(Collection<V> c) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        args.add(System.currentTimeMillis());
        args.add(this.encodeMapKey(this.key));
        this.encodeMapValues(args, c);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local changed = 0 local s = redis.call('smembers', KEYS[2]) local i = 1 while i <= #s do local element = s[i] local isInAgrs = false for j = 2, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('SREM', KEYS[2], element) changed = 1 end i = i + 1 end return changed ", Arrays.asList(this.timeoutSetName, this.getRawName()), args.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        args.add(System.currentTimeMillis());
        args.add(this.encodeMapKey(this.key));
        this.encodeMapValues(args, c);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local v = 0 for i = 2, #ARGV, 1 do if redis.call('srem', KEYS[2], ARGV[i]) == 1 then v = 1 end end return v ", Arrays.asList(this.timeoutSetName, this.getRawName()), args.toArray());
    }

    @Override
    public RCountDownLatch getCountDownLatch(V value) {
        return this.set.getCountDownLatch(value);
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        return this.set.getPermitExpirableSemaphore(value);
    }

    @Override
    public RSemaphore getSemaphore(V value) {
        return this.set.getSemaphore(value);
    }

    @Override
    public RLock getFairLock(V value) {
        return this.set.getFairLock(value);
    }

    @Override
    public RReadWriteLock getReadWriteLock(V value) {
        return this.set.getReadWriteLock(value);
    }

    @Override
    public RLock getLock(V value) {
        return this.set.getLock(value);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SUNION, args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SDIFFSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SDIFF, args.toArray());
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SINTERSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SINTER, args.toArray());
    }

    @Override
    public Integer countIntersection(String ... names) {
        return this.get(this.countIntersectionAsync(names));
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(String ... names) {
        return this.countIntersectionAsync(0, names);
    }

    @Override
    public Integer countIntersection(int limit, String ... names) {
        return this.get(this.countIntersectionAsync(limit, names));
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(int limit, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 1);
        args.add(names.length + 1);
        args.add(this.getRawName());
        args.addAll(this.map(names));
        if (limit > 0) {
            args.add("LIMIT");
            args.add(limit);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SINTERCARD_INT, args.toArray());
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.set.readSortAsync(order);
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return (Set)this.set.readSort(order);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.set.readSortAsync(order, offset, count);
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return (Set)this.set.readSort(order, offset, count);
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return (Set)this.set.readSort(byPattern, order);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.set.readSortAsync(byPattern, order);
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return (Set)this.set.readSort(byPattern, order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.set.readSortAsync(byPattern, order, offset, count);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.readSort(byPattern, getPatterns, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.readSortAsync(byPattern, getPatterns, order);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.readSort(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.readSortAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order) {
        return (Set)this.set.readSortAlpha(order);
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        return (Set)this.set.readSortAlpha(order, offset, count);
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        return (Set)this.set.readSortAlpha(byPattern, order);
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return (Set)this.set.readSortAlpha(byPattern, order, offset, count);
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.readSortAlpha(byPattern, getPatterns, order);
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.readSortAlpha(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        return this.set.readSortAlphaAsync(order);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.set.readSortAlphaAsync(order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.set.readSortAlphaAsync(byPattern, order);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.set.readSortAlphaAsync(byPattern, order, offset, count);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.readSortAlphaAsync(byPattern, getPatterns, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.readSortAlphaAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.set.sortTo(destName, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.set.sortToAsync(destName, order);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.set.sortTo(destName, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.set.sortToAsync(destName, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.set.sortTo(destName, byPattern, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.set.sortToAsync(destName, byPattern, order);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.set.sortTo(destName, byPattern, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.set.sortToAsync(destName, byPattern, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.sortTo(destName, byPattern, getPatterns, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.sortToAsync(destName, byPattern, getPatterns, order);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.sortTo(destName, byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.sortToAsync(destName, byPattern, getPatterns, order, offset, count);
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public Stream<V> stream(String pattern, int count) {
        return this.toStream(this.iterator(pattern, count));
    }

    @Override
    public Stream<V> stream(String pattern) {
        return this.toStream(this.iterator(pattern));
    }
}

