/*
 * Decompiled with CFR 0.152.
 */
package jodd.buffer;

import java.util.Arrays;

public class FastLongBuffer {
    private long[] buffer;
    private int offset;

    public FastLongBuffer() {
        this.buffer = new long[64];
    }

    public FastLongBuffer(int size) {
        this.buffer = new long[size];
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity + 512;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public void append(long element) {
        if (this.offset - this.buffer.length >= 0) {
            this.grow(this.offset);
        }
        this.buffer[this.offset++] = element;
    }

    public FastLongBuffer append(long[] array, int off, int len) {
        if (this.offset + len - this.buffer.length > 0) {
            this.grow(this.offset + len);
        }
        System.arraycopy(array, off, this.buffer, this.offset, len);
        this.offset += len;
        return this;
    }

    public FastLongBuffer append(long[] array) {
        return this.append(array, 0, array.length);
    }

    public FastLongBuffer append(FastLongBuffer buff) {
        if (buff.offset == 0) {
            return this;
        }
        this.append(buff.buffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void clear() {
        this.offset = 0;
    }

    public long[] toArray() {
        return Arrays.copyOf(this.buffer, this.offset);
    }

    public long[] toArray(int start, int len) {
        long[] array = new long[len];
        if (len == 0) {
            return array;
        }
        System.arraycopy(this.buffer, start, array, 0, len);
        return array;
    }

    public long get(int index) {
        if (index >= this.offset) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }
}

