/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.index;

import org.redisson.api.search.index.SortMode;
import org.redisson.api.search.index.TagIndex;

public final class TagIndexParams
implements TagIndex {
    private final String fieldName;
    private String as;
    private SortMode sortMode;
    private boolean noIndex;
    private boolean caseSensitive;
    private boolean withSuffixTrie;
    private String separator;

    protected TagIndexParams(String name) {
        this.fieldName = name;
    }

    @Override
    public TagIndexParams as(String as) {
        this.as = as;
        return this;
    }

    @Override
    public TagIndexParams separator(String separator) {
        if (separator.length() != 1) {
            throw new IllegalArgumentException("Separator should be a single character");
        }
        this.separator = separator;
        return this;
    }

    @Override
    public TagIndexParams sortMode(SortMode sortMode) {
        this.sortMode = sortMode;
        return this;
    }

    @Override
    public TagIndexParams caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    @Override
    public TagIndexParams noIndex() {
        this.noIndex = true;
        return this;
    }

    @Override
    public TagIndexParams withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAs() {
        return this.as;
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public boolean isWithSuffixTrie() {
        return this.withSuffixTrie;
    }

    public String getSeparator() {
        return this.separator;
    }
}

