/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.redisson.SlotCallback;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.BucketsDecoder;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBuckets
implements RBuckets {
    protected final Codec codec;
    protected final CommandAsyncExecutor commandExecutor;

    public RedissonBuckets(CommandAsyncExecutor commandExecutor) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor);
    }

    public RedissonBuckets(Codec codec, CommandAsyncExecutor commandExecutor) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public boolean trySet(Map<String, ?> buckets) {
        RFuture<Boolean> future = this.trySetAsync(buckets);
        return this.commandExecutor.get(future);
    }

    @Override
    public void set(Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(buckets));
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Map<String, V>>(Collections.emptyMap());
        }
        List<Object> keysList = Arrays.stream(keys).map((? super T k) -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)k)).collect(Collectors.toList());
        CompositeCodec commandCodec = new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("MGET", new MapGetAllDecoder(keysList, 0));
        return this.commandExecutor.readBatchedAsync(commandCodec, command, new SlotCallback<Map<Object, Object>, Map<String, V>>(){
            final Map<String, V> results = new ConcurrentHashMap();

            @Override
            public void onSlotResult(Map<Object, Object> result) {
                for (Map.Entry<Object, Object> entry : result.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    String key = RedissonBuckets.this.commandExecutor.getServiceManager().getConfig().getNameMapper().unmap((String)entry.getKey());
                    this.results.put(key, entry.getValue());
                }
            }

            @Override
            public Map<String, V> onFinish() {
                return this.results;
            }

            @Override
            public RedisCommand<Map<Object, Object>> createCommand(List<String> keys) {
                return new RedisCommand<Map<Object, Object>>("MGET", new BucketsDecoder(keys));
            }
        }, keysList.toArray(new String[0]));
    }

    @Override
    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        final Map<String, ?> mappedBuckets = this.map(buckets);
        return this.commandExecutor.writeBatchedAsync(this.codec, RedisCommands.MSETNX, new SlotCallback<Boolean, Boolean>(){
            final AtomicBoolean result = new AtomicBoolean(true);

            @Override
            public void onSlotResult(Boolean result) {
                if (!result.booleanValue() && this.result.get()) {
                    this.result.set(result);
                }
            }

            @Override
            public Boolean onFinish() {
                return this.result.get();
            }

            @Override
            public Object[] createParams(List<String> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (String key : keys) {
                    params.add(key);
                    try {
                        params.add(RedissonBuckets.this.codec.getValueEncoder().encode(mappedBuckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, mappedBuckets.keySet().toArray(new String[0]));
    }

    private Map<String, ?> map(Map<String, ?> buckets) {
        return buckets.entrySet().stream().collect(Collectors.toMap(e -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)e.getKey()), e -> e.getValue()));
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        final Map<String, ?> mappedBuckets = this.map(buckets);
        return this.commandExecutor.writeBatchedAsync(this.codec, RedisCommands.MSET, new SlotCallback<Void, Void>(){

            @Override
            public void onSlotResult(Void result) {
            }

            @Override
            public Void onFinish() {
                return null;
            }

            @Override
            public Object[] createParams(List<String> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (String key : keys) {
                    params.add(key);
                    try {
                        params.add(RedissonBuckets.this.codec.getValueEncoder().encode(mappedBuckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, mappedBuckets.keySet().toArray(new String[0]));
    }
}

