/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.CommandsQueuePubSub;
import org.redisson.client.handler.PubSubEntry;
import org.redisson.client.handler.PubSubKey;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListObjectDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.Message;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.misc.LogHelper;

public class CommandPubSubDecoder
extends CommandDecoder {
    private static final Set<String> UNSUBSCRIBE_COMMANDS = new HashSet<String>(Arrays.asList(RedisCommands.PUNSUBSCRIBE.getName(), RedisCommands.UNSUBSCRIBE.getName(), RedisCommands.SUNSUBSCRIBE.getName()));
    private static final Set<String> SUBSCRIBE_COMMANDS = new HashSet<String>(Arrays.asList(RedisCommands.PSUBSCRIBE.getName(), RedisCommands.SUBSCRIBE.getName(), RedisCommands.SSUBSCRIBE.getName()));
    private static final Set<String> MESSAGES = new HashSet<String>(Arrays.asList("subscribe", "psubscribe", "punsubscribe", "unsubscribe", "ssubscribe", "sunsubscribe"));
    private static final Set<String> TYPE_MESSAGES = new HashSet<String>(Arrays.asList("message", "smessage", "pmessage"));
    private final Map<ChannelName, PubSubEntry> entries = new HashMap<ChannelName, PubSubEntry>();
    private final Map<PubSubKey, CommandData<Object, Object>> commands = new ConcurrentHashMap<PubSubKey, CommandData<Object, Object>>();
    private final RedisClientConfig config;

    public CommandPubSubDecoder(RedisClientConfig config) {
        super(config.getAddress().getScheme());
        this.config = config;
    }

    public void addPubSubCommand(ChannelName channel, CommandData<Object, Object> data) {
        String operation = data.getCommand().getName().toLowerCase();
        this.commands.put(new PubSubKey(channel, operation), data);
    }

    @Override
    protected QueueCommandHolder getCommand(ChannelHandlerContext ctx) {
        return ctx.channel().attr(CommandsQueuePubSub.CURRENT_COMMAND).get();
    }

    @Override
    protected void sendNext(Channel channel) {
        CommandsQueuePubSub handler = channel.pipeline().get(CommandsQueuePubSub.class);
        if (handler != null) {
            handler.sendNextCommand(channel);
        }
        this.state(null);
    }

    @Override
    protected void decodeCommand(Channel channel, ByteBuf in, QueueCommand data, int endIndex) throws Exception {
        if (data == null) {
            try {
                while (in.writerIndex() > in.readerIndex()) {
                    this.decode(in, null, null, channel, false, null);
                }
                this.sendNext(channel);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: {}, reply: {}", channel, LogHelper.toString(in), e);
                this.sendNext(channel);
                throw e;
            }
        }
        if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                while (in.writerIndex() > in.readerIndex()) {
                    this.decode(in, cmd, null, channel, false, null);
                }
                this.sendNext(channel, data);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: {}, reply: {}", channel, LogHelper.toString(in), e);
                cmd.tryFailure(e);
                this.sendNext(channel);
                throw e;
            }
        }
    }

    @Override
    protected void onError(Channel channel, String error) {
        if (error.contains("unknown command") && error.contains("SSUBSCRIBE")) {
            this.commands.keySet().stream().filter(v -> v.getOperation().equalsIgnoreCase(RedisCommands.SSUBSCRIBE.getName())).forEach(v -> {
                CommandData<Object, Object> dd = this.commands.get(v);
                dd.getPromise().completeExceptionally(new RedisException(error));
            });
        } else {
            super.onError(channel, error);
        }
    }

    @Override
    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, final Object result) throws IOException {
        try {
            if (this.config.getExecutor().isShutdown()) {
                return;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (result instanceof Message) {
            this.checkpoint();
            final RedisPubSubConnection pubSubConnection = (RedisPubSubConnection)RedisPubSubConnection.getFrom(channel);
            ChannelName channelName = ((Message)result).getChannel();
            if (result instanceof PubSubStatusMessage) {
                String operation = ((PubSubStatusMessage)result).getType().name().toLowerCase();
                PubSubKey key = new PubSubKey(channelName, operation);
                CommandData<Object, Object> d = this.commands.get(key);
                if (SUBSCRIBE_COMMANDS.contains(d.getCommand().getName())) {
                    this.commands.remove(key);
                    this.entries.put(channelName, new PubSubEntry(d.getMessageDecoder()));
                }
                if (UNSUBSCRIBE_COMMANDS.contains(d.getCommand().getName())) {
                    this.commands.remove(key);
                    if (result instanceof PubSubPatternMessage) {
                        channelName = ((PubSubPatternMessage)result).getPattern();
                    }
                    PubSubEntry entry = this.entries.remove(channelName);
                    if (this.config.isKeepAlive()) {
                        this.enqueueMessage(result, pubSubConnection, entry);
                    }
                }
            }
            if (this.config.isKeepAlive()) {
                PubSubEntry entry;
                if (result instanceof PubSubPatternMessage) {
                    channelName = ((PubSubPatternMessage)result).getPattern();
                }
                if ((entry = this.entries.get(channelName)) != null) {
                    this.enqueueMessage(result, pubSubConnection, entry);
                }
            } else {
                this.config.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (result instanceof PubSubStatusMessage) {
                            pubSubConnection.onMessage((PubSubStatusMessage)result);
                        } else if (result instanceof PubSubMessage) {
                            pubSubConnection.onMessage((PubSubMessage)result);
                        } else if (result instanceof PubSubPatternMessage) {
                            pubSubConnection.onMessage((PubSubPatternMessage)result);
                        }
                    }
                });
            }
        } else if (data != null && data.getCommand().getName().equals("PING")) {
            super.decodeResult(data, parts, channel, result);
        }
    }

    private void enqueueMessage(Object res, RedisPubSubConnection pubSubConnection, PubSubEntry entry) {
        if (res != null) {
            entry.getQueue().add((Message)res);
        }
        if (!entry.getSent().compareAndSet(false, true)) {
            return;
        }
        this.config.getExecutor().execute(() -> {
            try {
                Message result;
                while ((result = entry.getQueue().poll()) != null) {
                    if (result instanceof PubSubStatusMessage) {
                        pubSubConnection.onMessage((PubSubStatusMessage)result);
                        continue;
                    }
                    if (result instanceof PubSubMessage) {
                        pubSubConnection.onMessage((PubSubMessage)result);
                        continue;
                    }
                    if (!(result instanceof PubSubPatternMessage)) continue;
                    pubSubConnection.onMessage((PubSubPatternMessage)result);
                }
            }
            finally {
                entry.getSent().set(false);
                if (!entry.getQueue().isEmpty()) {
                    this.enqueueMessage(null, pubSubConnection, entry);
                }
            }
        });
    }

    @Override
    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (parts.isEmpty() || parts.get(0) == null) {
            return null;
        }
        String command = parts.get(0).toString();
        if (MESSAGES.contains(command)) {
            ChannelName channelName = new ChannelName((byte[])parts.get(1));
            PubSubKey key = new PubSubKey(channelName, command);
            CommandData<Object, Object> commandData = this.commands.get(key);
            if (commandData == null) {
                return null;
            }
            return commandData.getCommand().getReplayMultiDecoder();
        }
        if (TYPE_MESSAGES.contains(command)) {
            byte[] channelName = (byte[])parts.get(1);
            PubSubEntry entry = this.entries.get(new ChannelName(channelName));
            if (entry == null) {
                return null;
            }
            return entry.getDecoder();
        }
        if ("pong".equals(command)) {
            return new ListObjectDecoder<Object>(0);
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    @Override
    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (parts != null) {
            if (data != null && parts.size() == 1 && "pong".equals(parts.get(0))) {
                return data.getCodec().getValueDecoder();
            }
            if (parts.size() == 1) {
                return ByteArrayCodec.INSTANCE.getValueDecoder();
            }
            if (parts.size() == 2 && "pmessage".equals(parts.get(0))) {
                return ByteArrayCodec.INSTANCE.getValueDecoder();
            }
            if (parts.size() == 2 && TYPE_MESSAGES.contains(parts.get(0).toString())) {
                byte[] channelName = (byte[])parts.get(1);
                return this.getDecoder(null, parts, channelName);
            }
            if (parts.size() == 3 && "pmessage".equals(parts.get(0))) {
                byte[] patternName = (byte[])parts.get(1);
                return this.getDecoder(null, parts, patternName);
            }
        }
        if (data != null && data.getCommand().getName().equals(RedisCommands.PING.getName())) {
            return StringCodec.INSTANCE.getValueDecoder();
        }
        return super.selectDecoder(data, parts);
    }

    private Decoder<Object> getDecoder(Codec codec, List<Object> parts, byte[] name) {
        PubSubEntry entry = this.entries.get(new ChannelName(name));
        if (entry != null) {
            return entry.getDecoder().getDecoder(codec, parts.size(), (State)this.state());
        }
        return ByteArrayCodec.INSTANCE.getValueDecoder();
    }
}

