/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.InetSocketAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Callable;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.misc.AsyncSemaphore;

public class SequentialDnsAddressResolverFactory
implements AddressResolverGroupFactory {
    private final AsyncSemaphore asyncSemaphore;

    public SequentialDnsAddressResolverFactory() {
        this(6);
    }

    public SequentialDnsAddressResolverFactory(int concurrencyLevel) {
        this.asyncSemaphore = new AsyncSemaphore(concurrencyLevel);
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> create(Class<? extends DatagramChannel> channelType, DnsServerAddressStreamProvider nameServerProvider) {
        DnsAddressResolverGroup group = new DnsAddressResolverGroup(channelType, nameServerProvider){

            @Override
            protected AddressResolver<InetSocketAddress> newAddressResolver(EventLoop eventLoop, NameResolver<InetAddress> resolver) throws Exception {
                return new LimitedInetSocketAddressResolver(SequentialDnsAddressResolverFactory.this.asyncSemaphore, eventLoop, resolver);
            }
        };
        return group;
    }

    static class LimitedInetSocketAddressResolver
    extends InetSocketAddressResolver {
        final AsyncSemaphore semaphore;

        LimitedInetSocketAddressResolver(AsyncSemaphore semaphore, EventExecutor executor, NameResolver<InetAddress> nameResolver) {
            super(executor, nameResolver);
            this.semaphore = semaphore;
        }

        @Override
        protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
            this.execute(() -> {
                super.doResolve(unresolvedAddress, promise);
                return null;
            }, promise);
        }

        @Override
        protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
            this.execute(() -> {
                super.doResolveAll(unresolvedAddress, promise);
                return null;
            }, promise);
        }

        private void execute(Callable<?> callable, Promise<?> promise) {
            this.semaphore.acquire().thenAccept(s -> {
                promise.addListener(r -> this.semaphore.release());
                try {
                    callable.call();
                }
                catch (Exception e) {
                    promise.setFailure(e);
                }
            });
        }
    }
}

