/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.client.RedisException;
import org.redisson.client.RedisRedirectException;
import org.redisson.client.RedisRetryException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;

public class BatchCommandData<T, R>
extends CommandData<T, R>
implements Comparable<BatchCommandData<T, R>> {
    private final int index;
    private final AtomicReference<RedisException> retryError = new AtomicReference();

    public BatchCommandData(RedisCommand<T> command, Object[] params, int index) {
        this(new CompletableFuture(), StringCodec.INSTANCE, command, params, index);
    }

    public BatchCommandData(CompletableFuture<R> promise, Codec codec, RedisCommand<T> command, Object[] params, int index) {
        super(promise, codec, command, params);
        this.index = index;
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.retryError.get() != null) {
            return false;
        }
        if (cause instanceof RedisRedirectException || cause instanceof RedisRetryException) {
            return this.retryError.compareAndSet(null, (RedisException)cause);
        }
        return super.tryFailure(cause);
    }

    @Override
    public boolean isSuccess() {
        return this.retryError.get() == null && super.isSuccess();
    }

    @Override
    public Throwable cause() {
        if (this.retryError.get() != null) {
            return this.retryError.get();
        }
        return super.cause();
    }

    public void clearError() {
        this.retryError.set(null);
    }

    @Override
    public int compareTo(BatchCommandData<T, R> o) {
        return this.index - o.index;
    }

    public void updateCommand(RedisCommand command) {
        this.command = command;
    }
}

