/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.function.Supplier;
import org.redisson.RedissonExpirable;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedissonBaseLock
extends RedissonExpirable
implements RLock {
    private static final Logger log = LoggerFactory.getLogger(RedissonBaseLock.class);
    private static final ConcurrentMap<String, ExpirationEntry> EXPIRATION_RENEWAL_MAP = new ConcurrentHashMap<String, ExpirationEntry>();
    protected long internalLockLeaseTime;
    final String id;
    final String entryName;
    final CommandAsyncExecutor commandExecutor;
    private static final RedisCommand<Integer> HGET = new RedisCommand<Integer>("HGET", new MapValueDecoder(), new IntegerReplayConvertor(0));

    public RedissonBaseLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.id = commandExecutor.getServiceManager().getId();
        this.internalLockLeaseTime = commandExecutor.getServiceManager().getCfg().getLockWatchdogTimeout();
        this.entryName = this.id + ":" + name;
    }

    protected String getEntryName() {
        return this.entryName;
    }

    protected String getLockName(long threadId) {
        return this.id + ":" + threadId;
    }

    private void renewExpiration() {
        ExpirationEntry ee = (ExpirationEntry)EXPIRATION_RENEWAL_MAP.get(this.getEntryName());
        if (ee == null) {
            return;
        }
        Timeout task = this.commandExecutor.getServiceManager().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                ExpirationEntry ent = (ExpirationEntry)EXPIRATION_RENEWAL_MAP.get(RedissonBaseLock.this.getEntryName());
                if (ent == null) {
                    return;
                }
                Long threadId = ent.getFirstThreadId();
                if (threadId == null) {
                    return;
                }
                CompletionStage<Boolean> future = RedissonBaseLock.this.renewExpirationAsync(threadId);
                future.whenComplete((res, e) -> {
                    if (e != null) {
                        log.error("Can't update lock {} expiration", (Object)RedissonBaseLock.this.getRawName(), e);
                        EXPIRATION_RENEWAL_MAP.remove(RedissonBaseLock.this.getEntryName());
                        return;
                    }
                    if (res.booleanValue()) {
                        RedissonBaseLock.this.renewExpiration();
                    } else {
                        RedissonBaseLock.this.cancelExpirationRenewal(null);
                    }
                });
            }
        }, this.internalLockLeaseTime / 3L, TimeUnit.MILLISECONDS);
        ee.setTimeout(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleExpirationRenewal(long threadId) {
        ExpirationEntry entry = new ExpirationEntry();
        ExpirationEntry oldEntry = EXPIRATION_RENEWAL_MAP.putIfAbsent(this.getEntryName(), entry);
        if (oldEntry != null) {
            oldEntry.addThreadId(threadId);
        } else {
            entry.addThreadId(threadId);
            try {
                this.renewExpiration();
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    this.cancelExpirationRenewal(threadId);
                }
            }
        }
    }

    protected CompletionStage<Boolean> renewExpirationAsync(long threadId) {
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('pexpire', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(this.getRawName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    protected void cancelExpirationRenewal(Long threadId) {
        ExpirationEntry task = (ExpirationEntry)EXPIRATION_RENEWAL_MAP.get(this.getEntryName());
        if (task == null) {
            return;
        }
        if (threadId != null) {
            task.removeThreadId(threadId);
        }
        if (threadId == null || task.hasNoThreads()) {
            Timeout timeout = task.getTimeout();
            if (timeout != null) {
                timeout.cancel();
            }
            EXPIRATION_RENEWAL_MAP.remove(this.getEntryName());
        }
    }

    protected <T> RFuture<T> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        Future replicationFuture = CompletableFuture.completedFuture(Collections.emptyMap());
        if (!(this.commandExecutor instanceof CommandBatchService) && !this.commandExecutor.getServiceManager().getConfig().checkSkipSlavesInit()) {
            replicationFuture = this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.INFO_REPLICATION, new Object[0]);
        }
        CompletionStage resFuture = replicationFuture.thenCompose(r -> {
            int availableSlaves = Integer.parseInt(r.getOrDefault("connected_slaves", "0"));
            CommandBatchService executorService = this.createCommandBatchService(availableSlaves);
            RFuture result = executorService.evalWriteAsync(key, codec, evalCommandType, script, keys, params);
            if (this.commandExecutor instanceof CommandBatchService) {
                return result;
            }
            RFuture<BatchResult<?>> future = executorService.executeAsync();
            CompletionStage<Object> f = future.handle((res, ex) -> {
                if (ex != null) {
                    throw new CompletionException((Throwable)ex);
                }
                if (this.commandExecutor.getServiceManager().getCfg().isCheckLockSyncedSlaves() && res.getSyncedSlaves() == 0 && availableSlaves > 0) {
                    throw new CompletionException(new IllegalStateException("None of slaves were synced"));
                }
                return this.commandExecutor.getNow(result.toCompletableFuture());
            });
            return f;
        });
        return new CompletableFutureWrapper(resFuture);
    }

    private CommandBatchService createCommandBatchService(int availableSlaves) {
        if (this.commandExecutor instanceof CommandBatchService) {
            return (CommandBatchService)this.commandExecutor;
        }
        BatchOptions options = BatchOptions.defaults().syncSlaves(availableSlaves, 1L, TimeUnit.SECONDS);
        return new CommandBatchService(this.commandExecutor, options);
    }

    protected void acquireFailed(long waitTime, TimeUnit unit, long threadId) {
        this.commandExecutor.get(this.acquireFailedAsync(waitTime, unit, threadId));
    }

    protected void trySuccessFalse(long currentThreadId, CompletableFuture<Boolean> result) {
        this.acquireFailedAsync(-1L, null, currentThreadId).whenComplete((res, e) -> {
            if (e == null) {
                result.complete(false);
            } else {
                result.completeExceptionally((Throwable)e);
            }
        });
    }

    protected CompletableFuture<Void> acquireFailedAsync(long waitTime, TimeUnit unit, long threadId) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        return this.isExists();
    }

    @Override
    public RFuture<Boolean> isLockedAsync() {
        return this.isExistsAsync();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.isHeldByThread(Thread.currentThread().getId());
    }

    @Override
    public boolean isHeldByThread(long threadId) {
        RFuture future = this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.getRawName(), this.getLockName(threadId));
        return (Boolean)this.get(future);
    }

    @Override
    public RFuture<Integer> getHoldCountAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, HGET, this.getRawName(), this.getLockName(Thread.currentThread().getId()));
    }

    @Override
    public int getHoldCount() {
        return this.get(this.getHoldCountAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.forceUnlockAsync();
    }

    @Override
    public RFuture<Void> unlockAsync() {
        long threadId = Thread.currentThread().getId();
        return this.unlockAsync(threadId);
    }

    protected final <T> RFuture<T> execute(Supplier<RFuture<T>> supplier) {
        CompletableFuture result = new CompletableFuture();
        int retryAttempts = this.commandExecutor.getServiceManager().getConfig().getRetryAttempts();
        AtomicInteger attempts = new AtomicInteger(retryAttempts);
        this.execute(attempts, result, supplier);
        return new CompletableFutureWrapper(result);
    }

    private <T> void execute(AtomicInteger attempts, CompletableFuture<T> result, Supplier<RFuture<T>> supplier) {
        RFuture<Object> future = supplier.get();
        future.whenComplete((r, e) -> {
            if (e != null) {
                if (e.getCause().getMessage().equals("None of slaves were synced")) {
                    if (attempts.decrementAndGet() < 0) {
                        result.completeExceptionally((Throwable)e);
                        return;
                    }
                    this.commandExecutor.getServiceManager().newTimeout(arg_0 -> this.lambda$execute$3(attempts, result, (Supplier)supplier, arg_0), this.commandExecutor.getServiceManager().getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
                    return;
                }
                result.completeExceptionally((Throwable)e);
                return;
            }
            result.complete(r);
        });
    }

    @Override
    public RFuture<Void> unlockAsync(long threadId) {
        return this.execute(() -> this.unlockAsync0(threadId));
    }

    private RFuture<Void> unlockAsync0(long threadId) {
        RFuture<Boolean> future = this.unlockInnerAsync(threadId);
        CompletionStage<Void> f = future.handle((opStatus, e) -> {
            this.cancelExpirationRenewal(threadId);
            if (e != null) {
                if (e instanceof CompletionException) {
                    throw (CompletionException)e;
                }
                throw new CompletionException((Throwable)e);
            }
            if (opStatus == null) {
                IllegalMonitorStateException cause = new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + threadId);
                throw new CompletionException(cause);
            }
            return null;
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void unlock() {
        try {
            this.get(this.unlockAsync(Thread.currentThread().getId()));
        }
        catch (RedisException e) {
            if (e.getCause() instanceof IllegalMonitorStateException) {
                throw (IllegalMonitorStateException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean forceUnlock() {
        return this.get(this.forceUnlockAsync());
    }

    protected abstract RFuture<Boolean> unlockInnerAsync(long var1);

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long currentThreadId) {
        return this.lockAsync(-1L, null, currentThreadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    protected <T> CompletionStage<T> handleNoSync(long threadId, CompletionStage<T> ttlRemainingFuture) {
        CompletionStage s = ttlRemainingFuture.handle((r, ex) -> {
            if (ex != null) {
                if (ex.getCause().getMessage().equals("None of slaves were synced")) {
                    return this.unlockInnerAsync(threadId).handle((r1, e) -> {
                        if (e != null) {
                            if (e.getCause().getMessage().equals("None of slaves were synced")) {
                                throw new CompletionException(ex.getCause());
                            }
                            e.getCause().addSuppressed(ex.getCause());
                        }
                        throw new CompletionException(ex.getCause());
                    });
                }
                throw new CompletionException(ex.getCause());
            }
            return CompletableFuture.completedFuture(r);
        }).thenCompose(f -> f);
        return s;
    }

    private /* synthetic */ void lambda$execute$3(AtomicInteger attempts, CompletableFuture result, Supplier supplier, Timeout t) throws Exception {
        this.execute(attempts, result, supplier);
    }

    public static class ExpirationEntry {
        private final Map<Long, Integer> threadIds = new LinkedHashMap<Long, Integer>();
        private volatile Timeout timeout;

        public synchronized void addThreadId(long threadId) {
            this.threadIds.compute(threadId, (t, counter) -> {
                Integer n = counter = Optional.ofNullable(counter).orElse(0);
                counter = counter + 1;
                return counter;
            });
        }

        public synchronized boolean hasNoThreads() {
            return this.threadIds.isEmpty();
        }

        public synchronized Long getFirstThreadId() {
            if (this.threadIds.isEmpty()) {
                return null;
            }
            return this.threadIds.keySet().iterator().next();
        }

        public synchronized void removeThreadId(long threadId) {
            this.threadIds.compute(threadId, (t, counter) -> {
                if (counter == null) {
                    return null;
                }
                Integer n = counter;
                counter = counter - 1;
                if (counter == 0) {
                    return null;
                }
                return counter;
            });
        }

        public void setTimeout(Timeout timeout) {
            this.timeout = timeout;
        }

        public Timeout getTimeout() {
            return this.timeout;
        }
    }
}

