/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import reactor.core.processor.ReactorProcessor;
import reactor.core.processor.util.SingleUseExecutor;
import reactor.core.support.Exceptions;

public abstract class ExecutorPoweredProcessor<IN, OUT>
extends ReactorProcessor<IN, OUT> {
    protected final ExecutorService executor;

    protected ExecutorPoweredProcessor(String name, ExecutorService executor, boolean autoCancel) {
        super(autoCancel);
        this.executor = executor == null ? SingleUseExecutor.create(name) : executor;
    }

    @Override
    public void onComplete() {
        if (this.executor.getClass() == SingleUseExecutor.class) {
            this.executor.shutdown();
        }
    }

    @Override
    public boolean awaitAndShutdown() {
        return this.awaitAndShutdown(-1L, TimeUnit.SECONDS);
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        try {
            this.shutdown();
            return this.executor.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void forceShutdown() {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.shutdownNow();
    }

    @Override
    public boolean alive() {
        return !this.executor.isTerminated();
    }

    @Override
    public void shutdown() {
        try {
            this.onComplete();
            this.executor.shutdown();
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            this.onError(t);
        }
    }
}

