/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonScript
implements RScript {
    private final CommandAsyncExecutor commandExecutor;

    protected RedissonScript(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public String scriptLoad(String luaScript) {
        return this.commandExecutor.get(this.scriptLoadAsync(luaScript));
    }

    public String scriptLoad(String key, String luaScript) {
        return this.commandExecutor.get(this.scriptLoadAsync(key, luaScript));
    }

    @Override
    public RFuture<String> scriptLoadAsync(String luaScript) {
        return this.commandExecutor.writeAllAsync(RedisCommands.SCRIPT_LOAD, new SlotCallback<String, String>(){
            volatile String result;

            @Override
            public void onSlotResult(String result) {
                this.result = result;
            }

            @Override
            public String onFinish() {
                return this.result;
            }
        }, luaScript);
    }

    public RFuture<String> scriptLoadAsync(String key, String luaScript) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_LOAD, luaScript);
    }

    @Override
    public <R> R eval(RScript.Mode mode, String luaScript, RScript.ReturnType returnType) {
        return this.eval(null, mode, this.commandExecutor.getConnectionManager().getCodec(), luaScript, returnType);
    }

    @Override
    public <R> R eval(RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType) {
        return this.eval(null, mode, codec, luaScript, returnType);
    }

    public <R> R eval(String key, RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType) {
        return this.eval(key, mode, codec, luaScript, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> R eval(RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.eval(null, mode, this.commandExecutor.getConnectionManager().getCodec(), luaScript, returnType, keys, values);
    }

    @Override
    public <R> R eval(RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.eval(null, mode, codec, luaScript, returnType, keys, values);
    }

    public <R> R eval(String key, RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.commandExecutor.get(this.evalAsync(key, mode, codec, luaScript, returnType, keys, values));
    }

    @Override
    public <R> RFuture<R> evalAsync(RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalAsync(null, mode, this.commandExecutor.getConnectionManager().getCodec(), luaScript, returnType, keys, values);
    }

    @Override
    public <R> RFuture<R> evalAsync(RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalAsync(null, mode, codec, luaScript, returnType, keys, values);
    }

    @Override
    public <R> RFuture<R> evalAsync(String key, RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        if (mode == RScript.Mode.READ_ONLY) {
            return this.commandExecutor.evalReadAsync(key, codec, returnType.getCommand(), luaScript, keys, values);
        }
        return this.commandExecutor.evalWriteAsync(key, codec, returnType.getCommand(), luaScript, keys, values);
    }

    @Override
    public <R> R evalSha(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(null, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType);
    }

    @Override
    public <R> R evalSha(RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(null, mode, codec, shaDigest, returnType);
    }

    public <R> R evalSha(String key, RScript.Mode mode, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(key, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    public <R> R evalSha(String key, RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(key, mode, codec, shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> R evalSha(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalSha(null, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType, keys, values);
    }

    @Override
    public <R> R evalSha(RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalSha(null, mode, codec, shaDigest, returnType, keys, values);
    }

    public <R> R evalSha(String key, RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.commandExecutor.get(this.evalShaAsync(key, mode, codec, shaDigest, returnType, keys, values));
    }

    @Override
    public <R> RFuture<R> evalShaAsync(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalShaAsync(null, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType, keys, values);
    }

    @Override
    public <R> RFuture<R> evalShaAsync(RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalShaAsync(null, mode, codec, shaDigest, returnType, keys, values);
    }

    public <R> RFuture<R> evalShaAsync(String key, RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        RedisCommand command = new RedisCommand(returnType.getCommand(), "EVALSHA");
        if (mode == RScript.Mode.READ_ONLY) {
            return this.commandExecutor.evalReadAsync(key, codec, command, shaDigest, keys, values);
        }
        return this.commandExecutor.evalWriteAsync(key, codec, command, shaDigest, keys, values);
    }

    @Override
    public void scriptKill() {
        this.commandExecutor.get(this.scriptKillAsync());
    }

    public void scriptKill(String key) {
        this.commandExecutor.get(this.scriptKillAsync(key));
    }

    @Override
    public RFuture<Void> scriptKillAsync() {
        return this.commandExecutor.writeAllAsync(RedisCommands.SCRIPT_KILL, new Object[0]);
    }

    public RFuture<Void> scriptKillAsync(String key) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_KILL, new Object[0]);
    }

    @Override
    public List<Boolean> scriptExists(String ... shaDigests) {
        return this.commandExecutor.get(this.scriptExistsAsync(shaDigests));
    }

    @Override
    public RFuture<List<Boolean>> scriptExistsAsync(final String ... shaDigests) {
        return this.commandExecutor.writeAllAsync(RedisCommands.SCRIPT_EXISTS, new SlotCallback<List<Boolean>, List<Boolean>>(){
            volatile List<Boolean> result;
            {
                this.result = new ArrayList<Boolean>(shaDigests.length);
            }

            @Override
            public synchronized void onSlotResult(List<Boolean> result) {
                for (int i = 0; i < result.size(); ++i) {
                    if (this.result.size() == i) {
                        this.result.add(false);
                    }
                    this.result.set(i, this.result.get(i) | result.get(i));
                }
            }

            @Override
            public List<Boolean> onFinish() {
                return new ArrayList<Boolean>(this.result);
            }
        }, (Object[])shaDigests);
    }

    public List<Boolean> scriptExists(String key, String ... shaDigests) {
        return this.commandExecutor.get(this.scriptExistsAsync(key, shaDigests));
    }

    public RFuture<List<Boolean>> scriptExistsAsync(String key, String ... shaDigests) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_EXISTS, shaDigests);
    }

    @Override
    public void scriptFlush() {
        this.commandExecutor.get(this.scriptFlushAsync());
    }

    public void scriptFlush(String key) {
        this.commandExecutor.get(this.scriptFlushAsync(key));
    }

    @Override
    public RFuture<Void> scriptFlushAsync() {
        return this.commandExecutor.writeAllAsync(RedisCommands.SCRIPT_FLUSH, new Object[0]);
    }

    public RFuture<Void> scriptFlushAsync(String key) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_FLUSH, new Object[0]);
    }

    @Override
    public <R> RFuture<R> evalShaAsync(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType) {
        return this.evalShaAsync(null, mode, this.commandExecutor.getConnectionManager().getCodec(), shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> RFuture<R> evalShaAsync(RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType) {
        return this.evalShaAsync(null, mode, codec, shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> RFuture<R> evalAsync(RScript.Mode mode, String luaScript, RScript.ReturnType returnType) {
        return this.evalAsync(null, mode, this.commandExecutor.getConnectionManager().getCodec(), luaScript, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> RFuture<R> evalAsync(RScript.Mode mode, Codec codec, String luaScript, RScript.ReturnType returnType) {
        return this.evalAsync(null, mode, codec, luaScript, returnType, Collections.emptyList(), new Object[0]);
    }
}

