/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.reactive.RedissonQueueReactive;

public class RedissonBlockingQueueReactive<V>
extends RedissonQueueReactive<V>
implements RBlockingQueueReactive<V> {
    public RedissonBlockingQueueReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonBlockingQueueReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public Publisher<Long> put(V e) {
        return this.offer(e);
    }

    @Override
    public Publisher<V> take() {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), 0);
    }

    @Override
    public Publisher<V> poll(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), unit.toSeconds(timeout));
    }

    @Override
    public Publisher<V> pollFromAny(long timeout, TimeUnit unit, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>(queueNames.length + 1);
        params.add(this.getName());
        for (String name : queueNames) {
            params.add(name);
        }
        params.add(unit.toSeconds(timeout));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, params.toArray());
    }

    @Override
    public Publisher<V> pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.BRPOPLPUSH, this.getName(), queueName, unit.toSeconds(timeout));
    }

    @Override
    public Publisher<Integer> drainTo(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('ltrim', KEYS[1], -1, 0); return vals", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public Publisher<Integer> drainTo(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getName()), maxElements);
    }
}

