/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class JCacheEventCodec
implements Codec {
    private final Codec codec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            int keyLen = buf.order(ByteOrder.LITTLE_ENDIAN).readInt();
            ByteBuf keyBuf = buf.readSlice(keyLen);
            Object key = JCacheEventCodec.this.codec.getMapKeyDecoder().decode(keyBuf, state);
            result.add(key);
            int valueLen = buf.order(ByteOrder.LITTLE_ENDIAN).readInt();
            ByteBuf valueBuf = buf.readSlice(valueLen);
            Object value = JCacheEventCodec.this.codec.getMapValueDecoder().decode(valueBuf, state);
            result.add(value);
            return result;
        }
    };

    public JCacheEventCodec(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        throw new UnsupportedOperationException();
    }
}

