/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.redisson.Redisson;
import org.redisson.RedissonBaseMapIterator;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.EmptyConvertor;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.jcache.JCacheEntry;
import org.redisson.jcache.JCacheEntryEvent;
import org.redisson.jcache.JCacheEventCodec;
import org.redisson.jcache.JCacheManager;
import org.redisson.jcache.JMutableEntry;
import org.redisson.jcache.configuration.JCacheConfiguration;
import org.redisson.misc.Hash;

public class JCache<K, V>
extends RedissonObject
implements Cache<K, V> {
    private static final RedisCommand<Object> EVAL_GET_REPLACE = new RedisCommand("EVAL", 9, RedisCommand.ValueType.MAP, RedisCommand.ValueType.MAP_VALUE);
    private static final RedisCommand<Long> EVAL_REPLACE_OLD_NEW_VALUE = new RedisCommand("EVAL", new EmptyConvertor(), 10, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE, RedisCommand.ValueType.MAP_VALUE));
    private static final RedisCommand<Boolean> EVAL_REPLACE_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 9, RedisCommand.ValueType.MAP);
    private static final RedisCommand<Object> EVAL_GET_REMOVE_VALUE = new RedisCommand("EVAL", 7, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE);
    private static final RedisCommand<Long> EVAL_REMOVE_VALUES = new RedisCommand("EVAL", 5, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Boolean> EVAL_REMOVE_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanAmountReplayConvertor(), 7, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Object> EVAL_GET_TTL = new RedisCommand("EVAL", 8, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE);
    private static final RedisCommand<Boolean> EVAL_PUT = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 11, RedisCommand.ValueType.MAP);
    private static final RedisCommand<Boolean> EVAL_PUT_IF_ABSENT = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 7, RedisCommand.ValueType.MAP);
    private static final RedisCommand<Boolean> EVAL_REMOVE_KEY_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 8, RedisCommand.ValueType.MAP);
    private static final RedisCommand<List<Object>> EVAL_GET_PUT = new RedisCommand("EVAL", new ObjectListReplayDecoder(), 11, RedisCommand.ValueType.MAP, RedisCommand.ValueType.OBJECT);
    private static final RedisCommand<Boolean> EVAL_CONTAINS_KEY = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 6, RedisCommand.ValueType.MAP_KEY);
    final JCacheManager cacheManager;
    final JCacheConfiguration<K, V> config;
    final ConcurrentMap<CacheEntryListenerConfiguration<K, V>, Map<Integer, String>> listeners = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, Map<Integer, String>>();
    final Redisson redisson;
    CacheLoader<K, V> cacheLoader;
    CacheWriter<K, V> cacheWriter;
    boolean closed;

    public JCache(JCacheManager cacheManager, Redisson redisson, String name, JCacheConfiguration<K, V> config) {
        super(redisson.getConfig().getCodec(), redisson.getCommandExecutor(), name);
        this.redisson = redisson;
        Factory<CacheLoader<K, V>> cacheLoaderFactory = config.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            this.cacheLoader = cacheLoaderFactory.create();
        }
        Factory<CacheWriter<K, V>> cacheWriterFactory = config.getCacheWriterFactory();
        if (config.getCacheWriterFactory() != null) {
            this.cacheWriter = cacheWriterFactory.create();
        }
        this.cacheManager = cacheManager;
        this.config = config;
        redisson.getEvictionScheduler().scheduleJCache(this.getName(), this.getTimeoutSetName(), this.getExpiredChannelName());
        for (CacheEntryListenerConfiguration<K, V> listenerConfig : config.getCacheEntryListenerConfigurations()) {
            this.registerCacheEntryListener(listenerConfig, false);
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    String getTimeoutSetName() {
        return "jcache_timeout_set:{" + this.getName() + "}";
    }

    String getCreatedChannelName() {
        return "jcache_created_channel:{" + this.getName() + "}";
    }

    String getUpdatedChannelName() {
        return "jcache_updated_channel:{" + this.getName() + "}";
    }

    String getExpiredChannelName() {
        return "jcache_expired_channel:{" + this.getName() + "}";
    }

    String getRemovedChannelName() {
        return "jcache_removed_channel:{" + this.getName() + "}";
    }

    private long currentNanoTime() {
        if (this.config.isStatisticsEnabled()) {
            return System.nanoTime();
        }
        return 0L;
    }

    @Override
    public V get(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        V value = this.getValue(key);
        if (value == null) {
            this.cacheManager.getStatBean(this).addMisses(1L);
            if (this.config.isReadThrough()) {
                value = this.load(key);
            }
        } else {
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            this.cacheManager.getStatBean(this).addHits(1L);
        }
        return value;
    }

    private V getValue(K key) {
        Long accessTimeout = this.getAccessTimeout();
        V value = this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_GET_TTL, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return nil; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return value; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), accessTimeout, System.currentTimeMillis(), key));
        return value;
    }

    private Long getAccessTimeout() {
        if (this.config.getExpiryPolicy().getExpiryForAccess() == null) {
            return -1L;
        }
        Long accessTimeout = this.config.getExpiryPolicy().getExpiryForAccess().getAdjustedTime(System.currentTimeMillis());
        if (this.config.getExpiryPolicy().getExpiryForAccess().isZero()) {
            accessTimeout = 0L;
        } else if (accessTimeout == Long.MAX_VALUE) {
            accessTimeout = -1L;
        }
        return accessTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(K key) {
        RLock lock = this.getLock(key);
        lock.lock(30L, TimeUnit.MINUTES);
        try {
            V value = this.getValue(key);
            if (value == null) {
                try {
                    value = this.cacheLoader.load(key);
                }
                catch (Exception ex) {
                    throw new CacheLoaderException(ex);
                }
                if (value != null) {
                    long startTime = this.currentNanoTime();
                    this.putValue(key, value);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                }
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean putValue(K key, Object value) {
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        return (Boolean)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_PUT, "if redis.call('hexists', KEYS[1], ARGV[4]) == 1 then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]);local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[4], msg); return 0;elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); return 1;else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); return 1;end; else if ARGV[1] == '0' then return 0;elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); return 1;else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); return 1;end; end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), creationTimeout, updateTimeout, System.currentTimeMillis(), key, value));
    }

    private Long getUpdateTimeout() {
        if (this.config.getExpiryPolicy().getExpiryForUpdate() == null) {
            return -1L;
        }
        Long updateTimeout = this.config.getExpiryPolicy().getExpiryForUpdate().getAdjustedTime(System.currentTimeMillis());
        if (this.config.getExpiryPolicy().getExpiryForUpdate().isZero()) {
            updateTimeout = 0L;
        } else if (updateTimeout == Long.MAX_VALUE) {
            updateTimeout = -1L;
        }
        return updateTimeout;
    }

    private Long getCreationTimeout() {
        if (this.config.getExpiryPolicy().getExpiryForCreation() == null) {
            return -1L;
        }
        Long creationTimeout = this.config.getExpiryPolicy().getExpiryForCreation().getAdjustedTime(System.currentTimeMillis());
        if (this.config.getExpiryPolicy().getExpiryForCreation().isZero()) {
            creationTimeout = 0L;
        } else if (creationTimeout == Long.MAX_VALUE) {
            creationTimeout = -1L;
        }
        return creationTimeout;
    }

    private boolean putIfAbsentValue(K key, Object value) {
        Long creationTimeout = this.getCreationTimeout();
        return (Boolean)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_PUT_IF_ABSENT, "if redis.call('hexists', KEYS[1], ARGV[2]) == 1 then return 0; else if ARGV[1] == '0' then return 0;elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;else redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;end; end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName()), creationTimeout, key, value));
    }

    private String getLockName(Object key) {
        byte[] keyState = this.encodeMapKey(key);
        return "{" + this.getName() + "}:" + Hash.hashToBase64(keyState) + ":key";
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        Long accessTimeout = this.getAccessTimeout();
        ArrayList<Object> args = new ArrayList<Object>(keys.size() + 2);
        args.add(accessTimeout);
        args.add(System.currentTimeMillis());
        args.addAll(keys);
        Map res = (Map)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Map<Object, Object>>("EVAL", new MapGetAllDecoder(args, 2, true), 8, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE), "local expireHead = redis.call('zrange', KEYS[2], 0, 0, 'withscores');local accessTimeout = ARGV[1]; local currentTime = tonumber(ARGV[2]); local hasExpire = #expireHead == 2 and tonumber(expireHead[2]) <= currentTime; local map = redis.call('hmget', KEYS[1], unpack(ARGV, 3, #ARGV)); local result = {};for i, value in ipairs(map) do if value ~= false then local key = ARGV[i+2]; if hasExpire then local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= currentTime then value = false; end; end; if accessTimeout == '0' then redis.call('hdel', KEYS[1], key); redis.call('zrem', KEYS[2], key); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(value), value); redis.call('publish', KEYS[3], {key, value}); elseif accessTimeout ~= '-1' then redis.call('zadd', KEYS[2], accessTimeout, key); end; end; table.insert(result, value); end; return result;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), args.toArray()));
        HashMap result = new HashMap();
        for (Map.Entry entry : res.entrySet()) {
            if (entry.getValue() != null) {
                this.cacheManager.getStatBean(this).addHits(1L);
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.config.isReadThrough()) continue;
            this.cacheManager.getStatBean(this).addMisses(1L);
            V value = this.load(entry.getKey());
            if (value == null) continue;
            result.put(entry.getKey(), value);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        return result;
    }

    @Override
    public boolean containsKey(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        return (Boolean)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_KEY, "if redis.call('hexists', KEYS[1], ARGV[2]) == 0 then return 0;end;local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return 0; end; return 1;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), key));
    }

    @Override
    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Object key : keys) {
                    try {
                        if (JCache.this.containsKey(key) && !replaceExistingValues) continue;
                        RLock lock = JCache.this.getLock(key);
                        lock.lock(30L, TimeUnit.MINUTES);
                        try {
                            Object value;
                            if (JCache.this.containsKey(key) && !replaceExistingValues) continue;
                            try {
                                value = JCache.this.cacheLoader.load(key);
                            }
                            catch (Exception ex) {
                                throw new CacheLoaderException(ex);
                            }
                            if (value == null) continue;
                            JCache.this.putValue(key, value);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Exception e) {
                        if (completionListener != null) {
                            completionListener.onException(e);
                        }
                        return;
                    }
                }
                if (completionListener != null) {
                    completionListener.onCompletion();
                }
            }
        });
    }

    private RLock getLock(K key) {
        String lockName = this.getLockName(key);
        RLock lock = this.redisson.getLock(lockName);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                List<Object> result = this.getAndPutValue(key, value);
                if (result.isEmpty()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    return;
                }
                Long added = (Long)result.get(0);
                if (added == null) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    return;
                }
                if (Long.valueOf(1L).equals(added)) {
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                }
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (result.size() > 1 && result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (result.size() > 1 && result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw new CacheWriterException(e);
                }
                this.cacheManager.getStatBean(this).addPuts(1L);
            }
            finally {
                lock.unlock();
            }
        }
        boolean result = this.putValue(key, value);
        if (result) {
            this.cacheManager.getStatBean(this).addPuts(1L);
        }
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
    }

    private long removeValues(Object ... keys) {
        return (Long)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_REMOVE_VALUES, "redis.call('zrem', KEYS[2], unpack(ARGV)); return redis.call('hdel', KEYS[1], unpack(ARGV)); ", Arrays.asList(this.getName(), this.getTimeoutSetName()), keys));
    }

    private List<Object> getAndPutValue(K key, V value) {
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        return (List)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_GET_PUT, "local value = redis.call('hget', KEYS[1], ARGV[4]);if value ~= false then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return {0, value};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); return {1, value};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); return {1, value};end; else if ARGV[1] == '0' then return {nil};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[4], msg); return {1};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[4], msg); return {1};end; end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getCreatedChannelName(), this.getUpdatedChannelName()), creationTimeout, updateTimeout, System.currentTimeMillis(), key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndPut(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                List<Object> result = this.getAndPutValue(key, value);
                if (result.isEmpty()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addMisses(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    V v = null;
                    return v;
                }
                Long added = (Long)result.get(0);
                if (added == null) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    Object object = result.get(1);
                    return (V)object;
                }
                if (Long.valueOf(1L).equals(added)) {
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                }
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw new CacheWriterException(e);
                }
                if (result.size() == 1) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addMisses(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    V v = null;
                    return v;
                }
                this.cacheManager.getStatBean(this).addPuts(1L);
                this.cacheManager.getStatBean(this).addHits(1L);
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                Object object = result.get(1);
                return (V)object;
            }
            finally {
                lock.unlock();
            }
        }
        List<Object> result = this.getAndPutValue(key, value);
        if (result.size() < 2) {
            this.cacheManager.getStatBean(this).addPuts(1L);
            this.cacheManager.getStatBean(this).addMisses(1L);
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            return null;
        }
        this.cacheManager.getStatBean(this).addPuts(1L);
        this.cacheManager.getStatBean(this).addHits(1L);
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        return (V)result.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        V value;
        K key;
        this.checkNotClosed();
        HashMap<K, Object> deletedKeys = new HashMap<K, Object>();
        HashMap<K, JCacheEntry<K, V>> addedEntries = new HashMap<K, JCacheEntry<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            key = entry.getKey();
            if (key == null) {
                throw new NullPointerException();
            }
            value = entry.getValue();
            if (value != null) continue;
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            long startTime = this.currentNanoTime();
            if (this.config.isWriteThrough()) {
                RLock lock = this.getLock(key);
                lock.lock(30L, TimeUnit.MINUTES);
                List<Object> result = this.getAndPutValue(key, value);
                if (result.isEmpty()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    continue;
                }
                Long added = (Long)result.get(0);
                if (added == null) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    continue;
                }
                if (Long.valueOf(1L).equals(added)) {
                    addedEntries.put(key, new JCacheEntry<K, V>(key, value));
                } else {
                    Object val = null;
                    if (result.size() > 1) {
                        val = result.get(1);
                    }
                    deletedKeys.put(key, val);
                }
                this.cacheManager.getStatBean(this).addPuts(1L);
            } else {
                boolean result = this.putValue(key, value);
                if (result) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                }
            }
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        }
        if (this.config.isWriteThrough()) {
            try {
                try {
                    this.cacheWriter.writeAll(addedEntries.values());
                }
                catch (CacheWriterException e) {
                    this.removeValues(addedEntries.keySet().toArray());
                    throw e;
                }
                catch (RuntimeException e) {
                    this.removeValues(addedEntries.keySet().toArray());
                    throw new CacheWriterException(e);
                }
                try {
                    this.cacheWriter.deleteAll(deletedKeys.keySet());
                }
                catch (CacheWriterException e) {
                    for (Map.Entry deletedEntry : deletedKeys.entrySet()) {
                        if (deletedEntry.getValue() == null) continue;
                        this.putValue(deletedEntry.getKey(), deletedEntry.getValue());
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    for (Map.Entry deletedEntry : deletedKeys.entrySet()) {
                        if (deletedEntry.getValue() == null) continue;
                        this.putValue(deletedEntry.getKey(), deletedEntry.getValue());
                    }
                    throw new CacheWriterException(e);
                }
            }
            finally {
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    this.getLock(entry.getKey()).unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                boolean result = this.putIfAbsentValue(key, value);
                if (result) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                boolean bl = result;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        boolean result = this.putIfAbsentValue(key, value);
        if (result) {
            this.cacheManager.getStatBean(this).addPuts(1L);
        }
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        return result;
    }

    private boolean removeValue(K key) {
        return (Boolean)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_REMOVE_VALUE, "local value = redis.call('hexists', KEYS[1], ARGV[2]); if value == 0 then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return 0; end; value = redis.call('hget', KEYS[1], ARGV[2]); redis.call('hdel', KEYS[1], ARGV[2]); redis.call('zrem', KEYS[2], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return 1; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), System.currentTimeMillis(), key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        long startTime = System.currentTimeMillis();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                V oldValue = this.getValue(key);
                boolean result = this.removeValue(key);
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (oldValue != null) {
                        this.putValue(key, oldValue);
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (oldValue != null) {
                        this.putValue(key, oldValue);
                    }
                    throw new CacheWriterException(e);
                }
                if (result) {
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                }
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                boolean bl = result;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        boolean result = this.removeValue(key);
        if (result) {
            this.cacheManager.getStatBean(this).addRemovals(1L);
        }
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        return result;
    }

    private boolean removeValue(K key, V value) {
        Long accessTimeout = this.getAccessTimeout();
        return (Boolean)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_REMOVE_KEY_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return 0; end; if ARGV[4] == value then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return 1; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), accessTimeout, System.currentTimeMillis(), key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                boolean result = this.removeValue(key, value);
                if (result) {
                    try {
                        this.cacheWriter.delete(key);
                    }
                    catch (CacheWriterException e) {
                        this.putValue(key, value);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.putValue(key, value);
                        throw new CacheWriterException(e);
                    }
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                    this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                    boolean bl = true;
                    return bl;
                }
                this.cacheManager.getStatBean(this).addMisses(1L);
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        boolean result = this.removeValue(key, value);
        if (result) {
            this.cacheManager.getStatBean(this).addHits(1L);
            this.cacheManager.getStatBean(this).addRemovals(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        return result;
    }

    private V getAndRemoveValue(K key) {
        return this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_GET_REMOVE_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return nil; end; redis.call('hdel', KEYS[1], ARGV[2]); redis.call('zrem', KEYS[2], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return value; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), System.currentTimeMillis(), key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndRemove(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                V value = this.getAndRemoveValue(key);
                if (value != null) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (value != null) {
                        this.putValue(key, value);
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (value != null) {
                        this.putValue(key, value);
                    }
                    throw new CacheWriterException(e);
                }
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                V v = value;
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        V value = this.getAndRemoveValue(key);
        if (value != null) {
            this.cacheManager.getStatBean(this).addHits(1L);
            this.cacheManager.getStatBean(this).addRemovals(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        return value;
    }

    private long replaceValue(K key, V oldValue, V newValue) {
        Long accessTimeout = this.getAccessTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        return (Long)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_REPLACE_OLD_NEW_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[4]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[3]) then return 0; end; if ARGV[5] == value then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); end; return 1;end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(value), value); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); return 0;end; return -1; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), accessTimeout, updateTimeout, System.currentTimeMillis(), key, oldValue, newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (oldValue == null) {
            throw new NullPointerException();
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                long result = this.replaceValue(key, oldValue, newValue);
                if (result == 1L) {
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, newValue));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    boolean bl = true;
                    return bl;
                }
                if (result == 0L) {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                } else {
                    this.cacheManager.getStatBean(this).addHits(1L);
                }
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        long result = this.replaceValue(key, oldValue, newValue);
        if (result == 1L) {
            this.cacheManager.getStatBean(this).addHits(1L);
            this.cacheManager.getStatBean(this).addPuts(1L);
        } else if (result == 0L) {
            this.cacheManager.getStatBean(this).addMisses(1L);
        } else {
            this.cacheManager.getStatBean(this).addHits(1L);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        return result == 1L;
    }

    private boolean replaceValue(K key, V value) {
        Long updateTimeout = this.getUpdateTimeout();
        return (Boolean)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_REPLACE_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return 0; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); end; return 1;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), updateTimeout, System.currentTimeMillis(), key, value));
    }

    private V getAndReplaceValue(K key, V value) {
        Long updateTimeout = this.getUpdateTimeout();
        return this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_GET_REPLACE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return nil; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); end; return value;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), updateTimeout, System.currentTimeMillis(), key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                boolean result = this.replaceValue(key, value);
                if (result) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                boolean bl = result;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        boolean result = this.replaceValue(key, value);
        if (result) {
            this.cacheManager.getStatBean(this).addHits(1L);
            this.cacheManager.getStatBean(this).addPuts(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndReplace(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLock(key);
            lock.lock(30L, TimeUnit.MINUTES);
            try {
                V result = this.getAndReplaceValue(key, value);
                if (result != null) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                V v = result;
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        V result = this.getAndReplaceValue(key, value);
        if (result != null) {
            this.cacheManager.getStatBean(this).addHits(1L);
            this.cacheManager.getStatBean(this).addPuts(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        HashMap<Object, V> deletedKeys = new HashMap<Object, V>();
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            for (Object key : keys) {
                RLock rLock = this.getLock(key);
                rLock.lock(30L, TimeUnit.MINUTES);
                V result = this.getAndRemoveValue(key);
                if (result == null) continue;
                deletedKeys.put(key, result);
            }
            try {
                try {
                    this.cacheWriter.deleteAll(deletedKeys.keySet());
                }
                catch (CacheWriterException e) {
                    for (Map.Entry entry : deletedKeys.entrySet()) {
                        if (entry.getValue() == null) continue;
                        this.putValue(entry.getKey(), entry.getValue());
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    for (Map.Entry entry : deletedKeys.entrySet()) {
                        if (entry.getValue() == null) continue;
                        this.putValue(entry.getKey(), entry.getValue());
                    }
                    throw new CacheWriterException(e);
                }
                this.cacheManager.getStatBean(this).addRemovals(deletedKeys.size());
            }
            finally {
                for (Object key : keys) {
                    this.getLock(key).unlock();
                }
            }
        }
        long removedKeys = this.removeValues(keys.toArray());
        this.cacheManager.getStatBean(this).addRemovals(removedKeys);
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
    }

    MapScanResult<ScanObjectEntry, ScanObjectEntry> scanIterator(String name, InetSocketAddress client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, name, (Codec)new ScanCodec(this.codec), RedisCommands.HSCAN, name, startPos);
        return (MapScanResult)this.get((K)f);
    }

    protected Iterator<K> keyIterator() {
        return new RedissonBaseMapIterator<K, V, K>(){

            @Override
            protected K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getKey().getObj();
            }

            @Override
            protected MapScanResult<ScanObjectEntry, ScanObjectEntry> iterator() {
                return JCache.this.scanIterator(JCache.this.getName(), this.client, this.nextIterPos);
            }

            @Override
            protected void removeKey() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected V put(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry, V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void removeAll() {
        this.checkNotClosed();
        if (this.config.isWriteThrough()) {
            Iterator<K> iterator = this.keyIterator();
            while (iterator.hasNext()) {
                K key = iterator.next();
                this.remove(key);
            }
        } else {
            long startTime = this.currentNanoTime();
            long removedObjects = (Long)this.get((K)this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local expiredEntriesCount = redis.call('zcount', KEYS[2], 0, ARGV[1]); local result = 0; if expiredEntriesCount > 0 then result = redis.call('zcard', KEYS[2]) - expiredEntriesCount; else result = redis.call('hlen', KEYS[1]); end; redis.call('del', KEYS[1], KEYS[2]); return result; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis()));
            this.cacheManager.getStatBean(this).addRemovals(removedObjects);
            this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        }
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.get((K)this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.getTimeoutSetName()));
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.config)) {
            return (C)((Configuration)clazz.cast(this.config));
        }
        throw new IllegalArgumentException("Configuration object is not an instance of " + clazz);
    }

    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        V value = this.getValue(key);
        if (value != null) {
            this.cacheManager.getStatBean(this).addHits(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        JMutableEntry<K, V> entry = new JMutableEntry<K, V>(this, value, key, this.config.isReadThrough());
        try {
            T result = entryProcessor.process(entry, arguments);
            if (entry.getAction() == JMutableEntry.Action.CREATED || entry.getAction() == JMutableEntry.Action.UPDATED) {
                this.put(key, entry.getValue());
            }
            if (entry.getAction() == JMutableEntry.Action.DELETED) {
                this.remove(key);
            }
            return result;
        }
        catch (EntryProcessorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new EntryProcessorException(e);
        }
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed();
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap results = new HashMap();
        for (K key : keys) {
            try {
                final T result = this.invoke(key, entryProcessor, arguments);
                if (result == null) continue;
                results.put(key, new EntryProcessorResult<T>(){

                    @Override
                    public T get() throws EntryProcessorException {
                        return result;
                    }
                });
            }
            catch (EntryProcessorException e) {
                results.put(key, new EntryProcessorResult<T>(){

                    @Override
                    public T get() throws EntryProcessorException {
                        throw e;
                    }
                });
            }
        }
        return results;
    }

    @Override
    public CacheManager getCacheManager() {
        this.checkNotClosed();
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        JCacheManager jCacheManager = this.cacheManager;
        synchronized (jCacheManager) {
            if (!this.isClosed()) {
                this.cacheManager.closeCache(this);
                for (CacheEntryListenerConfiguration config : this.listeners.keySet()) {
                    this.deregisterCacheEntryListener(config);
                }
                this.closed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.registerCacheEntryListener(cacheEntryListenerConfiguration, true);
    }

    private void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean addToConfig) {
        int listenerId;
        RTopic<List<Object>> topic;
        Factory<CacheEntryListener<K, V>> factory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
        final CacheEntryListener<K, V> listener = factory.create();
        Factory<CacheEntryEventFilter<K, V>> filterFactory = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory();
        final CacheEntryEventFilter<K, V> filter = filterFactory != null ? filterFactory.create() : null;
        Map<Integer, String> values = new ConcurrentHashMap();
        Map oldValues = this.listeners.putIfAbsent(cacheEntryListenerConfiguration, values);
        if (oldValues != null) {
            values = oldValues;
        }
        if (CacheEntryRemovedListener.class.isAssignableFrom(listener.getClass())) {
            topic = this.redisson.getTopic(this.getRemovedChannelName(), new JCacheEventCodec(this.codec));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                @Override
                public void onMessage(String channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.REMOVED, msg.get(0), msg.get(1));
                    if (filter == null || filter.evaluate(event)) {
                        List events = Collections.singletonList(event);
                        ((CacheEntryRemovedListener)listener).onRemoved(events);
                    }
                }
            });
            values.put(listenerId, this.getRemovedChannelName());
        }
        if (CacheEntryCreatedListener.class.isAssignableFrom(listener.getClass())) {
            topic = this.redisson.getTopic(this.getCreatedChannelName(), new JCacheEventCodec(this.codec));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                @Override
                public void onMessage(String channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.CREATED, msg.get(0), msg.get(1));
                    if (filter == null || filter.evaluate(event)) {
                        List events = Collections.singletonList(event);
                        ((CacheEntryCreatedListener)listener).onCreated(events);
                    }
                }
            });
            values.put(listenerId, this.getCreatedChannelName());
        }
        if (CacheEntryUpdatedListener.class.isAssignableFrom(listener.getClass())) {
            topic = this.redisson.getTopic(this.getUpdatedChannelName(), new JCacheEventCodec(this.codec));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                @Override
                public void onMessage(String channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.UPDATED, msg.get(0), msg.get(1));
                    if (filter == null || filter.evaluate(event)) {
                        List events = Collections.singletonList(event);
                        ((CacheEntryUpdatedListener)listener).onUpdated(events);
                    }
                }
            });
            values.put(listenerId, this.getUpdatedChannelName());
        }
        if (CacheEntryExpiredListener.class.isAssignableFrom(listener.getClass())) {
            topic = this.redisson.getTopic(this.getExpiredChannelName(), new JCacheEventCodec(this.codec));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                @Override
                public void onMessage(String channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.EXPIRED, msg.get(0), msg.get(1));
                    if (filter == null || filter.evaluate(event)) {
                        List events = Collections.singletonList(event);
                        ((CacheEntryExpiredListener)listener).onExpired(events);
                    }
                }
            });
            values.put(listenerId, this.getExpiredChannelName());
        }
        if (addToConfig) {
            this.config.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Map listenerIds = (Map)this.listeners.remove(cacheEntryListenerConfiguration);
        if (listenerIds != null) {
            for (Map.Entry entry : listenerIds.entrySet()) {
                this.redisson.getTopic((String)entry.getValue()).removeListener((Integer)entry.getKey());
            }
        }
        this.config.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkNotClosed();
        return new RedissonBaseMapIterator<K, V, Cache.Entry<K, V>>(){

            @Override
            protected Cache.Entry<K, V> getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                JCache.this.cacheManager.getStatBean(JCache.this).addHits(1L);
                Long accessTimeout = JCache.this.getAccessTimeout();
                JCacheEntry<Object, Object> je = new JCacheEntry<Object, Object>(entry.getKey().getObj(), entry.getValue().getObj());
                if (accessTimeout == 0L) {
                    this.remove();
                } else if (accessTimeout != -1L) {
                    JCache.this.get((Object)JCache.this.commandExecutor.writeAsync(JCache.this.getName(), RedisCommands.ZADD_BOOL, JCache.this.getTimeoutSetName(), accessTimeout, entry.getKey().getObj()));
                }
                return je;
            }

            @Override
            protected MapScanResult<ScanObjectEntry, ScanObjectEntry> iterator() {
                return JCache.this.scanIterator(JCache.this.getName(), this.client, this.nextIterPos);
            }

            @Override
            protected void removeKey() {
                JCache.this.remove(((ScanObjectEntry)this.entry.getKey()).getObj());
            }

            @Override
            protected V put(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry, V value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

