/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RScheduledFuture;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.PromiseDelegator;

public class RedissonScheduledFuture<V>
extends PromiseDelegator<V>
implements RScheduledFuture<V> {
    private final long scheduledExecutionTime;
    private final String taskId;

    public RedissonScheduledFuture(RemotePromise<V> promise, long scheduledExecutionTime) {
        super(promise);
        this.scheduledExecutionTime = scheduledExecutionTime;
        this.taskId = promise.getRequestId();
    }

    @Override
    public int compareTo(Delayed other) {
        if (this == other) {
            return 0;
        }
        long diff = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        if (diff == 0L) {
            return 0;
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.scheduledExecutionTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }
}

