/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSet<V>
extends RedissonExpirable
implements RSet<V> {
    protected RedissonSet(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonSet(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SCARD_INT, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.readAsync(this.getName(o), this.codec, RedisCommands.SISMEMBER, this.getName(o), o);
    }

    protected String getName(Object o) {
        return this.getName();
    }

    ListScanResult<V> scanIterator(String name, InetSocketAddress client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.SSCAN, name, startPos);
        return (ListScanResult)this.get(f);
    }

    @Override
    public Iterator<V> iterator() {
        return new RedissonBaseIterator<V>(){

            @Override
            ListScanResult<V> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonSet.this.scanIterator(RedissonSet.this.getName(), client, nextIterPos);
            }

            @Override
            void remove(V value) {
                RedissonSet.this.remove(value);
            }
        };
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SMEMBERS, this.getName());
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(e), this.codec, RedisCommands.SADD_SINGLE, this.getName(e), e);
    }

    @Override
    public V removeRandom() {
        return this.get(this.removeRandomAsync());
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SPOP_SINGLE, this.getName());
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public RFuture<V> randomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SRANDMEMBER_SINGLE, this.getName());
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.commandExecutor.writeAsync(this.getName(o), this.codec, RedisCommands.SREM_SINGLE, this.getName(o), o);
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        return this.commandExecutor.writeAsync(this.getName(member), this.codec, RedisCommands.SMOVE, this.getName(member), destination, member);
    }

    @Override
    public boolean move(String destination, V member) {
        return this.get(this.moveAsync(destination, member));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(true);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS), "redis.call('sadd', KEYS[2], unpack(ARGV)); local size = redis.call('sdiff', KEYS[2], KEYS[1]);redis.call('del', KEYS[2]); return #size == 0 and 1 or 0; ", Arrays.asList(this.getName(), "redisson_temp__{" + this.getName() + "}"), c.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SADD_BOOL, args.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS), "redis.call('sadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('scard', KEYS[1]); local size = redis.call('sinterstore', KEYS[1], KEYS[1], KEYS[2]);redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getName(), "redisson_temp__{" + this.getName() + "}"), c.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SREM_SINGLE, args.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNION, args.toArray());
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFFSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFF, args.toArray());
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTERSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTER, args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

