/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class CompositeCodec
implements Codec {
    private final Codec mapKeyCodec;
    private final Codec mapValueCodec;
    private final Codec valueCodec;

    public CompositeCodec(Codec mapKeyCodec, Codec mapValueCodec) {
        this(mapKeyCodec, mapValueCodec, null);
    }

    public CompositeCodec(Codec mapKeyCodec, Codec mapValueCodec, Codec valueCodec) {
        this.mapKeyCodec = mapKeyCodec;
        this.mapValueCodec = mapValueCodec;
        this.valueCodec = valueCodec;
    }

    public CompositeCodec(ClassLoader classLoader, CompositeCodec codec) throws ReflectiveOperationException {
        this.mapKeyCodec = BaseCodec.copy(classLoader, codec.mapKeyCodec);
        this.mapValueCodec = BaseCodec.copy(classLoader, codec.mapValueCodec);
        this.valueCodec = BaseCodec.copy(classLoader, codec.valueCodec);
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.mapValueCodec.getMapValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.mapValueCodec.getMapValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.mapKeyCodec.getMapKeyDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.mapKeyCodec.getMapKeyEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.valueCodec.getValueDecoder();
    }

    @Override
    public Encoder getValueEncoder() {
        return this.valueCodec.getValueEncoder();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mapKeyCodec == null ? 0 : this.mapKeyCodec.hashCode());
        result = 31 * result + (this.mapValueCodec == null ? 0 : this.mapValueCodec.hashCode());
        result = 31 * result + (this.valueCodec == null ? 0 : this.valueCodec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeCodec other = (CompositeCodec)obj;
        if (this.mapKeyCodec == null ? other.mapKeyCodec != null : !this.mapKeyCodec.equals(other.mapKeyCodec)) {
            return false;
        }
        if (this.mapValueCodec == null ? other.mapValueCodec != null : !this.mapValueCodec.equals(other.mapValueCodec)) {
            return false;
        }
        return !(this.valueCodec == null ? other.valueCodec != null : !this.valueCodec.equals(other.valueCodec));
    }
}

