/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RIdGenerator;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonIdGenerator
extends RedissonExpirable
implements RIdGenerator {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong counter = new AtomicLong();
    private final Queue<CompletableFuture<Long>> queue = new ConcurrentLinkedQueue<CompletableFuture<Long>>();
    private final AtomicBoolean isWorkerActive = new AtomicBoolean();

    RedissonIdGenerator(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    private String getAllocationSizeName() {
        return RedissonIdGenerator.suffixName(this.getRawName(), "allocation");
    }

    @Override
    public boolean tryInit(long value, long allocationSize) {
        return this.get(this.tryInitAsync(value, allocationSize));
    }

    @Override
    public long nextId() {
        return this.get(this.nextIdAsync());
    }

    @Override
    public RFuture<Boolean> tryInitAsync(long value, long allocationSize) {
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('setnx', KEYS[1], ARGV[1]); return redis.call('setnx', KEYS[2], ARGV[2]); ", Arrays.asList(this.getRawName(), this.getAllocationSizeName()), value, allocationSize);
    }

    private void startIdRequestsHandle() {
        if (!this.isWorkerActive.compareAndSet(false, true) || this.commandExecutor.getConnectionManager().getExecutor().isShutdown()) {
            return;
        }
        this.handleIdRequests();
    }

    private void handleIdRequests() {
        if (this.queue.peek() == null) {
            this.isWorkerActive.set(false);
            if (!this.queue.isEmpty()) {
                this.startIdRequestsHandle();
            }
            return;
        }
        long v = this.counter.decrementAndGet();
        if (v >= 0L) {
            CompletableFuture<Long> pp = this.queue.poll();
            if (pp != null) {
                pp.complete(this.start.incrementAndGet());
                this.handleIdRequests();
            } else {
                this.counter.incrementAndGet();
                this.isWorkerActive.set(false);
                if (!this.queue.isEmpty()) {
                    this.startIdRequestsHandle();
                }
            }
        } else {
            RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local allocationSize = redis.call('get', KEYS[2]); if allocationSize == false then allocationSize = 5000; redis.call('set', KEYS[2], allocationSize);end;local value = redis.call('get', KEYS[1]); if value == false then redis.call('incr', KEYS[1]);value = 1; end; redis.call('incrby', KEYS[1], allocationSize); return {value, allocationSize}; ", Arrays.asList(this.getRawName(), this.getAllocationSizeName()), new Object[0]);
            future.whenComplete((res, ex) -> {
                if (ex != null) {
                    if (ex instanceof RedissonShutdownException) {
                        return;
                    }
                    this.log.error(ex.getMessage(), (Throwable)ex);
                    this.commandExecutor.getConnectionManager().newTimeout(task -> this.handleIdRequests(), 1L, TimeUnit.SECONDS);
                    return;
                }
                long value = (Long)res.get(0);
                long allocationSize = (Long)res.get(1);
                this.start.set(value);
                this.counter.set(allocationSize);
                CompletableFuture<Long> pp = this.queue.poll();
                if (pp != null) {
                    this.counter.decrementAndGet();
                    pp.complete(this.start.get());
                }
                this.handleIdRequests();
            });
        }
    }

    @Override
    public RFuture<Long> nextIdAsync() {
        CompletableFuture promise = new CompletableFuture();
        this.queue.add(promise);
        this.startIdRequestsHandle();
        return new CompletableFutureWrapper<Long>(promise);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getAllocationSizeName());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return super.sizeInMemoryAsync(Arrays.asList(this.getRawName(), this.getAllocationSizeName()));
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.getAllocationSizeName());
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.getAllocationSizeName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.getAllocationSizeName());
    }
}

