/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.util.Pool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class Kryo5Codec
extends BaseCodec {
    private final Pool<Kryo> kryoPool;
    private final Pool<Input> inputPool;
    private final Pool<Output> outputPool;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Kryo kryo = (Kryo)Kryo5Codec.this.kryoPool.obtain();
            Input input = (Input)Kryo5Codec.this.inputPool.obtain();
            try {
                input.setInputStream(new ByteBufInputStream(buf));
                Object object = kryo.readClassAndObject(input);
                return object;
            }
            finally {
                Kryo5Codec.this.kryoPool.free(kryo);
                Kryo5Codec.this.inputPool.free(input);
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            Kryo kryo = (Kryo)Kryo5Codec.this.kryoPool.obtain();
            Output output = (Output)Kryo5Codec.this.outputPool.obtain();
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                output.setOutputStream(baos);
                kryo.writeClassAndObject(output, in);
                output.flush();
                ByteBuf byteBuf = baos.buffer();
                return byteBuf;
            }
            catch (RuntimeException e) {
                out.release();
                throw e;
            }
            finally {
                Kryo5Codec.this.kryoPool.free(kryo);
                Kryo5Codec.this.outputPool.free(output);
            }
        }
    };

    public Kryo5Codec() {
        this(null);
    }

    public Kryo5Codec(ClassLoader classLoader, Kryo5Codec codec) {
        this(classLoader);
    }

    public Kryo5Codec(final ClassLoader classLoader) {
        this.kryoPool = new Pool<Kryo>(true, false, 1024){

            @Override
            protected Kryo create() {
                return Kryo5Codec.this.createKryo(classLoader);
            }
        };
        this.inputPool = new Pool<Input>(true, false, 512){

            @Override
            protected Input create() {
                return new Input(8192);
            }
        };
        this.outputPool = new Pool<Output>(true, false, 512){

            @Override
            protected Output create() {
                return new Output(8192, -1);
            }
        };
    }

    protected Kryo createKryo(ClassLoader classLoader) {
        Kryo kryo = new Kryo();
        if (classLoader != null) {
            kryo.setClassLoader(classLoader);
        }
        kryo.setInstantiatorStrategy(new StdInstantiatorStrategy());
        kryo.setRegistrationRequired(false);
        kryo.setReferences(false);
        kryo.addDefaultSerializer(Throwable.class, new JavaSerializer());
        return kryo;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

