/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.redisson.MapWriteBehindTask;
import org.redisson.MapWriterTask;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonLock;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonSemaphore;
import org.redisson.ScanResult;
import org.redisson.WriteBehindService;
import org.redisson.api.AsyncIterator;
import org.redisson.api.MapOptions;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.iterator.RedissonMapIterator;
import org.redisson.mapreduce.RedissonMapReduce;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.reactive.CommandReactiveBatchService;
import org.redisson.rx.CommandRxBatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonMap<K, V>
extends RedissonExpirable
implements RMap<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final RedissonClient redisson;
    final MapOptions<K, V> options;
    final WriteBehindService writeBehindService;
    final MapWriteBehindTask writeBehindTask;

    public RedissonMap(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(commandExecutor, name);
        this.redisson = redisson;
        this.options = options;
        if (options != null && options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND && (options.getWriter() != null || options.getWriterAsync() != null)) {
            this.writeBehindService = writeBehindService;
            this.writeBehindTask = writeBehindService.start(this.getRawName(), options);
        } else {
            this.writeBehindService = null;
            this.writeBehindTask = null;
        }
    }

    public RedissonMap(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.name = name;
        this.redisson = null;
        this.options = null;
        this.writeBehindService = null;
        this.writeBehindTask = null;
    }

    public RedissonMap(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(codec, commandExecutor, name);
        this.redisson = redisson;
        this.options = options;
        if (options != null && options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND && (options.getWriter() != null || options.getWriterAsync() != null)) {
            this.writeBehindService = writeBehindService;
            this.writeBehindTask = writeBehindService.start(this.getRawName(), options);
        } else {
            this.writeBehindService = null;
            this.writeBehindTask = null;
        }
    }

    @Override
    public <KOut, VOut> RMapReduce<K, V, KOut, VOut> mapReduce() {
        return new RedissonMapReduce(this, this.redisson, this.commandExecutor);
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(K key) {
        String lockName = this.getLockByMapKey(key, "permitexpirablesemaphore");
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RSemaphore getSemaphore(K key) {
        String lockName = this.getLockByMapKey(key, "semaphore");
        return new RedissonSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RCountDownLatch getCountDownLatch(K key) {
        String lockName = this.getLockByMapKey(key, "countdownlatch");
        return new RedissonCountDownLatch(this.commandExecutor, lockName);
    }

    @Override
    public RLock getFairLock(K key) {
        String lockName = this.getLockByMapKey(key, "fairlock");
        return new RedissonFairLock(this.commandExecutor, lockName);
    }

    @Override
    public RLock getLock(K key) {
        String lockName = this.getLockByMapKey(key, "lock");
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(K key) {
        String lockName = this.getLockByMapKey(key, "rw_lock");
        return new RedissonReadWriteLock(this.commandExecutor, lockName);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        this.checkValue(value);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V oldValue = this.get(key);
            V newValue = value;
            if (oldValue != null) {
                newValue = remappingFunction.apply(oldValue, value);
            }
            if (newValue == null) {
                this.fastRemove(key);
            } else {
                this.fastPut(key, newValue);
            }
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        this.checkValue(value);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        CompletionStage f = lock.lockAsync(threadId).thenCompose(r -> {
            RFuture<V> oldValueFuture = this.getAsync(key);
            return oldValueFuture.thenCompose(oldValue -> {
                CompletableFuture<Object> newValuePromise = new CompletableFuture<Object>();
                if (oldValue != null) {
                    this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                        Object newValue;
                        try {
                            newValue = remappingFunction.apply((Object)oldValue, (Object)value);
                        }
                        catch (Exception exception) {
                            newValuePromise.completeExceptionally(exception);
                            return;
                        }
                        newValuePromise.complete(newValue);
                    });
                } else {
                    newValuePromise.complete(value);
                }
                return newValuePromise.thenCompose(newValue -> {
                    RFuture<Comparable<Boolean>> future = newValue != null ? this.fastPutAsync(key, newValue) : this.fastRemoveAsync(key);
                    return future.thenApply(res -> newValue);
                });
            }).whenComplete((c, e) -> lock.unlockAsync(threadId));
        });
        return new CompletableFutureWrapper(f);
    }

    @Override
    public RFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        CompletionStage f = lock.lockAsync(threadId).thenCompose(r -> {
            RFuture<V> oldValueFuture = this.getAsync(key);
            return oldValueFuture.thenCompose(oldValue -> {
                CompletableFuture result = new CompletableFuture();
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    Object newValue;
                    try {
                        newValue = remappingFunction.apply((K)key, (V)oldValue);
                    }
                    catch (Exception exception) {
                        result.completeExceptionally(exception);
                        return;
                    }
                    if (newValue == null) {
                        if (oldValue != null) {
                            this.fastRemoveAsync(key).whenComplete((res, exc) -> {
                                if (exc != null) {
                                    result.completeExceptionally((Throwable)exc);
                                    return;
                                }
                                result.complete(newValue);
                            });
                            return;
                        }
                    } else {
                        this.fastPutAsync(key, newValue).whenComplete((res, exc) -> {
                            if (exc != null) {
                                result.completeExceptionally((Throwable)exc);
                                return;
                            }
                            result.complete(newValue);
                        });
                        return;
                    }
                    result.complete(newValue);
                });
                return result;
            }).whenComplete((c, e) -> lock.unlockAsync(threadId));
        });
        return new CompletableFutureWrapper(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue == null) {
                if (oldValue != null) {
                    this.fastRemove(key);
                }
            } else {
                this.fastPut(key, newValue);
            }
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        Objects.requireNonNull(mappingFunction);
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        CompletionStage f = lock.lockAsync(threadId).thenCompose(r -> {
            RFuture<V> oldValueFuture = this.getAsync(key);
            return oldValueFuture.thenCompose(oldValue -> {
                if (oldValue != null) {
                    return CompletableFuture.completedFuture(oldValue);
                }
                CompletableFuture result = new CompletableFuture();
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    Object newValue;
                    try {
                        newValue = mappingFunction.apply((K)key);
                    }
                    catch (Exception exception) {
                        result.completeExceptionally(exception);
                        return;
                    }
                    if (newValue != null) {
                        this.fastPutAsync(key, newValue).thenAccept(res -> result.complete(newValue));
                        return;
                    }
                    result.complete(null);
                });
                return result;
            }).whenComplete((c, e) -> lock.unlockAsync(threadId));
        });
        return new CompletableFutureWrapper(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        Objects.requireNonNull(mappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V value = this.get(key);
            if (value == null) {
                V newValue = mappingFunction.apply(key);
                if (newValue != null) {
                    this.fastPut(key, newValue);
                    V v = newValue;
                    return v;
                }
                V v = null;
                return v;
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        long threadId = Thread.currentThread().getId();
        CompletionStage f = lock.lockAsync(threadId).thenCompose(r -> {
            RFuture<V> oldValueFuture = this.getAsync(key);
            return oldValueFuture.thenCompose(oldValue -> {
                if (oldValue == null) {
                    return CompletableFuture.completedFuture(null);
                }
                CompletableFuture result = new CompletableFuture();
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    Object newValue;
                    try {
                        newValue = remappingFunction.apply((K)key, (V)oldValue);
                    }
                    catch (Exception exception) {
                        result.completeExceptionally(exception);
                        return;
                    }
                    if (newValue != null) {
                        RFuture<Boolean> fastPutFuture = this.fastPutAsync(key, newValue);
                        fastPutFuture.whenComplete((re, ex1) -> {
                            if (ex1 != null) {
                                result.completeExceptionally((Throwable)ex1);
                                return;
                            }
                            result.complete(newValue);
                        });
                    } else {
                        RFuture<Long> removeFuture = this.fastRemoveAsync(key);
                        removeFuture.whenComplete((re, ex1) -> {
                            if (ex1 != null) {
                                result.completeExceptionally((Throwable)ex1);
                                return;
                            }
                            result.complete(null);
                        });
                    }
                });
                return result;
            }).whenComplete((c, e) -> lock.unlockAsync(threadId));
        });
        return new CompletableFutureWrapper(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            throw new IllegalStateException("This method doesn't work in batch mode.");
        }
        this.checkKey(key);
        Objects.requireNonNull(remappingFunction);
        RLock lock = this.getLock(key);
        lock.lock();
        try {
            V oldValue = this.get(key);
            if (oldValue == null) {
                V v = null;
                return v;
            }
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                this.fastPut(key, newValue);
                V v = newValue;
                return v;
            }
            this.fastRemove(key);
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HLEN, this.getRawName());
    }

    @Override
    public int valueSize(K key) {
        return this.get(this.valueSizeAsync(key));
    }

    @Override
    public RFuture<Integer> valueSizeAsync(K key) {
        this.checkKey(key);
        String name = this.getRawName(key);
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HSTRLEN, name, this.encodeMapKey(key));
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("map key can't be null");
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.containsKeyAsync(key));
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        this.checkKey(key);
        CompletableFuture promise = new CompletableFuture();
        return this.containsKeyAsync(key, promise);
    }

    protected RFuture<Boolean> containsKeyOperationAsync(String name, Object key) {
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HEXISTS, name, this.encodeMapKey(key));
    }

    protected RFuture<Boolean> containsKeyAsync(Object key, CompletableFuture<V> promise) {
        String name = this.getRawName(key);
        RFuture<Boolean> future = this.containsKeyOperationAsync(name, key);
        if (this.hasNoLoader()) {
            return future;
        }
        CompletionStage result = future.thenCompose(res -> {
            if (!res.booleanValue()) {
                CompletableFuture<V> f = this.loadValue(key, false);
                this.commandExecutor.transfer(f, promise);
                return promise.thenApply(r -> r != null);
            }
            promise.complete(null);
            return CompletableFuture.completedFuture(res);
        });
        return new CompletableFutureWrapper<Boolean>(result);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get(this.containsValueAsync(value));
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkValue(value);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local s = redis.call('hvals', KEYS[1]);for i = 1, #s, 1 do if ARGV[1] == s[i] then return 1 end end;return 0", Collections.singletonList(this.getRawName()), this.encodeMapValue(value));
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        return this.get(this.getAllAsync(keys));
    }

    @Override
    public Set<K> randomKeys(int count) {
        return this.get(this.randomKeysAsync(count));
    }

    @Override
    public Map<K, V> randomEntries(int count) {
        return this.get(this.randomEntriesAsync(count));
    }

    @Override
    public RFuture<Set<K>> randomKeysAsync(int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HRANDFIELD_KEYS, this.getRawName(), count);
    }

    @Override
    public RFuture<Map<K, V>> randomEntriesAsync(int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HRANDFIELD, this.getRawName(), count, "WITHVALUES");
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        if (keys.isEmpty()) {
            return new CompletableFutureWrapper(Collections.emptyMap());
        }
        RFuture<Map<K, V>> future = this.getAllOperationAsync(keys);
        if (this.hasNoLoader()) {
            return future;
        }
        CompletionStage f = future.thenCompose(res -> {
            if (!res.keySet().containsAll(keys)) {
                HashSet newKeys = new HashSet(keys);
                newKeys.removeAll(res.keySet());
                CompletionStage ff = this.loadAllMapAsync(newKeys.spliterator(), false, 1);
                return ff.thenApply(map -> {
                    res.putAll(map);
                    return res;
                });
            }
            return CompletableFuture.completedFuture(res);
        });
        return new CompletableFutureWrapper<Map<K, V>>(f);
    }

    protected boolean hasNoLoader() {
        return this.options == null || this.options.getLoader() == null && this.options.getLoaderAsync() == null;
    }

    public RFuture<Map<K, V>> getAllOperationAsync(Set<K> keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.size() + 1);
        args.add(this.getRawName());
        this.encodeMapKeys(args, keys);
        RFuture<Map<K, V>> future = this.commandExecutor.readAsync(this.getRawName(), this.codec, new RedisCommand<Object>("HMGET", new MapValueDecoder(new MapGetAllDecoder(new ArrayList<Object>(keys), 0))), args.toArray());
        return future;
    }

    @Override
    public V get(Object key) {
        return this.get(this.getAsync(key));
    }

    @Override
    public V put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    @Override
    public V remove(Object key) {
        return this.get(this.removeAsync(key));
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.get(this.putAllAsync(map));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, int batchSize) {
        this.get(this.putAllAsync(map, batchSize));
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, int batchSize) {
        HashMap batch = new HashMap();
        AtomicInteger counter = new AtomicInteger();
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        CompletionStage<Void> f = this.putAllAsync(batch, iter, counter, batchSize);
        return new CompletableFutureWrapper<Void>(f);
    }

    private CompletionStage<Void> putAllAsync(Map<K, V> batch, Iterator<Map.Entry<K, V>> iter, AtomicInteger counter, int batchSize) {
        batch.clear();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            batch.put(entry.getKey(), entry.getValue());
            counter.incrementAndGet();
            if (counter.get() % batchSize != 0) continue;
            RFuture<Void> future = this.putAllAsync(batch);
            return future.thenCompose(res -> this.putAllAsync(batch, iter, counter, batchSize));
        }
        if (batch.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.putAllAsync(batch);
    }

    @Override
    public final RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<Void> future = this.putAllOperationAsync(map);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(map));
    }

    protected final <M> RFuture<M> mapWriterFuture(RFuture<M> future, MapWriterTask task) {
        return this.mapWriterFuture(future, task, r -> true);
    }

    protected final <M> RFuture<M> mapWriterFuture(RFuture<M> future, MapWriterTask task, Function<M, Boolean> condition) {
        if (this.options != null && this.options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND) {
            CompletionStage<Object> f = future.whenComplete((res, e) -> {
                if (e == null && ((Boolean)condition.apply(res)).booleanValue()) {
                    this.writeBehindTask.addTask(task);
                }
            });
            return new CompletableFutureWrapper<Object>(f);
        }
        CompletionStage f = future.thenCompose(res -> {
            if (((Boolean)condition.apply(res)).booleanValue()) {
                if (this.options.getWriter() != null) {
                    CompletableFuture promise = new CompletableFuture();
                    this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                        try {
                            if (task instanceof MapWriterTask.Add) {
                                this.options.getWriter().write(task.getMap());
                            } else {
                                this.options.getWriter().delete(task.getKeys());
                            }
                        }
                        catch (Exception ex) {
                            promise.completeExceptionally(ex);
                            return;
                        }
                        promise.complete(res);
                    });
                    return promise;
                }
                if (task instanceof MapWriterTask.Add) {
                    return this.options.getWriterAsync().write(task.getMap()).thenApply(r -> res);
                }
                return this.options.getWriterAsync().delete(task.getKeys()).thenApply(r -> res);
            }
            return CompletableFuture.completedFuture(res);
        });
        return new CompletableFutureWrapper(f);
    }

    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map) {
        ArrayList<Object> params = new ArrayList<Object>(map.size() * 2 + 1);
        params.add(this.getRawName());
        this.encodeMapKeys(params, map);
        RFuture<Void> future = this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.HMSET, params.toArray());
        return future;
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(null);
    }

    @Override
    public Set<K> keySet(String pattern) {
        return this.keySet(pattern, 10);
    }

    @Override
    public Set<K> keySet(String pattern, int count) {
        return new KeySet(pattern, count);
    }

    @Override
    public Set<K> keySet(int count) {
        return this.keySet(null, count);
    }

    @Override
    public Collection<V> values() {
        return this.values(null);
    }

    @Override
    public Collection<V> values(String keyPattern, int count) {
        return new Values(keyPattern, count);
    }

    @Override
    public Collection<V> values(String keyPattern) {
        return this.values(keyPattern, 10);
    }

    @Override
    public Collection<V> values(int count) {
        return this.values(null, count);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(String keyPattern) {
        return this.entrySet(keyPattern, 10);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(String keyPattern, int count) {
        return new EntrySet(keyPattern, count);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(int count) {
        return this.entrySet(null, count);
    }

    @Override
    public Set<K> readAllKeySet() {
        return this.get(this.readAllKeySetAsync());
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HKEYS, this.getRawName());
    }

    @Override
    public Collection<V> readAllValues() {
        return this.get(this.readAllValuesAsync());
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HVALS, this.getRawName());
    }

    @Override
    public Set<Map.Entry<K, V>> readAllEntrySet() {
        return this.get(this.readAllEntrySetAsync());
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HGETALL_ENTRY, this.getRawName());
    }

    @Override
    public Map<K, V> readAllMap() {
        return this.get(this.readAllMapAsync());
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.HGETALL, this.getRawName());
    }

    @Override
    public V putIfExists(K key, V value) {
        return this.get(this.putIfExistsAsync(key, value));
    }

    @Override
    public RFuture<V> putIfExistsAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<V> future = this.putIfExistsOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Objects::nonNull);
    }

    protected RFuture<V> putIfExistsOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[1]); if value ~= false then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return value; end; return nil; ", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.get(this.putIfAbsentAsync(key, value));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<V> future = this.putIfAbsentOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Objects::isNull);
    }

    protected boolean hasNoWriter() {
        return this.options == null || this.options.getWriter() == null && this.options.getWriterAsync() == null;
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteNoRetryAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hsetnx', KEYS[1], ARGV[1], ARGV[2]) == 1 then return nil else return redis.call('hget', KEYS[1], ARGV[1]) end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value) {
        return this.get(this.fastPutIfAbsentAsync(key, value));
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastPutIfAbsentOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.HSETNX, name, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPutIfExists(K key, V value) {
        return this.get(this.fastPutIfExistsAsync(key, value));
    }

    @Override
    public RFuture<Boolean> fastPutIfExistsAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastPutIfExistsOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastPutIfExistsOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[1]); if value ~= false then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return 1; end; return 0; ", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get(this.removeAsync(key, value));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.removeOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Remove listener = new MapWriterTask.Remove(key);
        return this.mapWriterFuture(future, listener, Function.identity());
    }

    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        String name = this.getRawName(key);
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
        return future;
    }

    protected void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("map value can't be null");
        }
    }

    protected void encodeMapKeys(Collection<Object> params, Map<?, ?> map) {
        try {
            for (Map.Entry<?, ?> t : map.entrySet()) {
                this.checkKey(t.getKey());
                this.checkValue(t.getValue());
                params.add(this.encodeMapKey(t.getKey()));
                params.add(this.encodeMapValue(t.getValue()));
            }
        }
        catch (Exception e) {
            params.forEach((? super T v) -> ReferenceCountUtil.safeRelease(v));
            throw e;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.get(this.replaceAsync(key, oldValue, newValue));
    }

    @Override
    public RFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.checkKey(key);
        if (oldValue == null) {
            throw new NullPointerException("map oldValue can't be null");
        }
        if (newValue == null) {
            throw new NullPointerException("map newValue can't be null");
        }
        RFuture<Boolean> future = this.replaceOperationAsync(key, oldValue, newValue);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, newValue);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); return 1; else return 0; end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.get(this.replaceAsync(key, value));
    }

    @Override
    public RFuture<V> replaceAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<V> future = this.replaceOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r != null);
    }

    protected RFuture<V> replaceOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v; else return nil; end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastReplace(K key, V value) {
        return this.get(this.fastReplaceAsync(key, value));
    }

    @Override
    public RFuture<Boolean> fastReplaceAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastReplaceOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, Function.identity());
    }

    protected RFuture<Boolean> fastReplaceOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return 1; else return 0; end", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    public RFuture<V> getOperationAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.readAsync(name, this.codec, RedisCommands.HGET, name, this.encodeMapKey(key));
    }

    @Override
    public RFuture<V> getAsync(K key) {
        this.checkKey(key);
        RFuture<V> future = this.getOperationAsync(key);
        if (this.hasNoLoader()) {
            return future;
        }
        long threadId = Thread.currentThread().getId();
        CompletionStage f = future.thenCompose(res -> {
            if (res == null) {
                return this.loadValue(key, false, threadId);
            }
            return CompletableFuture.completedFuture(res);
        });
        return new CompletableFutureWrapper(f);
    }

    @Override
    public void loadAll(boolean replaceExistingValues, int parallelism) {
        this.get(this.loadAllAsync(replaceExistingValues, parallelism));
    }

    @Override
    public RFuture<Void> loadAllAsync(boolean replaceExistingValues, int parallelism) {
        if (this.hasNoLoader()) {
            throw new NullPointerException("MapLoader isn't defined");
        }
        if (this.options.getLoaderAsync() != null) {
            return this.loadAllAsync(this.options.getLoaderAsync().loadAllKeys(), replaceExistingValues, parallelism);
        }
        return this.loadAllAsync(() -> this.options.getLoader().loadAllKeys().spliterator(), replaceExistingValues, parallelism);
    }

    @Override
    RFuture<Void> loadAllAsync(AsyncIterator<K> iterator, boolean replaceExistingValues, int parallelism) {
        CompletionStage<List<K>> f = this.loadAllAsync(iterator, new ArrayList(), new AtomicInteger(parallelism));
        CompletionStage ff = f.thenCompose(elements -> {
            ArrayList futures = new ArrayList(elements.size());
            for (Object k : elements) {
                CompletableFuture<Object> vFuture;
                if (replaceExistingValues) {
                    vFuture = this.loadValue(k, true);
                    futures.add(vFuture);
                    continue;
                }
                vFuture = new CompletableFuture();
                this.containsKeyAsync(k, vFuture);
                futures.add(vFuture);
            }
            CompletableFuture<Void> finalFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            if (elements.size() < parallelism) {
                return finalFuture;
            }
            return finalFuture.thenCompose(v -> this.loadAllAsync(iterator, replaceExistingValues, parallelism));
        });
        return new CompletableFutureWrapper<Void>(ff);
    }

    CompletionStage<List<K>> loadAllAsync(AsyncIterator<K> iterator, List<K> elements, AtomicInteger workers) {
        return iterator.hasNext().thenCompose(v -> {
            int s = workers.decrementAndGet();
            if (v.booleanValue()) {
                return iterator.next().thenCompose(k -> {
                    if (k != null) {
                        elements.add(k);
                    }
                    if (s > 0) {
                        return this.loadAllAsync(iterator, elements, workers);
                    }
                    return CompletableFuture.completedFuture(elements);
                });
            }
            return CompletableFuture.completedFuture(elements);
        });
    }

    @Override
    private RFuture<Void> loadAllAsync(Supplier<Spliterator<K>> supplier, boolean replaceExistingValues, int parallelism) {
        ForkJoinPool customThreadPool = new ForkJoinPool(parallelism);
        CompletableFuture result = new CompletableFuture();
        customThreadPool.submit(() -> {
            try {
                Stream<Object> s = StreamSupport.stream((Spliterator)supplier.get(), true);
                List<CompletableFuture> r = s.filter(k -> k != null).map(k -> {
                    if (replaceExistingValues) {
                        return this.loadValue(k, true).thenApply(v -> null);
                    }
                    CompletableFuture valuePromise = new CompletableFuture();
                    this.containsKeyAsync(k, valuePromise);
                    return valuePromise.thenApply(v -> null);
                }).collect(Collectors.toList());
                CompletableFuture<Void> ff = CompletableFuture.allOf(r.toArray(new CompletableFuture[0]));
                ff.thenApply(v -> {
                    customThreadPool.shutdown();
                    return result.complete(v);
                });
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return new CompletableFutureWrapper<Void>(result);
    }

    protected CompletionStage<Map<K, V>> loadAllMapAsync(Spliterator<K> spliterator, boolean replaceExistingValues, int parallelism) {
        ForkJoinPool customThreadPool = new ForkJoinPool(parallelism);
        ConcurrentHashMap map = new ConcurrentHashMap();
        CompletableFuture result = new CompletableFuture();
        customThreadPool.submit(() -> {
            try {
                Stream<Object> s = StreamSupport.stream(spliterator, true);
                List<CompletableFuture> r = s.filter(k -> k != null).map(k -> {
                    if (replaceExistingValues) {
                        return this.loadValue(k, true).thenApply(v -> map.put(k, v));
                    }
                    CompletableFuture valuePromise = new CompletableFuture();
                    this.containsKeyAsync(k, valuePromise);
                    return valuePromise.thenApply(v -> {
                        if (v == null) {
                            return false;
                        }
                        return map.put(k, v);
                    });
                }).collect(Collectors.toList());
                CompletableFuture<Void> ff = CompletableFuture.allOf(r.toArray(new CompletableFuture[0]));
                ff.thenApply(v -> {
                    customThreadPool.shutdown();
                    return result.complete(map);
                });
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        this.get(this.loadAllAsync(keys, replaceExistingValues, parallelism));
    }

    @Override
    public RFuture<Void> loadAllAsync(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        return this.loadAllAsync(() -> keys.spliterator(), replaceExistingValues, parallelism);
    }

    @Override
    public RFuture<V> putAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<V> future = this.putOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<V> putOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(name), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public RFuture<V> removeAsync(K key) {
        this.checkKey(key);
        RFuture<V> future = this.removeOperationAsync(key);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Remove(key));
    }

    protected RFuture<V> removeOperationAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hdel', KEYS[1], ARGV[1]); return v", Collections.singletonList(name), this.encodeMapKey(key));
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        RFuture<Boolean> future = this.fastPutOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.writeAsync(name, this.codec, RedisCommands.HSET, name, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPut(K key, V value) {
        return this.get(this.fastPutAsync(key, value));
    }

    @Override
    public RFuture<Long> fastRemoveAsync(K ... keys) {
        if (keys == null) {
            throw new NullPointerException();
        }
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        if (this.hasNoWriter()) {
            return this.fastRemoveOperationAsync(keys);
        }
        RFuture<List<Long>> removeFuture = this.fastRemoveOperationBatchAsync(keys);
        CompletionStage f = removeFuture.thenCompose(res -> {
            if (res.isEmpty()) {
                return CompletableFuture.completedFuture(0L);
            }
            ArrayList<Object> deletedKeys = new ArrayList<Object>();
            for (int i = 0; i < res.size(); ++i) {
                if ((Long)res.get(i) != 1L) continue;
                deletedKeys.add(keys[i]);
            }
            if (this.options.getWriteMode() == MapOptions.WriteMode.WRITE_BEHIND) {
                MapWriterTask.Remove task = new MapWriterTask.Remove(deletedKeys);
                this.writeBehindTask.addTask(task);
                return CompletableFuture.completedFuture(Long.valueOf(deletedKeys.size()));
            }
            if (this.options.getWriter() != null) {
                CompletableFuture future = new CompletableFuture();
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    try {
                        this.options.getWriter().delete(deletedKeys);
                    }
                    catch (Exception ex) {
                        future.completeExceptionally(ex);
                        return;
                    }
                    future.complete(Long.valueOf(deletedKeys.size()));
                });
                return future;
            }
            return this.options.getWriterAsync().delete(deletedKeys).thenApply(r -> deletedKeys.size());
        });
        return new CompletableFutureWrapper<Long>(f);
    }

    protected RFuture<List<Long>> fastRemoveOperationBatchAsync(K ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length);
        this.encodeMapKeys(args, Arrays.asList(keys));
        RFuture<List<Long>> future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for i = 1, #ARGV, 1 do local val = redis.call('hdel', KEYS[1], ARGV[i]); table.insert(result, val); end;return result;", Arrays.asList(this.getRawName()), args.toArray());
        return future;
    }

    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(this.getRawName());
        this.encodeMapKeys(args, Arrays.asList(keys));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.HDEL, args.toArray());
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.get(this.fastRemoveAsync(keys));
    }

    public ScanResult<Map.Entry<Object, Object>> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        RFuture<ScanResult<Map.Entry<Object, Object>>> f = this.scanIteratorAsync(name, client, startPos, pattern, count);
        return this.get(f);
    }

    public RFuture<ScanResult<Map.Entry<Object, Object>>> scanIteratorAsync(String name, RedisClient client, long startPos, String pattern, int count) {
        if (pattern == null) {
            RFuture<ScanResult<Map.Entry<Object, Object>>> f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.HSCAN, name, startPos, "COUNT", count);
            return f;
        }
        RFuture<ScanResult<Map.Entry<Object, Object>>> f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.HSCAN, name, startPos, "MATCH", pattern, "COUNT", count);
        return f;
    }

    @Override
    public V addAndGet(K key, Number value) {
        return this.get(this.addAndGetAsync(key, value));
    }

    @Override
    public RFuture<V> addAndGetAsync(final K key, Number value) {
        this.checkKey(key);
        this.checkValue(value);
        final RFuture<V> future = this.addAndGetOperationAsync(key, value);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(){

            @Override
            public Map<K, V> getMap() {
                return Collections.singletonMap(key, RedissonMap.this.commandExecutor.getNow(future.toCompletableFuture()));
            }
        });
    }

    protected RFuture<V> addAndGetOperationAsync(K key, Number value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String name = this.getRawName(key);
        RFuture future = this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("HINCRBYFLOAT", new NumberConvertor(value.getClass())), name, keyState, new BigDecimal(value.toString()).toPlainString());
        return future;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    protected Iterator<K> keyIterator(String pattern, int count) {
        return new RedissonMapIterator<K>(this, pattern, count){

            @Override
            protected K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        };
    }

    protected Iterator<V> valueIterator(String pattern, int count) {
        return new RedissonMapIterator<V>(this, pattern, count){

            @Override
            protected V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        };
    }

    protected Iterator<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return new RedissonMapIterator<Map.Entry<K, V>>(this, pattern, count);
    }

    protected CompletableFuture<V> loadValue(K key, boolean replaceValue) {
        return this.loadValue(key, replaceValue, Thread.currentThread().getId());
    }

    protected CompletableFuture<V> loadValue(K key, boolean replaceValue, long threadId) {
        RLock lock = this.getLock(key);
        return lock.lockAsync(threadId).thenCompose(res -> {
            if (replaceValue) {
                return this.loadValue(key, lock, threadId);
            }
            return this.getOperationAsync(key).thenCompose(r -> {
                if (r != null) {
                    return lock.unlockAsync(threadId).thenApply(v -> r);
                }
                return this.loadValue(key, lock, threadId);
            });
        }).whenComplete((r, e) -> {
            if (e != null) {
                lock.unlockAsync(threadId);
            }
        }).toCompletableFuture();
    }

    private CompletableFuture<V> loadValue(final K key, final RLock lock, final long threadId) {
        if (this.options.getLoader() != null) {
            final CompletableFuture result = new CompletableFuture();
            this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Object value;
                    try {
                        value = RedissonMap.this.options.getLoader().load(key);
                        if (value == null) {
                            lock.unlockAsync(threadId).whenComplete((r, e) -> {
                                if (e != null) {
                                    result.completeExceptionally((Throwable)e);
                                    return;
                                }
                                result.complete(value);
                            });
                            return;
                        }
                    }
                    catch (Exception e2) {
                        RedissonMap.this.log.error("Unable to load value by key {} for map {}", key, RedissonMap.this.getRawName(), e2);
                        lock.unlockAsync(threadId).whenComplete((r, ex) -> {
                            if (ex != null) {
                                result.completeExceptionally((Throwable)ex);
                                return;
                            }
                            result.complete(null);
                        });
                        return;
                    }
                    RedissonMap.this.putOperationAsync(key, value).whenComplete((res, e) -> {
                        if (e != null) {
                            lock.unlockAsync(threadId);
                            result.completeExceptionally((Throwable)e);
                            return;
                        }
                        lock.unlockAsync(threadId).whenComplete((r, ex) -> {
                            if (ex != null) {
                                result.completeExceptionally((Throwable)ex);
                                return;
                            }
                            result.complete(value);
                        });
                    });
                }
            });
            return result;
        }
        CompletionStage<V> valueFuture = this.options.getLoaderAsync().load(key);
        return valueFuture.handle((r, ex) -> {
            if (r == null) {
                return lock.unlockAsync(threadId);
            }
            if (ex != null) {
                this.log.error("Unable to load value by key {} for map {}", key, this.getRawName(), ex);
                return lock.unlockAsync(threadId);
            }
            return valueFuture;
        }).thenCompose(f -> f).thenCompose(value -> {
            if (value != null) {
                return this.putOperationAsync(key, value).handle((r, ex) -> {
                    RFuture<Void> f = lock.unlockAsync(threadId);
                    if (ex != null) {
                        this.log.error("Unable to store value by key {} for map {}", key, this.getRawName(), ex);
                        return f;
                    }
                    return f.thenApply(res -> value);
                }).thenCompose(f -> f);
            }
            return CompletableFuture.completedFuture(value);
        }).toCompletableFuture();
    }

    @Override
    public void destroy() {
        if (this.writeBehindService != null) {
            this.writeBehindService.stop(this.getRawName());
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private final String pattern;
        private final int count;

        KeySet(String pattern, int count) {
            this.pattern = pattern;
            this.count = count;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Iterator<K> iterator() {
            return RedissonMap.this.keyIterator(this.pattern, this.count);
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonMap.this.fastRemove(o) == 1L;
        }

        @Override
        public int size() {
            if (this.pattern != null) {
                int size = 0;
                for (Object val : this) {
                    ++size;
                }
                return size;
            }
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final String keyPattern;
        private final int count;

        Values(String keyPattern, int count) {
            this.keyPattern = keyPattern;
            this.count = count;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Iterator<V> iterator() {
            return RedissonMap.this.valueIterator(this.keyPattern, this.count);
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMap.this.containsValue(o);
        }

        @Override
        public int size() {
            if (this.keyPattern != null) {
                int size = 0;
                for (Object val : this) {
                    ++size;
                }
                return size;
            }
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final String keyPattern;
        private final int count;

        EntrySet(String keyPattern, int count) {
            this.keyPattern = keyPattern;
            this.count = count;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return RedissonMap.this.entryIterator(this.keyPattern, this.count);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = RedissonMap.this.get(key);
            return value != null && value.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonMap.this.remove(key, value);
            }
            return false;
        }

        @Override
        public int size() {
            if (this.keyPattern != null) {
                int size = 0;
                for (Map.Entry val : this) {
                    ++size;
                }
                return size;
            }
            return RedissonMap.this.size();
        }

        @Override
        public void clear() {
            RedissonMap.this.clear();
        }
    }
}

