/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisAuthRequiredException;
import org.redisson.client.RedisBusyException;
import org.redisson.client.RedisClusterDownException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisOutOfMemoryException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ReplayingDecoder<State> {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char ZERO = '0';
    final String scheme;

    public CommandDecoder(String scheme) {
        this.scheme = scheme;
    }

    protected QueueCommandHolder getCommand(ChannelHandlerContext ctx) {
        Queue queue = ctx.channel().attr(CommandsQueue.COMMANDS_QUEUE).get();
        return (QueueCommandHolder)queue.peek();
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        QueueCommandHolder holder = this.getCommand(ctx);
        QueueCommand data = null;
        if (holder != null) {
            data = holder.getCommand();
        }
        if (this.state() == null) {
            this.state(new State());
        }
        if (data == null) {
            while (in.writerIndex() > in.readerIndex()) {
                int endIndex = this.skipCommand(in);
                try {
                    this.decode(ctx, in, null, 0);
                }
                catch (Exception e) {
                    in.readerIndex(endIndex);
                    throw e;
                }
            }
        } else {
            if (!holder.getChannelPromise().isSuccess()) {
                this.sendNext(ctx.channel());
                in.indexOf(0x3FFFFFFF, Integer.MAX_VALUE, (byte)0);
                return;
            }
            int endIndex = 0;
            endIndex = !(data instanceof CommandsData) ? this.skipCommand(in) : this.skipBatchCommand(in, (CommandsData)data);
            if (data.isExecuted()) {
                in.readerIndex(endIndex);
                this.sendNext(ctx.channel());
                return;
            }
            this.decode(ctx, in, data, endIndex);
        }
    }

    private int skipBatchCommand(ByteBuf in, CommandsData data) throws IOException {
        int commandsAmount = 1;
        if (!data.isSkipResult()) {
            commandsAmount = data.getCommands().size();
        }
        in.markReaderIndex();
        for (int i = 0; i < commandsAmount; ++i) {
            this.skipDecode(in);
        }
        int endIndex = in.readerIndex();
        in.resetReaderIndex();
        return endIndex;
    }

    private void decode(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, int endIndex) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("reply: {}, channel: {}, command: {}", in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), ctx.channel(), data);
        }
        this.decodeCommand(ctx.channel(), in, data, endIndex);
    }

    protected void sendNext(Channel channel, QueueCommand data) {
        if (data != null) {
            if (data.isExecuted()) {
                this.sendNext(channel);
            }
        } else {
            this.sendNext(channel);
        }
    }

    protected int skipCommand(ByteBuf in) throws Exception {
        in.markReaderIndex();
        this.skipDecode(in);
        int res = in.readerIndex();
        in.resetReaderIndex();
        return res;
    }

    protected void skipDecode(ByteBuf in) throws IOException {
        byte code = in.readByte();
        if (code == 43) {
            this.skipString(in);
        } else if (code == 45) {
            this.skipString(in);
        } else if (code == 58) {
            this.skipString(in);
        } else if (code == 36) {
            this.skipBytes(in);
        } else if (code == 42) {
            long size = this.readLong(in);
            int i = 0;
            while ((long)i < size) {
                this.skipDecode(in);
                ++i;
            }
        }
    }

    private void skipBytes(ByteBuf is) throws IOException {
        long l = this.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return;
        }
        is.skipBytes(size + 2);
    }

    private void skipString(ByteBuf in) {
        int len = in.bytesBefore((byte)13);
        in.skipBytes(len + 2);
    }

    protected void decodeCommand(Channel channel, ByteBuf in, QueueCommand data, int endIndex) throws Exception {
        if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                this.decode(in, cmd, null, channel, false, null);
                this.sendNext(channel, data);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. channel: " + channel + ", reply: " + LogHelper.toString(in) + ", command: " + LogHelper.toString(data), e);
                in.readerIndex(endIndex);
                this.sendNext(channel);
                cmd.tryFailure(e);
                throw e;
            }
        }
        if (data instanceof CommandsData) {
            CommandsData commands = (CommandsData)data;
            try {
                this.decodeCommandBatch(channel, in, commands);
            }
            catch (Exception e) {
                in.readerIndex(endIndex);
                this.sendNext(channel);
                commands.getPromise().completeExceptionally(e);
                throw e;
            }
        }
        try {
            while (in.writerIndex() > in.readerIndex()) {
                this.decode(in, null, null, channel, false, null);
            }
            this.sendNext(channel);
        }
        catch (Exception e) {
            this.log.error("Unable to decode data. channel: " + channel + ", reply: " + LogHelper.toString(in), e);
            this.sendNext(channel);
            throw e;
        }
    }

    protected void sendNext(Channel channel) {
        Queue queue = channel.attr(CommandsQueue.COMMANDS_QUEUE).get();
        queue.poll();
        this.state(null);
    }

    private void decodeCommandBatch(Channel channel, ByteBuf in, CommandsData commandBatch) throws Exception {
        int i = ((State)this.state()).getBatchIndex();
        Throwable error = null;
        while (in.writerIndex() > in.readerIndex()) {
            CommandData<Object, Object> commandData;
            block13: {
                commandData = null;
                if (commandBatch.getCommands().size() == i) break;
                this.checkpoint();
                ((State)this.state()).setBatchIndex(i);
                int endIndex = this.skipCommand(in);
                try {
                    RedisCommand<?> cmd = commandBatch.getCommands().get(i).getCommand();
                    boolean skipConvertor = commandBatch.isQueued();
                    List<CommandData<?, ?>> commandsData = null;
                    if (!commandBatch.isAtomic() || RedisCommands.EXEC.getName().equals(cmd.getName()) || RedisCommands.WAIT.getName().equals(cmd.getName())) {
                        commandData = commandBatch.getCommands().get(i);
                        if (RedisCommands.EXEC.getName().equals(cmd.getName())) {
                            skipConvertor = false;
                            commandsData = commandBatch.getAttachedCommands() != null ? commandBatch.getAttachedCommands() : commandBatch.getCommands();
                        }
                    }
                    this.decode(in, commandData, null, channel, skipConvertor, commandsData);
                    if (commandData == null || !RedisCommands.EXEC.getName().equals(commandData.getCommand().getName()) || !commandData.getPromise().isDone() || commandData.getPromise().isCompletedExceptionally()) break block13;
                    List objects = commandData.getPromise().getNow(null);
                    Iterator iter = objects.iterator();
                    boolean multiFound = false;
                    for (CommandData<Object, Object> commandData2 : commandBatch.getCommands()) {
                        if (multiFound) {
                            if (!iter.hasNext()) break;
                            Object res = iter.next();
                            this.completeResponse(commandData2, res);
                        }
                        if (!RedisCommands.MULTI.getName().equals(commandData2.getCommand().getName())) continue;
                        multiFound = true;
                    }
                }
                catch (Exception e) {
                    in.readerIndex(endIndex);
                    if (commandData == null) break block13;
                    commandData.tryFailure(e);
                }
            }
            if (i == 0 && commandBatch.isSkipResult() && commandBatch.isSyncSlaves()) {
                this.checkpoint();
                ((State)this.state()).setBatchIndex(commandBatch.getCommands().size() - 1);
                return;
            }
            ++i;
            if (commandData == null || commandData.isSuccess()) continue;
            error = commandData.cause();
        }
        if (commandBatch.isSkipResult() || i == commandBatch.getCommands().size()) {
            CompletableFuture<Void> promise = commandBatch.getPromise();
            if (error != null) {
                promise.completeExceptionally(error);
            } else {
                promise.complete(null);
            }
            this.sendNext(channel);
        } else {
            this.checkpoint();
            ((State)this.state()).setBatchIndex(i);
        }
    }

    protected void decode(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, boolean skipConvertor, List<CommandData<?, ?>> commandsData) throws IOException {
        byte code = in.readByte();
        if (code == 43) {
            String result = this.readString(in);
            this.handleResult(data, parts, result, skipConvertor);
        } else if (code == 45) {
            String error = this.readString(in);
            if (error.startsWith("MOVED")) {
                String[] errorParts = error.split(" ");
                int slot = Integer.valueOf(errorParts[1]);
                String addr = errorParts[2];
                data.tryFailure(new RedisMovedException(slot, new RedisURI(this.scheme + "://" + addr)));
            } else if (error.startsWith("ASK")) {
                String[] errorParts = error.split(" ");
                int slot = Integer.valueOf(errorParts[1]);
                String addr = errorParts[2];
                data.tryFailure(new RedisAskException(slot, new RedisURI(this.scheme + "://" + addr)));
            } else if (error.startsWith("TRYAGAIN")) {
                data.tryFailure(new RedisTryAgainException(error + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("LOADING")) {
                data.tryFailure(new RedisLoadingException(error + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("OOM")) {
                data.tryFailure(new RedisOutOfMemoryException(error.split("OOM ")[1] + ". channel: " + channel + " data: " + data));
            } else if (error.contains("-OOM ")) {
                data.tryFailure(new RedisOutOfMemoryException(error.split("-OOM ")[1] + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("NOAUTH")) {
                data.tryFailure(new RedisAuthRequiredException(error + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("CLUSTERDOWN")) {
                data.tryFailure(new RedisClusterDownException(error + ". channel: " + channel + " data: " + data));
            } else if (error.startsWith("BUSY")) {
                data.tryFailure(new RedisBusyException(error + ". channel: " + channel + " data: " + data));
            } else if (data != null) {
                data.tryFailure(new RedisException(error + ". channel: " + channel + " command: " + LogHelper.toString(data)));
            } else {
                this.log.error("Error message from Redis: {} channel: {}", (Object)error, (Object)channel);
            }
        } else if (code == 58) {
            Long result = this.readLong(in);
            this.handleResult(data, parts, result, false);
        } else if (code == 36) {
            ByteBuf buf = this.readBytes(in);
            Object result = null;
            if (buf != null) {
                Decoder<Object> decoder = this.selectDecoder(data, parts);
                result = decoder.decode(buf, (State)this.state());
            }
            this.handleResult(data, parts, result, false);
        } else if (code == 42) {
            long size = this.readLong(in);
            ArrayList<Object> respParts = new ArrayList<Object>(Math.max((int)size, 0));
            ((State)this.state()).incLevel();
            this.decodeList(in, data, parts, channel, size, respParts, skipConvertor, commandsData);
            ((State)this.state()).decLevel();
        } else {
            String dataStr = in.toString(0, in.writerIndex(), CharsetUtil.UTF_8);
            throw new IllegalStateException("Can't decode replay: " + dataStr);
        }
    }

    private String readString(ByteBuf in) {
        int len = in.bytesBefore((byte)13);
        String result = in.toString(in.readerIndex(), len, CharsetUtil.UTF_8);
        in.skipBytes(len + 2);
        return result;
    }

    private void decodeList(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, long size, List<Object> respParts, boolean skipConvertor, List<CommandData<?, ?>> commandsData) throws IOException {
        MultiDecoder<Object> decoder;
        int i;
        if (parts == null && commandsData != null) {
            i = respParts.size();
            while ((long)i < size) {
                int suffix = 0;
                if (RedisCommands.MULTI.getName().equals(commandsData.get(0).getCommand().getName())) {
                    suffix = 1;
                }
                CommandData<Object, Object> commandData = commandsData.get(i + suffix);
                this.decode(in, commandData, respParts, channel, skipConvertor, commandsData);
                if (commandData.getPromise().isDone() && commandData.getPromise().isCompletedExceptionally()) {
                    data.tryFailure(commandData.cause());
                }
                ++i;
            }
        } else {
            i = respParts.size();
            while ((long)i < size) {
                this.decode(in, data, respParts, channel, skipConvertor, null);
                ++i;
            }
        }
        if ((decoder = this.messageDecoder(data, respParts)) == null) {
            return;
        }
        Object result = decoder.decode(respParts, (State)this.state());
        this.decodeResult(data, parts, channel, result);
    }

    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, Object result) throws IOException {
        if (data != null) {
            this.handleResult(data, parts, result, true);
        }
    }

    private void handleResult(CommandData<Object, Object> data, List<Object> parts, Object result, boolean skipConvertor) {
        if (data != null && !skipConvertor) {
            result = data.getCommand().getConvertor().convert(result);
        }
        if (parts != null) {
            parts.add(result);
        } else {
            this.completeResponse(data, result);
        }
    }

    protected void completeResponse(CommandData<Object, Object> data, Object result) {
        if (data != null) {
            data.getPromise().complete(result);
        }
    }

    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null && parts.isEmpty()) {
            return null;
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null) {
            return StringCodec.INSTANCE.getValueDecoder();
        }
        MultiDecoder<Object> multiDecoder = data.getCommand().getReplayMultiDecoder();
        Integer size = Optional.ofNullable(parts).map(List::size).orElse(0);
        return multiDecoder.getDecoder(data.getCodec(), size, (State)this.state());
    }

    private ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = this.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    private long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }
}

