/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.io.File;
import java.io.IOException;
import jodd.cache.AbstractCacheMap;
import jodd.cache.Cache;
import jodd.io.FileUtil;

public abstract class FileCache {
    protected final Cache<File, byte[]> cache;
    protected final int maxSize;
    protected final int maxFileSize;
    protected final long timeout;
    protected int usedSize;

    protected FileCache(int maxSize, int maxFileSize, long timeout) {
        this.maxSize = maxSize;
        this.maxFileSize = maxFileSize;
        this.timeout = timeout;
        this.cache = this.createCache();
    }

    protected abstract Cache<File, byte[]> createCache();

    protected AbstractCacheMap.CacheObject<File, byte[]> createFileCacheObject(final File fileKey, byte[] object, long timeout) {
        return new AbstractCacheMap.CacheObject<File, byte[]>(fileKey, object, timeout){

            @Override
            boolean isExpired() {
                if (fileKey.lastModified() > this.lastAccess) {
                    this.lastAccess = fileKey.lastModified();
                }
                return super.isExpired();
            }
        };
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int usedSize() {
        return this.usedSize;
    }

    public int maxFileSize() {
        return this.maxFileSize;
    }

    public int cachedFilesCount() {
        return this.cache.size();
    }

    public long cacheTimeout() {
        return this.cache.timeout();
    }

    public void clear() {
        this.cache.clear();
        this.usedSize = 0;
    }

    public byte[] getFileBytes(File file) throws IOException {
        byte[] bytes = this.cache.get(file);
        if (bytes != null) {
            return bytes;
        }
        bytes = FileUtil.readBytes(file);
        if (this.maxFileSize != 0 && file.length() > (long)this.maxFileSize) {
            return bytes;
        }
        this.usedSize += bytes.length;
        this.cache.put(file, bytes);
        return bytes;
    }
}

